/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.converter;

import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.beanutils.ConversionException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.converter.NuitonConverter;

public class LocaleConverter
implements NuitonConverter<Locale> {
    private static final Pattern FULL_SCOPE_PATTERN = Pattern.compile("([a-zA-Z]{2})_([a-zA-Z]{2})");
    private static final Pattern MEDIUM_SCOPE_PATTERN = Pattern.compile("([a-zA-Z]{2})");
    private static final Log LOGGER = LogFactory.getLog(LocaleConverter.class);

    public <T> T convert(Class<T> aClass, Object value) {
        if (value == null) {
            throw new ConversionException("can not convert null value in " + this + " convertor");
        }
        if (this.isEnabled(aClass)) {
            if (this.isEnabled(value.getClass())) {
                Object result = value;
                return aClass.cast(result);
            }
            if (value instanceof String) {
                Locale result = this.valueOf(((String)value).trim());
                return aClass.cast(result);
            }
        }
        throw new ConversionException("could not find a convertor for type " + aClass.getName() + " and value : " + value);
    }

    public Locale valueOf(String value) {
        Locale result = this.convertFullScope(value);
        if (result == null) {
            result = this.convertMediumScope(value);
        }
        if (result == null) {
            throw new ConversionException("could not convert locale " + value);
        }
        return result;
    }

    private Locale convertFullScope(String value) {
        Matcher m = FULL_SCOPE_PATTERN.matcher(value);
        if (m.matches()) {
            String language = m.group(1).toLowerCase();
            String country = m.group(2).toUpperCase();
            return new Locale(language, country);
        }
        return null;
    }

    private Locale convertMediumScope(String value) {
        Matcher m = MEDIUM_SCOPE_PATTERN.matcher(value);
        if (m.matches()) {
            String language = m.group(1).toLowerCase();
            return new Locale(language);
        }
        return null;
    }

    public LocaleConverter() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("init locale converter : " + this));
        }
    }

    protected boolean isEnabled(Class<?> aClass) {
        return Locale.class.equals(aClass);
    }

    @Override
    public Class<Locale> getType() {
        return Locale.class;
    }
}

