/*
 * #%L
 * Maven helper plugin
 * 
 * $Author: tchemit $
 * $LastChangedDate: 2010-04-12 12:59:27 +0200 (lun., 12 avril 2010) $
 * $LastChangedRevision: 693 $
 * $Id: DefaultRestClientConfiguration.java 693 2010-04-12 10:59:27Z tchemit $
 * $HeadURL: http://svn.nuiton.org/svn/maven-helper-plugin/tags/maven-helper-plugin-1.2.3/src/main/java/org/nuiton/io/rest/DefaultRestClientConfiguration.java $
 * %%
 * Copyright (C) 2009 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

package org.nuiton.io.rest;

import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

import java.net.URL;

/**
 * Default implementation of a {@link RestClientConfiguration}.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 1.0.3
 */
public class DefaultRestClientConfiguration implements RestClientConfiguration {

    URL restUrl;

    String restUsername;

    String restPassword;

    boolean verbose;

    boolean anonymous;

    String encoding;

    @Override
    public String getEncoding() {
        return encoding;
    }

    @Override
    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    @Override
    public String getRestPassword() {
        return restPassword;
    }

    @Override
    public void setRestPassword(String restPassword) {
        this.restPassword = restPassword;
    }

    @Override
    public URL getRestUrl() {
        return restUrl;
    }

    @Override
    public void setRestUrl(URL restUrl) {
        this.restUrl = restUrl;
    }

    @Override
    public String getRestUsername() {
        return restUsername;
    }

    @Override
    public void setRestUsername(String restUsername) {
        this.restUsername = restUsername;
    }

    @Override
    public boolean isVerbose() {
        return verbose;
    }

    @Override
    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public boolean isAnonymous() {
        return anonymous;
    }

    public void setAnonymous(boolean anonymous) {
        this.anonymous = anonymous;
    }

    @Override
    public String toString() {
        ToStringBuilder b = new ToStringBuilder(this,
                                                ToStringStyle.MULTI_LINE_STYLE
        );
        b.append("redmineUrl", restUrl);
        if (anonymous) {

            b.append("anonymous", anonymous);
        } else {
            b.append("redmineUsername", restUsername);
            b.append("redminePassword", "***");
        }
        b.append("encoding", encoding);
        b.append("verbose", verbose);
        return b.toString();
    }
}
