/*
 * *##% 
 * Maven helper plugin
 * Copyright (C) 2009 CodeLutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * ##%*
 */
package org.nuiton.license;

import org.junit.Assert;

import java.io.File;
import java.io.IOException;
import org.nuiton.plugin.TestHelper;
/**
 *
 * @author chemit
 * @deprecated since 1.0.3, move all license stuff in maven-license-plugin
 */
@Deprecated
public abstract class BaseLicenseTestCase extends Assert {

    protected static final String encoding = "utf-8";
    protected File baseDir;

    protected File getBaseDir() {
        if (baseDir == null) {
            baseDir = TestHelper.getBasedir();
        }
        return baseDir;
    }

    protected void assertLicenseFound(String name, License license) throws IOException {
        assertNotNull(license);
        assertEquals(name, license.getName());
        assertNotNull(license.getLicenseContent(encoding));
        assertNotNull(license.getHeaderContent(encoding));
    }

    protected File createLicenseRepository(boolean createLicene) throws IOException {
        long timestamp = System.currentTimeMillis();

        File repo = TestHelper.getFile(getBaseDir(), "target", "licenses_" + timestamp);

        if (createLicene) {

            String licenseName = "dummy_" + timestamp;
            addLicenseToRepository(repo, licenseName);
        }
        return repo;
    }

    protected void addLicenseToRepository(File repo, String licenseName) throws IOException {

        File defFile = new File(repo, "licenses.properties");

        String content = "";
        if (defFile.exists()) {

            content = TestHelper.readAsString(defFile, encoding) + "\n";
        }

        TestHelper.writeString(defFile, content + licenseName + "=My dummy license\n", encoding);

        // create dummy licenses
        File file = new File(repo, licenseName);
        file.mkdirs();
        TestHelper.writeString(new File(file, "license.txt"), "license:" + licenseName, encoding);
        TestHelper.writeString(new File(file, "header.txt"), "header:" + licenseName, encoding);

    }
}

