/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.license;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import org.junit.Test;
import org.nuiton.license.BaseLicenseTestCase;
import org.nuiton.license.JarLicenseResolver;
import org.nuiton.license.License;

public class JarLicenseResolverTest
extends BaseLicenseTestCase {
    @Test(expected=IllegalArgumentException.class)
    public void testResolvFailed1() throws Exception {
        new JarLicenseResolver().resolv(null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testResolvFailed2() throws Exception {
        new JarLicenseResolver().resolv("");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testResolvFailed3() throws Exception {
        new JarLicenseResolver().resolv("  ");
    }

    @Test
    public void testResolv() throws Exception {
        JarLicenseResolver resolver = new JarLicenseResolver();
        String name = "dummy_" + System.currentTimeMillis();
        License license = resolver.resolv(name);
        JarLicenseResolverTest.assertNull((Object)license);
        for (String name2 : new String[]{"gpl_v1", "gpl_v2", "gpl_v3", "lgpl_v2_1", "lgpl_v3"}) {
            License license2 = resolver.resolv(name2);
            this.assertLicenseFound(name2, license2);
        }
    }

    @Test
    public void testGetLicenseNames() throws Exception {
        JarLicenseResolver resolver = new JarLicenseResolver();
        Map licenseNames = resolver.getLicenseNames();
        JarLicenseResolverTest.assertEquals(Arrays.asList("gpl_v1", "gpl_v2", "gpl_v3", "lgpl_v2_1", "lgpl_v3"), new ArrayList(licenseNames.keySet()));
    }
}

