/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jrst;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import org.apache.maven.doxia.logging.Log;
import org.apache.maven.doxia.module.xdoc.XdocParser;
import org.apache.maven.doxia.parser.ParseException;
import org.apache.maven.doxia.sink.Sink;
import org.apache.maven.doxia.siterenderer.RenderingContext;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.IOUtil;
import org.dom4j.Document;
import org.nuiton.jrst.JRST;
import org.nuiton.jrst.JRSTToXmlStrategy;
import org.nuiton.util.FileUtil;

public abstract class AbstractJrstParser
extends XdocParser {
    public static final String JRST_PARSER_ID = "jrst";
    protected RenderingContext renderingContext;
    protected MavenProject mavenProject;
    protected boolean verbose;

    public abstract JRSTToXmlStrategy getStrategy();

    public void parse(Reader source, Sink sink) throws ParseException {
        try {
            File sourceFile = this.prepareSourceFile(this.getLog(), source);
            Document doc = this.getStrategy().generateRstToXml(sourceFile, "UTF-8");
            doc = JRST.generateXml((Document)doc, (String)"xdoc");
            StringReader reader = new StringReader(doc.asXML());
            super.parse((Reader)reader, sink);
        }
        catch (Exception e) {
            throw new ParseException("Can't parse rst file", e);
        }
        finally {
            this.clear();
        }
    }

    public void setRenderingContext(RenderingContext renderingContext) {
        this.renderingContext = renderingContext;
    }

    public void setMavenProject(MavenProject mavenProject) {
        this.mavenProject = mavenProject;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected File prepareSourceFile(Log log, Reader source) throws IOException {
        File sourceFile;
        if (this.mavenProject == null) {
            sourceFile = File.createTempFile("source", "rst");
        } else {
            File tempDirectory = new File(this.mavenProject.getBasedir(), "target" + File.separator + "generated-jrst");
            sourceFile = new File(tempDirectory, this.renderingContext.getInputName());
            FileUtil.createDirectoryIfNecessary((File)sourceFile.getParentFile());
        }
        if (this.verbose) {
            log.info((CharSequence)("Transform rst file: " + sourceFile));
            if (log.isDebugEnabled()) {
                log.info((CharSequence)("Copy " + this.renderingContext.getInputName() + " to  " + sourceFile));
            }
        }
        try (FileWriter fileWriter = new FileWriter(sourceFile);){
            IOUtil.copy((Reader)source, (Writer)fileWriter);
        }
        return sourceFile;
    }

    public void clear() {
        this.renderingContext = null;
        this.mavenProject = null;
        this.verbose = false;
    }
}

