package org.nuiton.jredmine.model.io.xpp3;

import org.nuiton.io.xpp3.AbstractXpp3Reader;
import static org.nuiton.io.xpp3.Xpp3Helper.addTagTextContentMappers;
import org.nuiton.jredmine.model.TimeEntry;

import java.beans.IntrospectionException;

/**
 * Created: 31 déc. 2009
 *
 * @author Tony Chemit <chemit@codelutin.com> Copyright Code Lutin
 * @version $Revision: 61 $
 *          <p/>
 *          Mise a jour: $Date: 2010-01-01 18:35:21 +0100 (ven., 01 janv. 2010) $ par :
 *          $Author: tchemit $
 */
public class TimeEntryXpp3Reader extends AbstractXpp3Reader<TimeEntry> {

    public TimeEntryXpp3Reader() {
        super(TimeEntry.class, "time-entries", "time-entry");
    }

    @Override
    protected void initMappers() throws IntrospectionException {

        addTagTextContentMappers(TimeEntry.class, RedmineDataConverter.Integer, true, allMappers,
                "id",
                "activity-id",
                "issue-id",
                "project-id",
                "user-id",
                "tyear",
                "tmonth",
                "tweek"
        );

        addTagTextContentMappers(TimeEntry.class, RedmineDataConverter.Float, true, allMappers,
                "hours"
        );

        addTagTextContentMappers(TimeEntry.class, RedmineDataConverter.Datetime, true, allMappers,
                "created-on",
                "updated-on");

        addTagTextContentMappers(TimeEntry.class, RedmineDataConverter.Date, true, allMappers,
                "spent-on");

        addTagTextContentMappers(TimeEntry.class, RedmineDataConverter.Text, true, allMappers,
                "comments");
    }
}
