/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jaxx.runtime.swing.log;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Level;
import org.apache.log4j.Priority;
import org.apache.log4j.WriterAppender;
import org.apache.log4j.spi.LoggingEvent;

public class JAXXLog4jAppender
extends WriterAppender {
    public static final String PROPERTY_LOGS = "logs";
    public static final String PROPERTY_LEVEL = "level";
    protected final List<LoggingEvent> events;
    protected StringBuilder logs;
    protected Level level;
    protected final PropertyChangeSupport pcs = new PropertyChangeSupport((Object)this);

    public JAXXLog4jAppender() {
        this.events = new LinkedList<LoggingEvent>();
        this.logs = new StringBuilder();
    }

    public String getLogs() {
        return this.logs.toString();
    }

    public void setLogs(String logs) {
        String oldValue = this.getLogs();
        this.logs = new StringBuilder(logs);
        this.firePropertyChange(PROPERTY_LOGS, oldValue, logs);
    }

    public Level getLevel() {
        if (this.level == null) {
            this.level = Level.ALL;
        }
        return this.level;
    }

    public void setLevel(Level level) {
        Level oldValue = this.getLevel();
        this.level = level;
        this.firePropertyChange(PROPERTY_LEVEL, oldValue, level);
        this.updateLogs();
    }

    public void append(LoggingEvent event) {
        super.append(event);
        if (event != null) {
            this.events.add(event);
            this.updateLog(event);
        }
    }

    protected void updateLogs() {
        String oldValue = this.getLogs();
        this.logs = new StringBuilder();
        for (LoggingEvent event : this.events) {
            this.updateLog(event);
        }
        this.firePropertyChange(PROPERTY_LOGS, oldValue, this.getLogs());
    }

    protected void updateLog(LoggingEvent event) {
        Level level = event.getLevel();
        if (this.getLevel() != null && level.isGreaterOrEqual((Priority)this.getLevel())) {
            String[] errorLogs;
            String log = this.layout.format(event);
            this.appendLog(log);
            if (this.layout.ignoresThrowable() && (errorLogs = event.getThrowableStrRep()) != null) {
                for (String errorLog : errorLogs) {
                    this.appendLog(errorLog + "\n");
                }
            }
        }
    }

    protected void appendLog(String log) {
        String oldValue = this.getLogs();
        this.logs.append(log);
        this.firePropertyChange(PROPERTY_LOGS, oldValue, this.getLogs());
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(propertyName, listener);
    }

    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        this.pcs.firePropertyChange(propertyName, oldValue, newValue);
    }

    protected void firePropertyChange(String propertyName, Object newValue) {
        this.firePropertyChange(propertyName, null, newValue);
    }
}

