/*
 * Decompiled with CFR 0.152.
 */
package jaxx.runtime.swing.log;

import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JDialog;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.swing.log.JAXXLog4jAppender;
import jaxx.runtime.swing.log.JAXXLog4jUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.log4j.Appender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;

public class JAXXLog4jHandler {
    private static final Log log = LogFactory.getLog(JAXXLog4jHandler.class);
    protected JAXXLog4jUI ui;
    protected static JAXXLog4jAppender appender;
    protected final Action closeAction = new AbstractAction("close"){
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent e) {
            JDialog container = JAXXLog4jHandler.this.ui.getParentContainer(JDialog.class);
            if (container != null) {
                container.dispose();
            } else {
                JAXXLog4jHandler.this.ui.setVisible(false);
            }
        }
    };

    public JAXXLog4jHandler(JAXXLog4jUI ui) {
        this.ui = ui;
    }

    public static void init() {
        JAXXLog4jHandler.init("INFO", "%5p [%t] (%F:%L) %M - %m%n");
    }

    public static void init(String level, String patternLayout) {
        Logger logger = Logger.getRootLogger();
        if (appender == null) {
            appender = new JAXXLog4jAppender();
            logger.addAppender((Appender)appender);
        }
        appender.setLevel(Level.toLevel((String)level));
        appender.setLayout((Layout)new PatternLayout(patternLayout));
    }

    public JAXXLog4jAppender getAppender() {
        return appender;
    }

    public void showInDialog(Frame ui, boolean undecorated) {
        JDialog f = new JDialog(ui, this.ui.getTitle(), false);
        f.add(this.ui);
        f.setResizable(true);
        f.setSize(550, 450);
        f.setUndecorated(undecorated);
        JRootPane rootPane = f.getRootPane();
        rootPane.getInputMap(2).put(KeyStroke.getKeyStroke("ESCAPE"), "close");
        rootPane.getActionMap().put("close", this.closeAction);
        f.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                Component ui = (Component)e.getSource();
                if (log.isInfoEnabled()) {
                    log.info((Object)("destroy ui " + ui));
                }
                JAXXUtil.destroy((Component)ui);
                JAXXUtil.destroy((Component)JAXXLog4jHandler.this.ui);
            }
        });
        SwingUtil.center((Component)ui, (Component)f);
        f.setVisible(true);
    }
}

