/*
 * Decompiled with CFR 0.152.
 */
package jaxx.runtime.swing.editor.gis;

import java.util.regex.Pattern;
import org.jdesktop.beans.AbstractSerializableBean;

public class DmsCoordinate
extends AbstractSerializableBean {
    public static final String COORDINATE_STRING_PATTERN = "%s%s\u00b0%s'%s''";
    public static final Pattern COORDINATE_PATTERN = Pattern.compile("(.*)\u00b0(.*)'(.*)''");
    private static final long serialVersionUID = 1L;
    public static final String PROPERTY_SIGN = "sign";
    public static final String PROPERTY_DEGREE = "degree";
    public static final String PROPERTY_MINUTE = "minute";
    public static final String PROPERTY_SECOND = "second";
    protected boolean sign;
    protected Integer degree;
    protected Integer minute;
    protected Integer second;

    public static DmsCoordinate empty() {
        DmsCoordinate r = new DmsCoordinate();
        return r;
    }

    public static DmsCoordinate valueOf(DmsCoordinate decimal) {
        DmsCoordinate r = new DmsCoordinate();
        if (decimal != null) {
            r.setSign(decimal.isSign());
            r.setDegree(decimal.getDegree());
            r.setMinute(decimal.getMinute());
            r.setSecond(decimal.getSecond());
        }
        return r;
    }

    public static DmsCoordinate valueOf(Float decimal) {
        DmsCoordinate r = new DmsCoordinate();
        r.fromDecimal(decimal);
        return r;
    }

    public static DmsCoordinate valueOf(boolean sign, Integer d, Integer m, Integer s) {
        DmsCoordinate r = new DmsCoordinate();
        r.setSign(sign);
        r.setDegree(d);
        r.setMinute(m);
        r.setSecond(s);
        return r;
    }

    public boolean isSign() {
        return this.sign;
    }

    public Integer getDegree() {
        return this.degree;
    }

    public Integer getMinute() {
        return this.minute;
    }

    public Integer getSecond() {
        return this.second;
    }

    public void setSign(boolean sign) {
        Boolean oldValue = this.isSign();
        this.sign = sign;
        this.firePropertyChange(PROPERTY_SIGN, oldValue, sign);
    }

    public void setDegree(Integer degree) {
        Integer oldValue = this.getDegree();
        this.degree = degree;
        this.firePropertyChange(PROPERTY_DEGREE, oldValue, degree);
    }

    public void setMinute(Integer minute) {
        Integer oldValue = this.getMinute();
        this.minute = minute;
        this.firePropertyChange(PROPERTY_MINUTE, oldValue, minute);
    }

    public void setSecond(Integer second) {
        Integer oldValue = this.getSecond();
        this.second = second;
        this.firePropertyChange(PROPERTY_SECOND, oldValue, second);
    }

    public boolean isDegreeNull() {
        return this.degree == null || this.degree == 0;
    }

    public boolean isMinuteNull() {
        return this.minute == null || this.minute == 0;
    }

    public boolean isSecondNull() {
        return this.second == null || this.second == 0;
    }

    public boolean isNull() {
        return this.degree == null && this.minute == null && this.second == null;
    }

    public void fromDecimal(Float decimal) {
        Integer d = null;
        Integer m = null;
        Integer s = null;
        boolean si = false;
        if (decimal != null) {
            Integer n;
            Integer n2;
            si = decimal.floatValue() < 0.0f;
            decimal = Float.valueOf(Math.abs(decimal.floatValue()));
            int remain = 0;
            d = (int)(Math.round((double)decimal.floatValue() + 0.5) - 1L);
            m = 0;
            s = 0;
            if ((decimal = Float.valueOf(60.0f * (decimal.floatValue() - (float)d.intValue()))).floatValue() > 0.0f) {
                m = (int)(Math.round((double)decimal.floatValue() + 0.5) - 1L);
                if ((decimal = Float.valueOf(60.0f * (decimal.floatValue() - (float)m.intValue()))).floatValue() > 0.0f) {
                    s = (int)(Math.round((double)decimal.floatValue() + 0.5) - 1L);
                    remain = (int)(10.0f * (decimal.floatValue() - (float)s.intValue()));
                }
            }
            if (remain > 9) {
                n2 = s;
                n = s = Integer.valueOf(s + 1);
            }
            if (s == 60) {
                n2 = m;
                n = m = Integer.valueOf(m + 1);
                s = 0;
            }
            if (m == 60) {
                n2 = d;
                n = d = Integer.valueOf(d + 1);
                m = 0;
            }
        }
        this.degree = d;
        this.minute = m;
        this.second = s;
        this.sign = si;
        if (decimal != null) {
            this.removeTrailingZero();
        }
    }

    public Float toDecimal() {
        if (this.isNull()) {
            return null;
        }
        Integer d = this.getNotNullDegree();
        Integer m = this.getNotNullMinute();
        Integer s = this.getNotNullSecond();
        Float result = Float.valueOf(d.intValue());
        if (m > 0) {
            result = Float.valueOf(result.floatValue() + (float)m.intValue() / 60.0f);
            if (s == 0) {
                result = Float.valueOf(result.floatValue() + 1.3888889E-4f);
            }
        }
        if (s > 0) {
            result = Float.valueOf(result.floatValue() + ((float)s.intValue() + 0.5f) / 3600.0f);
        }
        if (this.sign) {
            result = Float.valueOf(result.floatValue() * -1.0f);
        }
        return result;
    }

    public DmsCoordinate addTrailingZero() {
        if (this.degree == null) {
            this.degree = 0;
        }
        if (this.minute == null) {
            this.minute = 0;
        }
        if (this.second == null) {
            this.second = 0;
        }
        return this;
    }

    public DmsCoordinate removeTrailingZero() {
        if (this.degree != null && this.degree == 0) {
            this.degree = null;
        }
        if (this.minute != null && this.minute == 0) {
            this.minute = null;
        }
        if (this.second != null && this.second == 0) {
            this.second = null;
        }
        return this;
    }

    public Integer getSignedDegree() {
        Integer result = null;
        if (!this.isDegreeNull()) {
            result = this.degree;
            if (this.isSign()) {
                result = result * -1;
            }
        }
        return result;
    }

    public int getNotNullDegree() {
        return this.isDegreeNull() ? 0 : this.degree;
    }

    public int getNotNullMinute() {
        return this.isMinuteNull() ? 0 : this.minute;
    }

    public int getNotNullSecond() {
        return this.isSecondNull() ? 0 : this.second;
    }

    public boolean isLatitudeDegreeValid() {
        boolean result = this.isDegreeValid(false);
        return result;
    }

    public boolean isLongitudeDegreeValid() {
        boolean result = this.isDegreeValid(true);
        return result;
    }

    public boolean isMinuteValid() {
        boolean result = true;
        if (!this.isMinuteNull()) {
            result = 60 == this.minute ? this.isSecondNull() : 0 <= this.minute && this.minute < 60;
        }
        return result;
    }

    public boolean isSecondValid() {
        boolean result = this.isSecondNull() || 0 <= this.second && this.second < 60;
        return result;
    }

    public String toString() {
        return "DmsCoordinateComponent{sign=" + this.sign + ", degree=" + this.degree + ", minute=" + this.minute + ", second=" + this.second + '}';
    }

    protected boolean isDegreeValid(boolean longitude) {
        boolean result = true;
        if (!this.isDegreeNull()) {
            int bound;
            int n = bound = longitude ? 180 : 90;
            result = bound == this.degree ? this.isMinuteNull() && this.isSecondNull() : this.degree < bound;
        }
        return result;
    }
}

