/*
 * Decompiled with CFR 0.152.
 */
package jaxx.runtime.swing.editor.bean;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.ListModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.beans.AbstractSerializableBean;

public class BeanDoubleListModel<O>
extends AbstractSerializableBean {
    private static final Log log = LogFactory.getLog(BeanDoubleListModel.class);
    public static final String PROPERTY_ADD_ENABLED = "addEnabled";
    public static final String PROPERTY_REMOVE_ENABLED = "removeEnabled";
    private static final long serialVersionUID = 1L;
    protected List<O> universe = new ArrayList<O>();
    protected ListModel universeModel = new DefaultListModel();
    protected List<O> selected = new ArrayList<O>();
    protected ListModel selectedModel = new DefaultListModel();
    protected boolean addEnabled;
    protected boolean removeEnabled;

    public List<O> getSelected() {
        return this.selected;
    }

    public void setSelected(List<O> selected) {
        this.resetUniverse();
        if (selected == null) {
            selected = Lists.newArrayList();
        }
        this.selected.clear();
        ((DefaultListModel)this.selectedModel).clear();
        this.addToSelected(selected);
    }

    public List<O> getUniverse() {
        return this.universe;
    }

    public void setUniverse(List<O> universe) {
        if (universe == null) {
            universe = Lists.newArrayList();
        }
        this.universe = Lists.newArrayList((Iterable)universe);
        this.resetUniverse();
    }

    protected void resetUniverse() {
        ((DefaultListModel)this.universeModel).clear();
        for (O item : this.universe) {
            ((DefaultListModel)this.universeModel).addElement(item);
        }
    }

    public ListModel getSelectedModel() {
        return this.selectedModel;
    }

    public void setSelectedModel(ListModel selectedModel) {
        this.selectedModel = selectedModel;
    }

    public ListModel getUniverseModel() {
        return this.universeModel;
    }

    public void setUniverseModel(ListModel universeModel) {
        this.universeModel = universeModel;
    }

    public void addToSelected(O item) {
        this.selected.add(item);
        ((DefaultListModel)this.selectedModel).addElement(item);
        ((DefaultListModel)this.universeModel).removeElement(item);
    }

    public void addToSelected(List<O> items) {
        this.selected.addAll(items);
        for (O item : items) {
            ((DefaultListModel)this.selectedModel).addElement(item);
            ((DefaultListModel)this.universeModel).removeElement(item);
        }
    }

    public void removeFromSelected(O item) {
        this.selected.remove(item);
        ((DefaultListModel)this.selectedModel).removeElement(item);
        this.addToUniverseList(item);
    }

    public void removeFromSelected(List<O> items) {
        this.selected.removeAll(items);
        for (O item : items) {
            ((DefaultListModel)this.selectedModel).removeElement(item);
            this.addToUniverseList(item);
        }
    }

    public boolean isAddEnabled() {
        return this.addEnabled;
    }

    public void setAddEnabled(boolean addEnabled) {
        boolean oldValue = this.isAddEnabled();
        this.addEnabled = addEnabled;
        this.firePropertyChange(PROPERTY_ADD_ENABLED, oldValue, addEnabled);
    }

    public boolean isRemoveEnabled() {
        return this.removeEnabled;
    }

    public void setRemoveEnabled(boolean removeEnabled) {
        boolean oldValue = this.isRemoveEnabled();
        this.removeEnabled = removeEnabled;
        this.firePropertyChange(PROPERTY_REMOVE_ENABLED, oldValue, removeEnabled);
    }

    protected void addToUniverseList(O item) {
        DefaultListModel universeDefaultListModel = (DefaultListModel)this.universeModel;
        int index = this.universe.indexOf(item);
        int insertionIndex = Math.min(index, universeDefaultListModel.getSize());
        while (insertionIndex > 0) {
            Object o;
            int oIndex;
            if ((oIndex = this.universe.indexOf(o = universeDefaultListModel.get(--insertionIndex))) >= index) continue;
            ++insertionIndex;
            break;
        }
        universeDefaultListModel.add(insertionIndex, item);
    }
}

