package jaxx.runtime.swing.editor.config;
/*
 * #%L
 * JAXX :: Widgets
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2008 - 2012 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Container;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.ListSelectionModel;
import javax.swing.ScrollPaneConstants;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.editor.config.model.CategoryModel;
import jaxx.runtime.swing.editor.config.model.ConfigTableModel;
import jaxx.runtime.swing.editor.config.model.ConfigUIModel;
import jaxx.runtime.swing.editor.config.model.OptionModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static org.nuiton.i18n.I18n._;
import static org.nuiton.i18n.I18n.n_;

public class ConfigCategoryUI extends JPanel implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_CATEGORY_MODEL = "categoryModel";
    public static final String PROPERTY_SELECTION_MODEL = "selectionModel";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_RESET_ENABLED = "reset.enabled";
    public static final String BINDING_SAVE_ENABLED = "save.enabled";
    public static final String BINDING_TABLE_PANE_COLUMN_HEADER_VIEW = "tablePane.columnHeaderView";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVWz28bRRSeuHF+uWlKoiYplMo1JUpEu04KqIcgWsckiqtNXNlOWpJDGHsn9pTxzjI7jp1GRfwFwJ8Ady5I3DghDpw5cEH9FxDiwBXxZna967W3OBE5bOyd933ve2/mfePv/kBJV6Bbz3CnY4iWLWmTGI9yT58Wq89ITX5E3JqgjuQCeX8jCZQ4RCkreO9K9NahqeBZH57N86bDbWL3oNdNNOXKU0bcBiFSojejiJrrZsvB8nrHaYkuayAqjvWbv/5MfG198W0CoY4D6maglPQwVFjJqIkS1JJoFjKd4CzDdh1kCGrXQe+0epdn2HV3cZN8hj5H4yYac7AAMoky5y9Zc2h8x5Fo4vajx9gmbFWitYhStw15DWJRwBo1bh/TOqhX//JYkjoXp3sFx9FEYxIlm9wiTKL3hnLoQJ9pr7CjvoU00zWfe+eCdL2wkG5K4iojPtf9C0mrBMiQ7opLGBxCym2f8qbak47PZVJXliMBIXK2W5eJq4TphsPLXrS3Cyp8crAbGtUP0C9V5GIAmNT1KiaJFiLB5ZrgTCeOpkhqRD+1Ll5F3AwCu+dkTX1/PUoy0x0/KLybIq0et4OQVE+IRNei2UhH5gTBKnRpIOG9IGHIlhTEVWM7F+HZaEnJbRXyThA56uITrSfrvxfojcg5gFE3wlEPZ3HkELK04LVEi4eD7lCCJc8XFvt8QRHq1X/m53778eUPW10zSEHua7GhPV4GQ+oI7hAhqUo94zlBS1KW3cHO+iGa9M6gNrobMcLK/jKIg3yvKbih4MY2dhtAkRz//aef5z/59RJKbKEpxrG1hVV8AQ5PA9ra4MzqOA8eakWX2xPwvKq0wTBVce3TuuAtGyxq+izPGUzOk+1CZfNFB/pwI6YPgZjq5C9/z5W/f9jtxQhou/7K8LAfyQM0Rm1GbaKt0Xe9WCtMOS5pWTx0tzi/Q7Gj6PiDel8/1+OKv1rjrNW0twm2iNinpC3RwZlN2mlvDJePljO+ifQc9MzKnXRZnc09tQF1IsHvsI3rROS0SRQAspyh9jEXTdwFrK2uQD+VkAe6UepTDg0O2TDRSbCDY15rud6AJ48xg5lBoxKmTaL0WajY5gbXtIZ3toiVWXmh0ba869LngEqswf0wodyyj03wNhzEkXfjFPfO/DC1l2JbvHim86nWaUvy1paVuoUTNSM1zDxn28DiMWe0dipR9iw0O/ByV2Jbusb+ZqlSyOfMo3K+VDTNjVzpKGc+yX1cBq7rDS7oc6g2hm01lm27WCocFHcrEb7dTUgSu3ehLw/rwyjcMrgleYmoxqtbRO2VZ8hGbq9SPCptlgsHmyDePMoXzb2dXVXBHOxDcPfkGONtYoW7NAmr24TWG7DxiXvvQ7hKkQfLlaQEQC4kNBNyixaJk+9dEueQPk5sFQmpb53BnkVu5eUVg7rwiR5TYukt9I/inH8MsRZv+NY+hYMRkeiyF3LXX0tJzlmFOhWNX4jBG5I6sZXo1QtVkhtWSXppKR0bso8ZjVQ6G1Wqrqa+QlN+od5StM75QfSrytS33jlcbYzhUw63JrrygYUlTlepbYFdfTjAOaKeU+dg7PuJpOK+imfLDGVTr7/8D4a3/zfDHWD4F3Sn5ltyDAAA";
    private static final Log log = LogFactory.getLog(ConfigCategoryUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JLabel categoryLabel;
    protected JPanel categoryLabelPanel;
    protected CategoryModel categoryModel;
    protected JTextArea description;
    protected JScrollPane descriptionPane;
    protected ConfigUIModel model;
    protected JButton reset;
    protected JButton save;
    protected ListSelectionModel selectionModel;
    protected JTable table;
    protected ConfigTableModel tableModel;
    protected JScrollPane tablePane;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private ConfigCategoryUI $JPanel0 = this;
    private JPanel $JPanel1;
    private JPanel $JPanel2;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    void $afterCompleteSetup() {
        // prepare table
        SwingUtil.setI18nTableHeaderRenderer(table,
            n_("config.key"),
            n_("config.key.tip"),
            n_("config.value"),
            n_("config.value.tip"),
            n_("config.defaultValue"),
            n_("config.defaultValue.tip"));
    
        ConfigTableRenderer renderer = new ConfigTableRenderer();
        SwingUtil.setTableColumnRenderer(table, 0, renderer);
        SwingUtil.setTableColumnRenderer(table, 1, renderer);
        SwingUtil.setTableColumnRenderer(table, 2, renderer);
        Font f = table.getFont().deriveFont(Font.ITALIC | Font.BOLD);
        int width = SwingUtil.computeTableColumnWidth(table, f, 0, "___*");
        SwingUtil.fixTableColumnWidth(table, 0, width);
        SwingUtil.setTableColumnEditor(table, 1, new ConfigTableEditor((ConfigTableModel) table.getModel()));
    }
    
    protected void updateDescriptionText() {
        OptionModel option;
        if (selectionModel.isSelectionEmpty()) {
            option = null;
        } else {
            int row = selectionModel.getAnchorSelectionIndex();
            ConfigTableModel m = (ConfigTableModel) table.getModel();
            option = m.getEntry(row);
            if (log.isDebugEnabled()) {
                log.debug(row + " : " + option);
            }
        }
        StringBuilder buffer = new StringBuilder();
        if (option == null) {
            buffer.append(_("config.no.option.selected"));
        } else {
            buffer.append(_("config.option.label", option.getKey(), _(option.getDescription()))).append('\n');
            if (option.isModified()) {
                buffer.append(_("config.option.modified", option.getOriginalValue(), option.getValue())).append('\n');
            }
            if (option.isFinal()) {
                buffer.append(_("config.option.final")).append('\n');
            }
        }
        description.setText(buffer.toString());
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public ConfigCategoryUI() {
        $initialize();
    }

    public ConfigCategoryUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ConfigCategoryUI(boolean param0) {
        super(param0);
        $initialize();
    }

    public ConfigCategoryUI(JAXXContext parentContext, boolean param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ConfigCategoryUI(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public ConfigCategoryUI(JAXXContext parentContext, LayoutManager param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ConfigCategoryUI(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public ConfigCategoryUI(JAXXContext parentContext, LayoutManager param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__reset(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        model.reset();
    }

    public void doActionPerformed__on__save(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        model.saveModified();
    }

    public void doTableChanged__on__tableModel(TableModelEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        updateDescriptionText();
    }

    public void doValueChanged__on__selectionModel(ListSelectionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        if (!event.getValueIsAdjusting()) { updateDescriptionText(); }
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JLabel getCategoryLabel() {
        return categoryLabel;
    }

    public JPanel getCategoryLabelPanel() {
        return categoryLabelPanel;
    }

    public CategoryModel getCategoryModel() {
        return categoryModel;
    }

    public JTextArea getDescription() {
        return description;
    }

    public JScrollPane getDescriptionPane() {
        return descriptionPane;
    }

    public ConfigUIModel getModel() {
        return model;
    }

    public JButton getReset() {
        return reset;
    }

    public JButton getSave() {
        return save;
    }

    public ListSelectionModel getSelectionModel() {
        return selectionModel;
    }

    public JTable getTable() {
        return table;
    }

    public ConfigTableModel getTableModel() {
        return tableModel;
    }

    public JScrollPane getTablePane() {
        return tablePane;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setCategoryModel(CategoryModel categoryModel) {
        CategoryModel oldValue = this.categoryModel;
        this.categoryModel = categoryModel;
        firePropertyChange(PROPERTY_CATEGORY_MODEL, oldValue, categoryModel);
    }

    public void setSelectionModel(ListSelectionModel selectionModel) {
        ListSelectionModel oldValue = this.selectionModel;
        this.selectionModel = selectionModel;
        firePropertyChange(PROPERTY_SELECTION_MODEL, oldValue, selectionModel);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JPanel get$JPanel1() {
        return $JPanel1;
    }

    protected JPanel get$JPanel2() {
        return $JPanel2;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToCategoryLabelPanel() {
        if (!allComponentsCreated) {
            return;
        }
        categoryLabelPanel.add(categoryLabel);
    }

    protected void addChildrenToDescriptionPane() {
        if (!allComponentsCreated) {
            return;
        }
        descriptionPane.getViewport().add(description);
    }

    protected void addChildrenToTablePane() {
        if (!allComponentsCreated) {
            return;
        }
        tablePane.getViewport().add(table);
    }

    protected void createCategoryLabel() {
        $objectMap.put("categoryLabel", categoryLabel = new JLabel());
        
        categoryLabel.setName("categoryLabel");
    }

    protected void createCategoryLabelPanel() {
        $objectMap.put("categoryLabelPanel", categoryLabelPanel = new JPanel());
        
        categoryLabelPanel.setName("categoryLabelPanel");
    }

    protected void createCategoryModel() {
        $objectMap.put("categoryModel", categoryModel = getContextValue(CategoryModel.class));
    }

    protected void createDescription() {
        $objectMap.put("description", description = new JTextArea());
        
        description.setName("description");
        description.setColumns(15);
        description.setLineWrap(true);
        description.setWrapStyleWord(true);
        description.setFocusable(false);
        if (description.getFont() != null) {
            description.setFont(description.getFont().deriveFont((float) 10));
        }
        description.setEditable(false);
        description.setRows(3);
    }

    protected void createDescriptionPane() {
        $objectMap.put("descriptionPane", descriptionPane = new JScrollPane());
        
        descriptionPane.setName("descriptionPane");
    }

    protected void createModel() {
        $objectMap.put("model", model = getContextValue(ConfigUIModel.class));
    }

    protected void createReset() {
        $objectMap.put("reset", reset = new JButton());
        
        reset.setName("reset");
        reset.setText(_("config.action.reset"));
        reset.setToolTipText(_("config.action.reset.tip"));
        reset.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__reset"));
    }

    protected void createSave() {
        $objectMap.put("save", save = new JButton());
        
        save.setName("save");
        save.setText(_("config.action.save"));
        save.setToolTipText(_("config.action.save.tip"));
        save.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__save"));
    }

    protected void createSelectionModel() {
        $objectMap.put("selectionModel", selectionModel = new DefaultListSelectionModel());
        
        selectionModel.addListSelectionListener(JAXXUtil.getEventListener(ListSelectionListener.class, "valueChanged", this, "doValueChanged__on__selectionModel"));
    }

    protected void createTable() {
        $objectMap.put("table", table = new JTable(tableModel));
        
        table.setName("table");
        table.setRowSelectionAllowed(false);
        table.setRowHeight(25);
        table.setAutoCreateRowSorter(true);
    }

    protected void createTableModel() {
        $objectMap.put("tableModel", tableModel = new ConfigTableModel(categoryModel));
        
        tableModel.addTableModelListener(JAXXUtil.getEventListener(TableModelListener.class, "tableChanged", this, "doTableChanged__on__tableModel"));
    }

    protected void createTablePane() {
        $objectMap.put("tablePane", tablePane = new JScrollPane());
        
        tablePane.setName("tablePane");
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        // inline complete setup of $JPanel0
        add(categoryLabelPanel, BorderLayout.NORTH);
        add(tablePane, BorderLayout.CENTER);
        add($JPanel1, BorderLayout.SOUTH);
        addChildrenToCategoryLabelPanel();
        addChildrenToTablePane();
        // inline complete setup of $JPanel1
        $JPanel1.add(descriptionPane, BorderLayout.CENTER);
        $JPanel1.add($JPanel2, BorderLayout.SOUTH);
        addChildrenToDescriptionPane();
        // inline complete setup of $JPanel2
        $JPanel2.add(reset);
        $JPanel2.add(save);
        
        // apply 3 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 12 property setters
        table.setSelectionModel(selectionModel);
        categoryLabelPanel.setBackground(Color.WHITE);
        tablePane.setVerticalScrollBarPolicy(ScrollPaneConstants.VERTICAL_SCROLLBAR_ALWAYS);
        tablePane.setHorizontalScrollBarPolicy(ScrollPaneConstants.HORIZONTAL_SCROLLBAR_NEVER);
        table.setAutoResizeMode(JTable.AUTO_RESIZE_ALL_COLUMNS);
        descriptionPane.setColumnHeaderView(new JLabel(_("config.description"), SwingUtil.getUIManagerActionIcon("information"), 10));
        SwingUtil.setText(description, _("config.no.option.selected"));
        
        reset.setIcon(SwingUtil.createActionIcon("config-reset"));
        save.setIcon(SwingUtil.createActionIcon("config-save"));
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$JPanel0", $JPanel0);
        createModel();
        createCategoryModel();
        createTableModel();
        createSelectionModel();
        createCategoryLabelPanel();
        createCategoryLabel();
        createTablePane();
        createTable();
        // inline creation of $JPanel1
        $objectMap.put("$JPanel1", $JPanel1 = new JPanel());
        
        $JPanel1.setName("$JPanel1");
        $JPanel1.setLayout(new BorderLayout());
        createDescriptionPane();
        createDescription();
        // inline creation of $JPanel2
        $objectMap.put("$JPanel2", $JPanel2 = new JPanel());
        
        $JPanel2.setName("$JPanel2");
        $JPanel2.setLayout(new GridLayout(1,0));
        createReset();
        createSave();
        // inline creation of $JPanel0
        setName("$JPanel0");
        setLayout(new BorderLayout());
        
        // registers 3 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 3 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_TABLE_PANE_COLUMN_HEADER_VIEW, true) {
        
            @Override
            public void applyDataBinding() {
                if (table != null) {
                    table.addPropertyChangeListener("tableHeader", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (table != null) {
                    tablePane.setColumnHeaderView(table.getTableHeader());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (table != null) {
                    table.removePropertyChangeListener("tableHeader", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_RESET_ENABLED, true, true) {
        
            @Override
            public void applyDataBinding() {
                addPropertyChangeListener("categoryModel", this);
                if (getCategoryModel() != null) {
                    getCategoryModel().addPropertyChangeListener("modified", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getCategoryModel() != null) {
                    reset.setEnabled(getCategoryModel().isModified());
                }
            }
        
            @Override
            public void removeDataBinding() {
                removePropertyChangeListener("categoryModel", this);
                if (getCategoryModel() != null) {
                    getCategoryModel().removePropertyChangeListener("modified", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SAVE_ENABLED, true, true) {
        
            @Override
            public void applyDataBinding() {
                addPropertyChangeListener("categoryModel", this);
                if (getCategoryModel() != null) {
                    getCategoryModel().addPropertyChangeListener("modified", this);
                }
                if (getCategoryModel() != null) {
                    getCategoryModel().addPropertyChangeListener("valid", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getCategoryModel() != null) {
                    save.setEnabled(getCategoryModel().isModified() && getCategoryModel().isValid());
                }
            }
        
            @Override
            public void removeDataBinding() {
                removePropertyChangeListener("categoryModel", this);
                if (getCategoryModel() != null) {
                    getCategoryModel().removePropertyChangeListener("modified", this);
                }
                if (getCategoryModel() != null) {
                    getCategoryModel().removePropertyChangeListener("valid", this);
                }
            }
        });
    }

}