/*
 * #%L
 * JAXX :: Widgets
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2008 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
package jaxx.runtime.swing;

import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.lang.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import jaxx.runtime.*;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.swing.*;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static jaxx.runtime.SwingUtil.createImageIcon;
import static org.nuiton.i18n.I18n._;

public class FontSizor extends javax.swing.JPanel implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_DEFAULT_FONT_SIZE = "defaultFontSize";
    public static final String PROPERTY_FONT_SIZE = "fontSize";
    public static final String PROPERTY_SHOW_DEFAULT_FONT_SIZE = "showDefaultFontSize";
    public static final String PROPERTY_SHOW_FONT_SIZE = "showFontSize";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_DEFAULT_SIZE_ENABLED = "defaultSize.enabled";
    public static final String BINDING_DEFAULT_SIZE_VISIBLE = "defaultSize.visible";
    public static final String BINDING_DOWN_SIZE_ENABLED = "downSize.enabled";
    public static final String BINDING_UP_SIZE_ENABLED = "upSize.enabled";

    /*-----------------------------------------------------------------------*/
    /*--------------- Constants for all none public bindings  ---------------*/
    /*-----------------------------------------------------------------------*/

    private static final String BINDING_$JLABEL0_TEXT = "$JLabel0.text";
    private static final String BINDING_$JLABEL0_VISIBLE = "$JLabel0.visible";
    private static final String BINDING_$JTOOL_BAR0_OPAQUE = "$JToolBar0.opaque";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVUzU8TQRSfVlpoy4dSrSgQQTl4MC3x4gGiCKRRrEosJoRenHandMkyM8zM0sWD8U/wT9C7FxNvnowHzx68GP8FYzx4Nb6ZbrsU+rGhPWzb9/F7v/d77+37XygmBZrfw56XFS5V9j7Jbtzf3n5a3iMVtU5kRdhcMYEan0gURUsoZbXsUqEbpYJOz/npuTW2zxkl9Fj2UgElpTpyiKwRohSabc+oSJkrttxLHndFE7VFqhPq2z+/o2+s1++iCHkc2CWhlbl+WUEnQwUUtS2FJqHSIc45mO4CDWHTXeA7pm1rDpbyCd4nB+gVGi6gOMcCwBS6Hr5lg2HyPa7QyMLGJqbEWVRopo2prEPdbJ5RVbRfMsG5yYkrNGGRKnYd5bsIWDS1rKabzTsMqyB2pOoH6f/jgT0ta6y+fhLnQoCzyphDMA0yRnVG/hhaOvAlFza2IH4VC+jiogbxfPpNuw5MBKwsVqeNkum26FVXKUZ1VKYVnPLbbdadbnfHXd7FA8oWcNkoO9lWxVj9WIGm21SHzcsGmxesRqSEYsIFs0JTpdPL+gxcjTWdOrGmGtB4/2XS3z/9/Jhv7mYGal/qGHrstGBnuGCcCGXr0hONxXSV7eQeY75UQglJHLhLc3czHYgVfTeQg3qNAev07AMsawARG/7x+UvmxbdzKJpHSVgeK491/EOUUDUBKjDH8vi9FcNotD4Cz/OaGwjv4CMG80LjyxZWeK5sUwvkveuBCDMdRGgxKSe+/k0XP6w0hYgAsStdwwMxYjsoblPHpsScqX+BHc8yxSVxLRZcWqfbi+jvJPfX+KZ53urU6ViZCYuITWxTRfTrYblBYw4reDmUXUWgaZ29aLrRv24b8MshwBNVfbG47Bjud84OFGccH7gGJXd2lCG70jjALhhXQ2AME6r7sQaEGa2yiit91XuIEwYrYbD6qBwGKKXghbZl8y3iqYGgtDnfQ6HZUAiPBkbY7NFFOITnAyPsDIQAC3doS9uf7UBi9BrItYEHEg6h10DCIfQaSDiEXgPpjwBvEeWfRxcl5kOxkH0Q/gPkxwr6rAoAAA==";
    protected static final Log log = LogFactory.getLog(jaxx.runtime.swing.FontSizor.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected java.util.List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new java.util.TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?,?> $previousValues = new java.util.HashMap<Object, Object>();
    private boolean allComponentsCreated;
    private boolean contextInitialized = true;
    protected final JAXXContext delegateContext = new jaxx.runtime.context.DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected java.lang.Float defaultFontSize;
    protected javax.swing.JButton defaultSize;
    protected javax.swing.JButton downSize;
    protected java.lang.Float fontSize;
    protected java.lang.Boolean showDefaultFontSize;
    protected java.lang.Boolean showFontSize;
    protected javax.swing.JButton upSize;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private FontSizor $JPanel0 = this;
    private javax.swing.JToolBar $JToolBar0;
    private javax.swing.JLabel $JLabel0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_FONT_SIZE_CALL_BACK = "fontSize.callBack";
    public static final String BINDING_DEFAULT_FONT_SIZE_CALL_BACK = "defaultFontSize.callBack";
    
    
    public void init() {
        if (fontSize == null) {
            setFontSize(defaultFontSize);
        }
    }
    
    boolean updateDefaultSizeEnabled(Float fontSize, Float defaultFontSize, boolean enabled) {
       if (fontSize==null || defaultFontSize==null) {
          return false;
       }
       return !fontSize.equals(defaultFontSize) && enabled;
    }
    
    public void setCallBack(final Runnable action) {
        removeDataBinding(BINDING_FONT_SIZE_CALL_BACK);
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_FONT_SIZE_CALL_BACK, true ,"fontSize") {
    
            @Override
            public void processDataBinding() {
                action.run();
            }
        });
        applyDataBinding(BINDING_FONT_SIZE_CALL_BACK);
    }
    
    void $afterCompleteSetup() {
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_DEFAULT_FONT_SIZE_CALL_BACK, true ,"defaultFontSize") {
    
            @Override
            public void processDataBinding() {
                setFontSize(defaultFontSize);
            }
        });
        //applyDataBinding(BINDING_DEFAULT_FONT_SIZE_CALL_BACK);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public FontSizor() {
        $initialize();
    }

    public FontSizor(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                $bindings.get($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__defaultSize(java.awt.event.ActionEvent event) {
        setFontSize(defaultFontSize);
    }

    public void doActionPerformed__on__downSize(java.awt.event.ActionEvent event) {
        setFontSize(fontSize - 1);
    }

    public void doActionPerformed__on__upSize(java.awt.event.ActionEvent event) {
        setFontSize(fontSize + 1);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public java.lang.Float getDefaultFontSize() {
        return defaultFontSize;
    }

    public javax.swing.JButton getDefaultSize() {
        return defaultSize;
    }

    public javax.swing.JButton getDownSize() {
        return downSize;
    }

    public java.lang.Float getFontSize() {
        return fontSize;
    }

    public java.lang.Boolean getShowDefaultFontSize() {
        return showDefaultFontSize;
    }

    public java.lang.Boolean getShowFontSize() {
        return showFontSize;
    }

    public javax.swing.JButton getUpSize() {
        return upSize;
    }

    public java.lang.Boolean isShowDefaultFontSize() {
        return showDefaultFontSize !=null && showDefaultFontSize;
    }

    public java.lang.Boolean isShowFontSize() {
        return showFontSize !=null && showFontSize;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setDefaultFontSize(java.lang.Float newValue) {
        java.lang.Float oldValue = this.defaultFontSize;
        this.defaultFontSize = newValue;
        firePropertyChange(PROPERTY_DEFAULT_FONT_SIZE, oldValue, newValue);
    }

    public void setFontSize(java.lang.Float newValue) {
        java.lang.Float oldValue = this.fontSize;
        this.fontSize = newValue;
        firePropertyChange(PROPERTY_FONT_SIZE, oldValue, newValue);
    }

    public void setShowDefaultFontSize(java.lang.Boolean newValue) {
        java.lang.Boolean oldValue = this.showDefaultFontSize;
        this.showDefaultFontSize = newValue;
        firePropertyChange(PROPERTY_SHOW_DEFAULT_FONT_SIZE, oldValue, newValue);
    }

    public void setShowFontSize(java.lang.Boolean newValue) {
        java.lang.Boolean oldValue = this.showFontSize;
        this.showFontSize = newValue;
        firePropertyChange(PROPERTY_SHOW_FONT_SIZE, oldValue, newValue);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected javax.swing.JToolBar get$JToolBar0() {
        return $JToolBar0;
    }

    protected javax.swing.JLabel get$JLabel0() {
        return $JLabel0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void createDefaultFontSize() {
        $objectMap.put("defaultFontSize", defaultFontSize = 12f);
    }

    protected void createDefaultSize() {
        $objectMap.put("defaultSize", defaultSize = new javax.swing.JButton());
        defaultSize.setName("defaultSize");
        defaultSize.setFocusPainted(false);
        defaultSize.setFocusable(false);
        defaultSize.setToolTipText(_("fontsize.action.default.tip"));
        defaultSize.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__defaultSize"));
    }

    protected void createDownSize() {
        $objectMap.put("downSize", downSize = new javax.swing.JButton());
        downSize.setName("downSize");
        downSize.setFocusPainted(false);
        downSize.setFocusable(false);
        downSize.setToolTipText(_("fontsize.action.down.tip"));
        downSize.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__downSize"));
    }

    protected void createFontSize() {
        $objectMap.put("fontSize", fontSize = null);
    }

    protected void createShowDefaultFontSize() {
        $objectMap.put("showDefaultFontSize", showDefaultFontSize = true);
    }

    protected void createShowFontSize() {
        $objectMap.put("showFontSize", showFontSize = false);
    }

    protected void createUpSize() {
        $objectMap.put("upSize", upSize = new javax.swing.JButton());
        upSize.setName("upSize");
        upSize.setFocusPainted(false);
        upSize.setFocusable(false);
        upSize.setToolTipText(_("fontsize.action.up.tip"));
        upSize.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__upSize"));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        // inline complete setup of $JPanel0
        add($JToolBar0, BorderLayout.CENTER);
        // inline complete setup of $JToolBar0
        $JToolBar0.add(downSize);
        $JToolBar0.add(defaultSize);
        $JToolBar0.add(upSize);
        $JToolBar0.add($JLabel0);
        
        // apply 7 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 4 property setters
        downSize.setIcon(jaxx.runtime.SwingUtil.createActionIcon("font-size-down"));
        defaultSize.setIcon(jaxx.runtime.SwingUtil.createActionIcon("font-size"));
        upSize.setIcon(jaxx.runtime.SwingUtil.createActionIcon("font-size-up"));
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        // registers 7 data bindings
        $registerDefaultBindings();
        $objectMap.put("$JPanel0", this);
        createDefaultFontSize();
        createFontSize();
        createShowDefaultFontSize();
        createShowFontSize();
        // inline creation of $JToolBar0
        $objectMap.put("$JToolBar0", $JToolBar0 = new javax.swing.JToolBar());
        $JToolBar0.setName("$JToolBar0");
        $JToolBar0.setBorderPainted(false);
        $JToolBar0.setFloatable(false);
        createDownSize();
        createDefaultSize();
        createUpSize();
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new javax.swing.JLabel());
        $JLabel0.setName("$JLabel0");
        // inline creation of $JPanel0
        setName("$JPanel0");
        setLayout(new BorderLayout());
        
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 7 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JTOOL_BAR0_OPAQUE, true ,"opaque") {
        
            @Override
            public void processDataBinding() {
                $JToolBar0.setOpaque(isOpaque());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_DOWN_SIZE_ENABLED, true ,"enabled") {
        
            @Override
            public void processDataBinding() {
                downSize.setEnabled(isEnabled());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_DEFAULT_SIZE_ENABLED, true ,"fontSize" ,"defaultFontSize" ,"enabled") {
        
            @Override
            public void processDataBinding() {
                defaultSize.setEnabled(updateDefaultSizeEnabled(getFontSize(), getDefaultFontSize(), isEnabled()));
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_DEFAULT_SIZE_VISIBLE, true ,"showDefaultFontSize") {
        
            @Override
            public void processDataBinding() {
                defaultSize.setVisible(isShowDefaultFontSize());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_UP_SIZE_ENABLED, true ,"enabled") {
        
            @Override
            public void processDataBinding() {
                upSize.setEnabled(isEnabled());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JLABEL0_TEXT, true ,"fontSize") {
        
            @Override
            public void processDataBinding() {
                $JLabel0.setText(_(SwingUtil.getStringValue(getFontSize())));
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JLABEL0_VISIBLE, true ,"showFontSize") {
        
            @Override
            public void processDataBinding() {
                $JLabel0.setVisible(isShowFontSize());
            }
        });
    }

}