/*
 * Decompiled with CFR 0.152.
 */
package jaxx.runtime.swing.editor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import jaxx.runtime.DataBindingListener;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.Util;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.JAXXButtonGroup;
import jaxx.runtime.swing.renderer.LocaleListCellRenderer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;

public class I18nEditor
extends JPanel
implements PropertyChangeListener,
ActionListener,
JAXXObject {
    public static final String PROPERTY_LOCALES = "locales";
    public static final String PROPERTY_NOT_SELECTED_TOOL_TIP_TEXT = "notSelectedToolTipText";
    public static final String PROPERTY_POPUP_BORDER = "popupBorder";
    public static final String PROPERTY_POPUP_VISIBLE = "popupVisible";
    public static final String PROPERTY_RENDERER = "renderer";
    public static final String PROPERTY_SELECTED_LOCALE = "selectedLocale";
    public static final String PROPERTY_SELECTED_TOOL_TIP_TEXT = "selectedToolTipText";
    public static final String PROPERTY_SHOW_ICON = "showIcon";
    public static final String PROPERTY_SHOW_POPUP_ICON = "showPopupIcon";
    public static final String PROPERTY_SHOW_POPUP_TEXT = "showPopupText";
    public static final String PROPERTY_SHOW_TEXT = "showText";
    public static final Log log = LogFactory.getLog(I18nEditor.class);
    private static String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVVz08TQRQeKm0plAoSG4iYIBKiidmqJxMIIiBaUpRQYgg96LQ70iHDzrgzK4sH45/gn6B3LybePBkPnj14Mf4Lxnjwanwzu9ulsNbG9tBu5733ve/9mG/ffEdp6aILe9j3LddzFN0n1tqt7e379T3SUCtENlwqFHdR8OlLoVQNDdmtc6nQxVpFh5fC8NIy3xfcIc6R6LkKGpTqkBHZJEQpdL49oiFlqdoyz/nCcyPUFqkk1Fc/f6Re2i9epxDyBbAbhVKm/hUVV9JfQSlqK3QGMj3FJYadXaDhUmcX+A7rs2WGpbyH98kT9BxlKygjsAtgCk13X7LBMPG+UCjb4I4yEDNtROUBpLWITSHUKl+74dw2j0KY0IxCY5IwmAixtzhnW1RsER9ARjRLSzO3AuZxQNHhqnoyRlsLsdeQ4MITS9y1iavQhIbzQzJ1c2gFtjhiQDb5QZB9NM6+BBkIdo65laFa/b8Ynw/r8w2dNGKTaEyIzBuqD6ikdUaO2bKMNzDsj0IFw8lTlFkVKlXsUogaWDGuUe8CT3N0hDxMGYrWLbmeMKbIGsbpPMuEsc3wWIPkWlhpQxvmcbS3a6bIdeJ4cdJB41jBdcJgJ9u8zaF2u9TyztQ9pWCX2me2tsV3dxlZMrZ2HlkK7HzdoumEkvSdD6LuuBxIxXs3UzUbXXaoopjRZ8S9qtCsgWjA2lMGfQiW3jrhCTAuOteWDu66Fd/1+DL21VDa9cwIx2sn5WETTIEwjB8TBg1orL+LY1/ef3u3GqlBHnKfTXQ9ImZwS4XLBUya6tSnAynQS1Fax2KuhnLB2hilm0wgVg3NQA7yjcY7dRfLJkCks18/fCw++nwKpVbRIOPYXsXav4xyqulCFzizfXFz0TDKHwzA94jmBhNm+JDDSFBh3sYKT9VhgDCqBR+aMJnQhBaTeu7Tr7Hq28WoEX1AbOKv7nEz0jsoQx1GHWKEMdS8RCEcEpJ4No+1LUnt+vTvYLRL8+Z7ManSNq1Y9j39s2KI66dVgzPbLU4kKz3gZALp64ByuQuULHEwKJV+wcwHbZ3CCkQaLi5ZSIa90gVsvwoL3Pl/jPxj3vDkBqbwLrI7YJW6wMoZLBxqcg9A/bTzBnSDMRCJfE84+vhhj0yGVPs7twPUHyypYkKFCQAA";
    private static final long serialVersionUID = 1L;
    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap();
    protected JToggleButton button;
    protected I18nEditor content = this;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();
    protected JAXXButtonGroup indexes;
    protected List<Locale> locales;
    protected String notSelectedToolTipText;
    protected JPopupMenu popup;
    protected Border popupBorder;
    protected JLabel popupLabel;
    protected Boolean popupVisible;
    protected LocaleListCellRenderer renderer;
    protected Locale selectedLocale;
    protected String selectedToolTipText;
    protected Boolean showIcon;
    protected Boolean showPopupIcon;
    protected Boolean showPopupText;
    protected Boolean showText;
    private boolean allComponentsCreated;
    private boolean contextInitialized = true;
    private PropertyChangeListener $DataSource2 = new DataBindingListener((JAXXObject)this, "renderer.showIcon");
    private PropertyChangeListener $DataSource3 = new DataBindingListener((JAXXObject)this, "renderer.showText");
    private PropertyChangeListener $DataSource4 = new DataBindingListener((JAXXObject)this, "popup.border");
    private PropertyChangeListener $DataSource5 = new DataBindingListener((JAXXObject)this, "button.icon");
    private PropertyChangeListener $DataSource6 = new DataBindingListener((JAXXObject)this, "button.selected");
    private PropertyChangeListener $DataSource7 = new DataBindingListener((JAXXObject)this, "button.text");
    private PropertyChangeListener $DataSource8 = new DataBindingListener((JAXXObject)this, "button.toolTipText");
    public static final String DEFAULT_SELECTED_TOOLTIP = I18n.n_((String)"i18neditor.selected");
    public static final String DEFAULT_NOT_SELECTED_TOOLTIP = I18n.n_((String)"i18neditor.unselected");
    public static final String LOCALES_PROPERTY = "locales";
    public static final String SELECTED_LOCALE_PROPERTY = "selectedLocale";
    public static final String SHOW_ICON_PROPERTY = "showIcon";
    public static final String SHOW_TEXT_PROPERTY = "showText";
    public static final String SHOW_POPUP_ICON_PROPERTY = "showPopupIcon";
    public static final String SHOW_POPUP_TEXT_PROPERTY = "showPopupText";
    public static final String POPUP_BORDER_PROPERTY = "popupBorder";
    public static final String POPUP_VISIBLE_PROPERTY = "popupVisible";
    protected Runnable showPopupRunnable;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String name = evt.getPropertyName();
        if (log.isDebugEnabled()) {
            log.debug((Object)(name + " <old:" + evt.getOldValue() + " - new:" + evt.getNewValue() + ">"));
        }
        log.info((Object)(name + " <old:" + evt.getOldValue() + " - new:" + evt.getNewValue() + ">"));
        if ("locales".equals(name)) {
            Collection newLocales = (Collection)evt.getNewValue();
            boolean oldShowText = this.renderer.isShowText();
            try {
                this.renderer.setShowText(true);
                this.popup.removeAll();
                for (Object o : newLocales) {
                    Locale l = (Locale)o;
                    boolean selected = l.equals(this.selectedLocale);
                    String text = this.isShowPopupText() != false ? this.renderer.getText(l) : null;
                    Icon icon = this.isShowPopupIcon() != false ? this.renderer.getIcon(l) : null;
                    JRadioButtonMenuItem b = new JRadioButtonMenuItem(text, icon, selected);
                    this.popup.add(b);
                    b.addActionListener(this);
                    b.putClientProperty("locale", l);
                    b.setToolTipText(this.getTip(l));
                    b.putClientProperty("$buttonGroup", this.getIndexes());
                    b.putClientProperty("$value", l);
                }
            }
            finally {
                this.renderer.setShowText(oldShowText);
                this.popup.invalidate();
            }
            return;
        }
        if ("showIcon".equals(name)) {
            this.renderer.setShowIcon(((Boolean)evt.getNewValue()).booleanValue());
            this.processDataBinding("button.icon");
            return;
        }
        if ("showText".equals(name)) {
            this.renderer.setShowText(((Boolean)evt.getNewValue()).booleanValue());
            this.processDataBinding("button.text");
            return;
        }
        if ("showPopupIcon".equals(name)) {
            this.rebuildPopup();
            return;
        }
        if ("showPopupText".equals(name)) {
            this.rebuildPopup();
            return;
        }
        if ("popupBorder".equals(name)) {
            this.popup.setBorder((Border)evt.getNewValue());
            return;
        }
        if ("popupVisible".equals(name)) {
            Boolean newValue = (Boolean)evt.getNewValue();
            if (newValue == null || !newValue.booleanValue()) {
                if (this.getPopup() != null && this.getPopup().isVisible()) {
                    this.getPopup().setVisible(false);
                }
                return;
            }
            if (!this.getPopup().isVisible()) {
                SwingUtilities.invokeLater(this.showPopupRunnable);
            }
            return;
        }
        if ("selectedLocale".equals(name)) {
            Locale newLocale = (Locale)evt.getNewValue();
            try {
                for (Component c : this.popup.getComponents()) {
                    if (!(c instanceof JRadioButtonMenuItem)) continue;
                    JRadioButtonMenuItem b = (JRadioButtonMenuItem)c;
                    Locale l = (Locale)b.getClientProperty("locale");
                    b.setSelected(newLocale.equals(l));
                }
            }
            finally {
                this.popup.invalidate();
            }
            return;
        }
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Locale value = (Locale)((JComponent)event.getSource()).getClientProperty("locale");
        if (log.isDebugEnabled()) {
            log.debug((Object)("new locale : " + value));
        }
        this.setSelectedLocale(value);
    }

    public void loadI18nBundles() {
        Locale[] locales = I18n.getLoader().getLocales();
        this.setLocales(Arrays.asList(I18n.getLoader().getLocales()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void rebuildPopup() {
        log.debug((Object)"start rebuild");
        try {
            for (Component c : this.popup.getComponents()) {
                if (!(c instanceof JRadioButtonMenuItem)) continue;
                JRadioButtonMenuItem b = (JRadioButtonMenuItem)c;
                Locale l = (Locale)b.getClientProperty("locale");
                String text = this.isShowPopupText() != false ? this.renderer.getSafeText(l) : null;
                Icon icon = this.isShowPopupIcon() != false ? this.renderer.getSafeIcon(l) : null;
                b.setIcon(icon);
                b.setText(text);
                log.debug((Object)("text=" + text));
                log.debug((Object)("icon=" + icon));
            }
        }
        finally {
            this.popup.invalidate();
        }
    }

    protected String getTip(Locale l) {
        boolean selected = l.equals(this.selectedLocale);
        String tip = selected ? this.getSelectedTip(l) : this.getNotSelectedTip(l);
        return tip;
    }

    protected String getSelectedTip(Locale l) {
        String selectedTip = this.getSelectedToolTipText();
        if (selectedTip == null) {
            selectedTip = DEFAULT_SELECTED_TOOLTIP;
        }
        String tip = this.renderer.getToolTipText(l);
        tip = I18n._((String)selectedTip, (Object[])new Object[]{tip});
        return tip;
    }

    protected String getNotSelectedTip(Locale l) {
        String selectedTip = this.getNotSelectedToolTipText();
        if (selectedTip == null) {
            selectedTip = DEFAULT_NOT_SELECTED_TOOLTIP;
        }
        String tip = this.renderer.getToolTipText(l);
        tip = I18n._((String)selectedTip, (Object[])new Object[]{tip});
        return tip;
    }

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return Util.decodeCompressedJAXXObjectDescriptor((String)$jaxxObjectDescriptor);
    }

    public I18nEditor() {
        this.$initialize();
    }

    public I18nEditor(JAXXContext parentContext) {
        Util.initContext((JAXXObject)this, (JAXXContext)parentContext);
        this.$initialize();
    }

    public void applyDataBinding(String $binding) {
        if ("renderer.showIcon".equals($binding)) {
            this.addPropertyChangeListener("showIcon", this.$DataSource2);
        } else if ("renderer.showText".equals($binding)) {
            this.addPropertyChangeListener("showText", this.$DataSource3);
        } else if ("popup.border".equals($binding)) {
            this.addPropertyChangeListener("popupBorder", this.$DataSource4);
        } else if ("button.icon".equals($binding)) {
            this.addPropertyChangeListener("selectedLocale", this.$DataSource5);
        } else if ("button.selected".equals($binding)) {
            if (this.popup != null) {
                this.$bindingSources.put("popup", this.popup);
                this.popup.addComponentListener((ComponentListener)Util.getEventListener(ComponentListener.class, (Object)this.content, (String)"$pr$u0"));
            }
        } else if ("button.text".equals($binding)) {
            this.addPropertyChangeListener("selectedLocale", this.$DataSource7);
        } else if ("button.toolTipText".equals($binding)) {
            this.addPropertyChangeListener("selectedLocale", this.$DataSource8);
        }
        this.processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    public Map<String, Object> get$objectMap() {
        return this.$objectMap;
    }

    public Object getObjectById(String id) {
        return this.$objectMap.get(id);
    }

    public void processDataBinding(String dest) {
        this.processDataBinding(dest, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processDataBinding(String $dest, boolean $force) {
        if (!$force && this.$activeBindings.contains($dest)) {
            return;
        }
        this.$activeBindings.add($dest);
        try {
            if ("renderer.showIcon".equals($dest)) {
                this.renderer.setShowIcon(this.isShowIcon().booleanValue());
            } else if ("renderer.showText".equals($dest)) {
                this.renderer.setShowText(this.isShowText().booleanValue());
            } else if ("popup.border".equals($dest)) {
                this.popup.setBorder(this.getPopupBorder());
            } else if ("button.icon".equals($dest)) {
                this.button.setIcon(this.renderer.getIcon(this.getSelectedLocale()));
            } else if ("button.selected".equals($dest)) {
                if (this.popup != null) {
                    this.button.setSelected(this.popup.isVisible());
                }
            } else if ("button.text".equals($dest)) {
                this.button.setText(I18n._((String)SwingUtil.getStringValue((Object)this.renderer.getText(this.getSelectedLocale()))));
            } else if ("button.toolTipText".equals($dest)) {
                this.button.setToolTipText(I18n._((String)this.getTip(this.getSelectedLocale())));
            }
        }
        finally {
            this.$activeBindings.remove($dest);
        }
    }

    public void removeDataBinding(String $binding) {
        if ("renderer.showIcon".equals($binding)) {
            this.removePropertyChangeListener("showIcon", this.$DataSource2);
        } else if ("renderer.showText".equals($binding)) {
            this.removePropertyChangeListener("showText", this.$DataSource3);
        } else if ("popup.border".equals($binding)) {
            this.removePropertyChangeListener("popupBorder", this.$DataSource4);
        } else if ("button.icon".equals($binding)) {
            this.removePropertyChangeListener("selectedLocale", this.$DataSource5);
        } else if ("button.selected".equals($binding)) {
            JPopupMenu $target;
            if (this.popup != null && ($target = (JPopupMenu)this.$bindingSources.remove("popup")) != null) {
                $target.removeComponentListener((ComponentListener)Util.getEventListener(ComponentListener.class, (Object)this.content, (String)"$pr$u0"));
            }
        } else if ("button.text".equals($binding)) {
            this.removePropertyChangeListener("selectedLocale", this.$DataSource7);
        } else if ("button.toolTipText".equals($binding)) {
            this.removePropertyChangeListener("selectedLocale", this.$DataSource8);
        }
    }

    public <T> T getContextValue(Class<T> clazz) {
        return (T)this.delegateContext.getContextValue(clazz, null);
    }

    public <T> T getContextValue(Class<T> clazz, String name) {
        return (T)this.delegateContext.getContextValue(clazz, name);
    }

    public JAXXContext getDelegateContext() {
        return this.delegateContext;
    }

    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return (O)Util.getParentContainer((Object)this, clazz);
    }

    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return (O)Util.getParentContainer((Object)source, clazz);
    }

    public <T> void removeContextValue(Class<T> clazz) {
        this.delegateContext.removeContextValue(clazz, null);
    }

    public <T> void removeContextValue(Class<T> clazz, String name) {
        this.delegateContext.removeContextValue(clazz, name);
    }

    public <T> void setContextValue(T o) {
        this.delegateContext.setContextValue(o, null);
    }

    public <T> void setContextValue(T o, String name) {
        this.delegateContext.setContextValue(o, name);
    }

    public void doFocusGained__on__content(FocusEvent event) {
        this.button.requestFocus();
    }

    public void doFocusLost__on__content(FocusEvent event) {
        this.setPopupVisible(false);
    }

    public void doItemStateChanged__on__button(ItemEvent event) {
        if (event.getStateChange() == 1) {
            this.setPopupVisible(true);
        } else {
            this.popupVisible = false;
        }
    }

    public void doPopupMenuCanceled__on__popup(PopupMenuEvent event) {
        this.button.setSelected(false);
    }

    public void doPopupMenuWillBecomeInvisible__on__popup(PopupMenuEvent event) {
        this.button.setSelected(false);
    }

    public void doStateChanged__on__indexes(ChangeEvent event) {
        log.info(this.indexes.getSelectedValue());
    }

    public List<Object> get$activeBindings() {
        return this.$activeBindings;
    }

    public Map<String, Object> get$bindingSources() {
        return this.$bindingSources;
    }

    public JToggleButton getButton() {
        return this.button;
    }

    public JAXXButtonGroup getIndexes() {
        return this.indexes;
    }

    public List<Locale> getLocales() {
        return this.locales;
    }

    public String getNotSelectedToolTipText() {
        return this.notSelectedToolTipText;
    }

    public JPopupMenu getPopup() {
        return this.popup;
    }

    public Border getPopupBorder() {
        return this.popupBorder;
    }

    public JLabel getPopupLabel() {
        return this.popupLabel;
    }

    public Boolean getPopupVisible() {
        return this.popupVisible;
    }

    public LocaleListCellRenderer getRenderer() {
        return this.renderer;
    }

    public Locale getSelectedLocale() {
        return this.selectedLocale;
    }

    public String getSelectedToolTipText() {
        return this.selectedToolTipText;
    }

    public Boolean getShowIcon() {
        return this.showIcon;
    }

    public Boolean getShowPopupIcon() {
        return this.showPopupIcon;
    }

    public Boolean getShowPopupText() {
        return this.showPopupText;
    }

    public Boolean getShowText() {
        return this.showText;
    }

    public Boolean isPopupVisible() {
        return this.popupVisible != null && this.popupVisible != false;
    }

    public Boolean isShowIcon() {
        return this.showIcon != null && this.showIcon != false;
    }

    public Boolean isShowPopupIcon() {
        return this.showPopupIcon != null && this.showPopupIcon != false;
    }

    public Boolean isShowPopupText() {
        return this.showPopupText != null && this.showPopupText != false;
    }

    public Boolean isShowText() {
        return this.showText != null && this.showText != false;
    }

    public void setLocales(List<Locale> newValue) {
        List<Locale> oldValue = this.locales;
        this.locales = newValue;
        this.firePropertyChange("locales", oldValue, newValue);
    }

    public void setNotSelectedToolTipText(String newValue) {
        String oldValue = this.notSelectedToolTipText;
        this.notSelectedToolTipText = newValue;
        this.firePropertyChange(PROPERTY_NOT_SELECTED_TOOL_TIP_TEXT, oldValue, newValue);
    }

    public void setPopupBorder(Border newValue) {
        Border oldValue = this.popupBorder;
        this.popupBorder = newValue;
        this.firePropertyChange("popupBorder", oldValue, newValue);
    }

    public void setPopupVisible(Boolean newValue) {
        Boolean oldValue = this.popupVisible;
        this.popupVisible = newValue;
        this.firePropertyChange("popupVisible", oldValue, newValue);
    }

    public void setRenderer(LocaleListCellRenderer newValue) {
        LocaleListCellRenderer oldValue = this.renderer;
        this.renderer = newValue;
        this.firePropertyChange(PROPERTY_RENDERER, oldValue, newValue);
    }

    public void setSelectedLocale(Locale newValue) {
        Locale oldValue = this.selectedLocale;
        this.selectedLocale = newValue;
        this.firePropertyChange("selectedLocale", oldValue, newValue);
    }

    public void setSelectedToolTipText(String newValue) {
        String oldValue = this.selectedToolTipText;
        this.selectedToolTipText = newValue;
        this.firePropertyChange(PROPERTY_SELECTED_TOOL_TIP_TEXT, oldValue, newValue);
    }

    public void setShowIcon(Boolean newValue) {
        Boolean oldValue = this.showIcon;
        this.showIcon = newValue;
        this.firePropertyChange("showIcon", oldValue, newValue);
    }

    public void setShowPopupIcon(Boolean newValue) {
        Boolean oldValue = this.showPopupIcon;
        this.showPopupIcon = newValue;
        this.firePropertyChange("showPopupIcon", oldValue, newValue);
    }

    public void setShowPopupText(Boolean newValue) {
        Boolean oldValue = this.showPopupText;
        this.showPopupText = newValue;
        this.firePropertyChange("showPopupText", oldValue, newValue);
    }

    public void setShowText(Boolean newValue) {
        Boolean oldValue = this.showText;
        this.showText = newValue;
        this.firePropertyChange("showText", oldValue, newValue);
    }

    public void $pr$u0(ComponentEvent event) {
        this.$DataSource6.propertyChange(null);
    }

    private void $completeSetup() {
        this.allComponentsCreated = true;
        this.addChildrenToContent();
        this.addChildrenToPopup();
        this.applyDataBinding("renderer.showIcon");
        this.applyDataBinding("renderer.showText");
        this.applyDataBinding("popup.border");
        this.applyDataBinding("button.icon");
        this.applyDataBinding("button.selected");
        this.applyDataBinding("button.text");
        this.applyDataBinding("button.toolTipText");
    }

    private void $initialize() {
        if (this.allComponentsCreated || !this.contextInitialized) {
            return;
        }
        this.$objectMap.put("content", this);
        this.createSelectedToolTipText();
        this.createNotSelectedToolTipText();
        this.createPopupBorder();
        this.createShowText();
        this.createShowIcon();
        this.createShowPopupText();
        this.createShowPopupIcon();
        this.createPopupVisible();
        this.createLocales();
        this.createSelectedLocale();
        this.createRenderer();
        this.createPopup();
        this.createPopupLabel();
        this.createButton();
        this.createIndexes();
        this.create$ScriptInitializer0();
        this.setName("content");
        this.setLayout(new BorderLayout());
        this.content.addFocusListener((FocusListener)Util.getEventListener(FocusListener.class, (String)"focusGained", (Object)this, (String)"doFocusGained__on__content"));
        this.content.addFocusListener((FocusListener)Util.getEventListener(FocusListener.class, (String)"focusLost", (Object)this, (String)"doFocusLost__on__content"));
        this.addPropertyChangeListener(this);
        this.$completeSetup();
    }

    protected void addChildrenToContent() {
        if (!this.allComponentsCreated) {
            return;
        }
        this.add((Component)this.renderer);
        this.add((Component)this.button, "Center");
    }

    protected void addChildrenToPopup() {
        if (!this.allComponentsCreated) {
            return;
        }
        this.popup.add(this.popupLabel);
    }

    protected void create$ScriptInitializer0() {
        this.showPopupRunnable = new Runnable(){

            @Override
            public void run() {
                I18nEditor.this.getPopup().pack();
                JToggleButton invoker = I18nEditor.this.getButton();
                Dimension dim = I18nEditor.this.getPopup().getPreferredSize();
                Dimension invokerDim = invoker.getSize();
                I18nEditor.this.getPopup().show(invoker, (int)(invokerDim.getWidth() - dim.getWidth()), invoker.getHeight());
            }
        };
    }

    protected void createButton() {
        this.button = new JToggleButton();
        this.$objectMap.put("button", this.button);
        this.button.setName("button");
        this.button.setFocusPainted(false);
        this.button.setFocusable(true);
        this.button.addItemListener((ItemListener)Util.getEventListener(ItemListener.class, (String)"itemStateChanged", (Object)this, (String)"doItemStateChanged__on__button"));
    }

    protected void createIndexes() {
        this.indexes = new JAXXButtonGroup();
        this.$objectMap.put("indexes", this.indexes);
        this.indexes.addChangeListener((ChangeListener)Util.getEventListener(ChangeListener.class, (String)"stateChanged", (Object)this, (String)"doStateChanged__on__indexes"));
    }

    protected void createLocales() {
        this.locales = null;
        this.$objectMap.put("locales", null);
    }

    protected void createNotSelectedToolTipText() {
        this.notSelectedToolTipText = null;
        this.$objectMap.put(PROPERTY_NOT_SELECTED_TOOL_TIP_TEXT, null);
    }

    protected void createPopup() {
        this.popup = new JPopupMenu();
        this.$objectMap.put("popup", this.popup);
        this.popup.setName("popup");
        this.popup.addPopupMenuListener((PopupMenuListener)Util.getEventListener(PopupMenuListener.class, (String)"popupMenuCanceled", (Object)this, (String)"doPopupMenuCanceled__on__popup"));
        this.popup.addPopupMenuListener((PopupMenuListener)Util.getEventListener(PopupMenuListener.class, (String)"popupMenuWillBecomeInvisible", (Object)this, (String)"doPopupMenuWillBecomeInvisible__on__popup"));
    }

    protected void createPopupBorder() {
        this.popupBorder = new TitledBorder(I18n._((String)"i18neditor.popup.title"));
        this.$objectMap.put("popupBorder", this.popupBorder);
    }

    protected void createPopupLabel() {
        this.popupLabel = new JLabel();
        this.$objectMap.put("popupLabel", this.popupLabel);
        this.popupLabel.setName("popupLabel");
        this.popupLabel.setEnabled(false);
        this.popupLabel.setText(I18n._((String)"i18neditor.empty.locales"));
    }

    protected void createPopupVisible() {
        this.popupVisible = Boolean.FALSE;
        this.$objectMap.put("popupVisible", this.popupVisible);
    }

    protected void createRenderer() {
        this.renderer = new LocaleListCellRenderer(this.showIcon.booleanValue(), this.showText.booleanValue());
        this.$objectMap.put(PROPERTY_RENDERER, this.renderer);
        this.renderer.setName(PROPERTY_RENDERER);
    }

    protected void createSelectedLocale() {
        this.selectedLocale = Locale.getDefault();
        this.$objectMap.put("selectedLocale", this.selectedLocale);
    }

    protected void createSelectedToolTipText() {
        this.selectedToolTipText = null;
        this.$objectMap.put(PROPERTY_SELECTED_TOOL_TIP_TEXT, null);
    }

    protected void createShowIcon() {
        this.showIcon = Boolean.TRUE;
        this.$objectMap.put("showIcon", this.showIcon);
    }

    protected void createShowPopupIcon() {
        this.showPopupIcon = Boolean.TRUE;
        this.$objectMap.put("showPopupIcon", this.showPopupIcon);
    }

    protected void createShowPopupText() {
        this.showPopupText = Boolean.TRUE;
        this.$objectMap.put("showPopupText", this.showPopupText);
    }

    protected void createShowText() {
        this.showText = Boolean.TRUE;
        this.$objectMap.put("showText", this.showText);
    }
}

