package org.nuiton.jaxx.widgets.gis.absolute;

/*-
 * #%L
 * JAXX :: Widgets Gis
 * %%
 * Copyright (C) 2008 - 2021 Code Lutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.Insets;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JToggleButton;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.JAXXValidator;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.CardLayout2Ext;
import jaxx.runtime.swing.JAXXButtonGroup;
import jaxx.runtime.swing.Table;
import jaxx.runtime.validator.swing.SwingValidator;
import jaxx.runtime.validator.swing.SwingValidatorUtil;
import jaxx.runtime.validator.swing.meta.Validator;
import jaxx.runtime.validator.swing.meta.ValidatorField;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.jaxx.widgets.gis.CoordinateFormat;
import static org.nuiton.i18n.I18n.t;

public class CoordinatesEditor extends Table implements JAXXObject, JAXXValidator {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_DD_FORMAT_SELECTED = "ddFormat.selected";
    public static final String BINDING_DMD_FORMAT_SELECTED = "dmdFormat.selected";
    public static final String BINDING_DMS_FORMAT_SELECTED = "dmsFormat.selected";
    public static final String BINDING_LATITUDE_DD_DISPLAY_ZERO_WHEN_NULL = "latitudeDd.displayZeroWhenNull";
    public static final String BINDING_LATITUDE_DD_ENABLED = "latitudeDd.enabled";
    public static final String BINDING_LATITUDE_DD_FILL_WITH_ZERO = "latitudeDd.fillWithZero";
    public static final String BINDING_LATITUDE_DD_SHOW_RESET = "latitudeDd.showReset";
    public static final String BINDING_LATITUDE_DD_VALUE = "latitudeDd.value";
    public static final String BINDING_LATITUDE_DMD_DISPLAY_ZERO_WHEN_NULL = "latitudeDmd.displayZeroWhenNull";
    public static final String BINDING_LATITUDE_DMD_ENABLED = "latitudeDmd.enabled";
    public static final String BINDING_LATITUDE_DMD_FILL_WITH_ZERO = "latitudeDmd.fillWithZero";
    public static final String BINDING_LATITUDE_DMD_SHOW_RESET = "latitudeDmd.showReset";
    public static final String BINDING_LATITUDE_DMD_VALUE = "latitudeDmd.value";
    public static final String BINDING_LATITUDE_DMS_DISPLAY_ZERO_WHEN_NULL = "latitudeDms.displayZeroWhenNull";
    public static final String BINDING_LATITUDE_DMS_ENABLED = "latitudeDms.enabled";
    public static final String BINDING_LATITUDE_DMS_FILL_WITH_ZERO = "latitudeDms.fillWithZero";
    public static final String BINDING_LATITUDE_DMS_SHOW_RESET = "latitudeDms.showReset";
    public static final String BINDING_LATITUDE_DMS_VALUE = "latitudeDms.value";
    public static final String BINDING_LATITUDE_LAYOUT_SELECTED = "latitudeLayout.selected";
    public static final String BINDING_LONGITUDE_DD_DISPLAY_ZERO_WHEN_NULL = "longitudeDd.displayZeroWhenNull";
    public static final String BINDING_LONGITUDE_DD_ENABLED = "longitudeDd.enabled";
    public static final String BINDING_LONGITUDE_DD_FILL_WITH_ZERO = "longitudeDd.fillWithZero";
    public static final String BINDING_LONGITUDE_DD_SHOW_RESET = "longitudeDd.showReset";
    public static final String BINDING_LONGITUDE_DD_VALUE = "longitudeDd.value";
    public static final String BINDING_LONGITUDE_DMD_DISPLAY_ZERO_WHEN_NULL = "longitudeDmd.displayZeroWhenNull";
    public static final String BINDING_LONGITUDE_DMD_ENABLED = "longitudeDmd.enabled";
    public static final String BINDING_LONGITUDE_DMD_FILL_WITH_ZERO = "longitudeDmd.fillWithZero";
    public static final String BINDING_LONGITUDE_DMD_SHOW_RESET = "longitudeDmd.showReset";
    public static final String BINDING_LONGITUDE_DMD_VALUE = "longitudeDmd.value";
    public static final String BINDING_LONGITUDE_DMS_DISPLAY_ZERO_WHEN_NULL = "longitudeDms.displayZeroWhenNull";
    public static final String BINDING_LONGITUDE_DMS_ENABLED = "longitudeDms.enabled";
    public static final String BINDING_LONGITUDE_DMS_FILL_WITH_ZERO = "longitudeDms.fillWithZero";
    public static final String BINDING_LONGITUDE_DMS_SHOW_RESET = "longitudeDms.showReset";
    public static final String BINDING_LONGITUDE_DMS_VALUE = "longitudeDms.value";
    public static final String BINDING_LONGITUDE_LAYOUT_SELECTED = "longitudeLayout.selected";
    public static final String BINDING_MODEL_FORMAT = "model.format";
    public static final String BINDING_MODEL_QUADRANT = "model.quadrant";
    public static final String BINDING_QUADRANT1_ENABLED = "quadrant1.enabled";
    public static final String BINDING_QUADRANT1_SELECTED = "quadrant1.selected";
    public static final String BINDING_QUADRANT2_ENABLED = "quadrant2.enabled";
    public static final String BINDING_QUADRANT2_SELECTED = "quadrant2.selected";
    public static final String BINDING_QUADRANT3_ENABLED = "quadrant3.enabled";
    public static final String BINDING_QUADRANT3_SELECTED = "quadrant3.selected";
    public static final String BINDING_QUADRANT4_ENABLED = "quadrant4.enabled";
    public static final String BINDING_QUADRANT4_SELECTED = "quadrant4.selected";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "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";
    private static final Log log = LogFactory.getLog(CoordinatesEditor.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected CoordinatesEditor coordinateEditorTopPanel = this;
    protected Table coordinatesPanel;
    protected JRadioButton ddFormat;
    protected JRadioButton dmdFormat;
    protected JRadioButton dmsFormat;
    protected JAXXButtonGroup formatBG;
    protected JPanel formatPanel;
    protected final CoordinatesEditorHandler handler = createHandler();
    protected AbsoluteDdCoordinateEditor latitudeDd;
    protected AbsoluteDmdCoordinateEditor latitudeDmd;
    protected AbsoluteDmsCoordinateEditor latitudeDms;
    @ValidatorField( validatorId = "validator",  propertyName = "latitude",  editorName = "latitudeEditor")
    protected JPanel latitudeEditor;
    protected JLabel latitudeLabel;
    protected CardLayout2Ext latitudeLayout;
    protected AbsoluteCoordinateEditorModel latitudeModel;
    protected AbsoluteDdCoordinateEditor longitudeDd;
    protected AbsoluteDmdCoordinateEditor longitudeDmd;
    protected AbsoluteDmsCoordinateEditor longitudeDms;
    @ValidatorField( validatorId = "validator",  propertyName = "longitude",  editorName = "longitudeEditor")
    protected JPanel longitudeEditor;
    protected JLabel longitudeLabel;
    protected CardLayout2Ext longitudeLayout;
    protected AbsoluteCoordinateEditorModel longitudeModel;
    protected CoordinatesEditorModel model;
    protected JToggleButton quadrant1;
    protected JToggleButton quadrant2;
    protected JToggleButton quadrant3;
    protected JToggleButton quadrant4;
    protected JAXXButtonGroup quadrantBG;
    @ValidatorField( validatorId = "validator",  propertyName = "quadrant",  editorName = "quadrantEditor")
    protected JPanel quadrantEditor;
    @Validator( validatorId = "validator")
    protected SwingValidator<CoordinatesEditorModel> validator;
    protected List<String> validatorIds = new ArrayList<String>();

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    public void init() { handler.init(this); }
    public void setBean(Serializable bean) { model.setBean(bean); }
    public void setPropertyQuadrant(String property) { model.setPropertyQuadrant(property); }
    public void setPropertyLatitude(String property) { model.setPropertyLatitude(property); }
    public void setPropertyLongitude(String property) { model.setPropertyLongitude(property); }
    public void setQuadrant(Integer quadrant) { model.setQuadrant(quadrant); }
    public void setLatitude(Float latitude) { model.setLatitude(latitude); }
    public void setLongitude(Float longitude) { model.setLongitude(longitude); }
    public void setLatitudeAndLongitude(Float latitude, Float longitude) { model.setLatitudeAndLongitude(latitude, longitude); }
    public void setFormat(CoordinateFormat format) { model.setFormat(format); }
    public void setShowResetButton(boolean showResetButton) { model.setShowResetButton(showResetButton); }
    public void setDisplayZeroWhenNull(boolean displayZeroWhenNull) { model.setDisplayZeroWhenNull(displayZeroWhenNull); }
    public void setFillWithZero(boolean fillWithZero) { model.setFillWithZero(fillWithZero); }
    public void resetModel() { handler.resetModel(); }
    public void resetQuadrant() { handler.resetQuadrant(); }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public CoordinatesEditor() {
        $initialize();
    }

    public CoordinatesEditor(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*-------------------- JAXXValidator implementation  --------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public SwingValidator<?> getValidator(String validatorId) {
        return (SwingValidator<?>) (validatorIds.contains(validatorId) ? getObjectById(validatorId) : null);
    }

    @Override
    public List<String> getValidatorIds() {
        return validatorIds;
    }

    @Override
    public void registerValidatorFields() {
        SwingValidatorUtil.detectValidatorFields(this);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public Table getCoordinatesPanel() {
        return coordinatesPanel;
    }

    public JRadioButton getDdFormat() {
        return ddFormat;
    }

    public JRadioButton getDmdFormat() {
        return dmdFormat;
    }

    public JRadioButton getDmsFormat() {
        return dmsFormat;
    }

    public JAXXButtonGroup getFormatBG() {
        return formatBG;
    }

    public JPanel getFormatPanel() {
        return formatPanel;
    }

    public CoordinatesEditorHandler getHandler() {
        return handler;
    }

    public AbsoluteDdCoordinateEditor getLatitudeDd() {
        return latitudeDd;
    }

    public AbsoluteDmdCoordinateEditor getLatitudeDmd() {
        return latitudeDmd;
    }

    public AbsoluteDmsCoordinateEditor getLatitudeDms() {
        return latitudeDms;
    }

    public JPanel getLatitudeEditor() {
        return latitudeEditor;
    }

    public JLabel getLatitudeLabel() {
        return latitudeLabel;
    }

    public CardLayout2Ext getLatitudeLayout() {
        return latitudeLayout;
    }

    public AbsoluteCoordinateEditorModel getLatitudeModel() {
        return latitudeModel;
    }

    public AbsoluteDdCoordinateEditor getLongitudeDd() {
        return longitudeDd;
    }

    public AbsoluteDmdCoordinateEditor getLongitudeDmd() {
        return longitudeDmd;
    }

    public AbsoluteDmsCoordinateEditor getLongitudeDms() {
        return longitudeDms;
    }

    public JPanel getLongitudeEditor() {
        return longitudeEditor;
    }

    public JLabel getLongitudeLabel() {
        return longitudeLabel;
    }

    public CardLayout2Ext getLongitudeLayout() {
        return longitudeLayout;
    }

    public AbsoluteCoordinateEditorModel getLongitudeModel() {
        return longitudeModel;
    }

    public CoordinatesEditorModel getModel() {
        return model;
    }

    public JToggleButton getQuadrant1() {
        return quadrant1;
    }

    public JToggleButton getQuadrant2() {
        return quadrant2;
    }

    public JToggleButton getQuadrant3() {
        return quadrant3;
    }

    public JToggleButton getQuadrant4() {
        return quadrant4;
    }

    public JAXXButtonGroup getQuadrantBG() {
        return quadrantBG;
    }

    public JPanel getQuadrantEditor() {
        return quadrantEditor;
    }

    public SwingValidator<CoordinatesEditorModel> getValidator() {
        return validator;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToCoordinateEditorTopPanel() {
        if (!allComponentsCreated) {
            return;
        }
        add(SwingUtil.boxComponentWithJxLayer(quadrantEditor), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        add(coordinatesPanel, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        add(formatPanel, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
    }

    protected void addChildrenToCoordinatesPanel() {
        if (!allComponentsCreated) {
            return;
        }
        coordinatesPanel.add(latitudeLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        coordinatesPanel.add(SwingUtil.boxComponentWithJxLayer(latitudeEditor), new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        coordinatesPanel.add(longitudeLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        coordinatesPanel.add(SwingUtil.boxComponentWithJxLayer(longitudeEditor), new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    protected void addChildrenToDdFormat() {
        if (!allComponentsCreated) {
            return;
        }
        { ButtonGroup $buttonGroup = formatBG; ddFormat.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add(ddFormat); }
    }

    protected void addChildrenToDmdFormat() {
        if (!allComponentsCreated) {
            return;
        }
        { ButtonGroup $buttonGroup = formatBG; dmdFormat.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add(dmdFormat); }
    }

    protected void addChildrenToDmsFormat() {
        if (!allComponentsCreated) {
            return;
        }
        { ButtonGroup $buttonGroup = formatBG; dmsFormat.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add(dmsFormat); }
    }

    protected void addChildrenToFormatPanel() {
        if (!allComponentsCreated) {
            return;
        }
        formatPanel.add(dmsFormat);
        formatPanel.add(dmdFormat);
        formatPanel.add(ddFormat);
    }

    protected void addChildrenToLatitudeEditor() {
        if (!allComponentsCreated) {
            return;
        }
        latitudeEditor.add(latitudeDd, CoordinateFormat.dd.name());
        latitudeEditor.add(latitudeDms, CoordinateFormat.dms.name());
        latitudeEditor.add(latitudeDmd, CoordinateFormat.dmd.name());
    }

    protected void addChildrenToLongitudeEditor() {
        if (!allComponentsCreated) {
            return;
        }
        longitudeEditor.add(longitudeDd, CoordinateFormat.dd.name());
        longitudeEditor.add(longitudeDms, CoordinateFormat.dms.name());
        longitudeEditor.add(longitudeDmd, CoordinateFormat.dmd.name());
    }

    protected void addChildrenToQuadrant1() {
        if (!allComponentsCreated) {
            return;
        }
        { ButtonGroup $buttonGroup = quadrantBG; quadrant1.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add(quadrant1); }
    }

    protected void addChildrenToQuadrant2() {
        if (!allComponentsCreated) {
            return;
        }
        { ButtonGroup $buttonGroup = quadrantBG; quadrant2.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add(quadrant2); }
    }

    protected void addChildrenToQuadrant3() {
        if (!allComponentsCreated) {
            return;
        }
        { ButtonGroup $buttonGroup = quadrantBG; quadrant3.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add(quadrant3); }
    }

    protected void addChildrenToQuadrant4() {
        if (!allComponentsCreated) {
            return;
        }
        { ButtonGroup $buttonGroup = quadrantBG; quadrant4.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add(quadrant4); }
    }

    protected void addChildrenToQuadrantEditor() {
        if (!allComponentsCreated) {
            return;
        }
        quadrantEditor.add(quadrant4);
        quadrantEditor.add(quadrant1);
        quadrantEditor.add(quadrant3);
        quadrantEditor.add(quadrant2);
    }

    protected void addChildrenToValidator() {
        if (!allComponentsCreated) {
            return;
        }
        validator.setBean(model);
    }

    protected void createCoordinatesPanel() {
        $objectMap.put("coordinatesPanel", coordinatesPanel = new Table());
        
        coordinatesPanel.setName("coordinatesPanel");
    }

    protected void createDdFormat() {
        $objectMap.put("ddFormat", ddFormat = new JRadioButton());
        
        ddFormat.setName("ddFormat");
        ddFormat.setText(t("jaxx.coordinate.format.dd"));
        ddFormat.setToolTipText(t("jaxx.coordinate.format.dd.tip"));
    }

    protected void createDmdFormat() {
        $objectMap.put("dmdFormat", dmdFormat = new JRadioButton());
        
        dmdFormat.setName("dmdFormat");
        dmdFormat.setText(t("jaxx.coordinate.format.dmd"));
        dmdFormat.setToolTipText(t("jaxx.coordinate.format.dmd.tip"));
    }

    protected void createDmsFormat() {
        $objectMap.put("dmsFormat", dmsFormat = new JRadioButton());
        
        dmsFormat.setName("dmsFormat");
        dmsFormat.setText(t("jaxx.coordinate.format.dms"));
        dmsFormat.setToolTipText(t("jaxx.coordinate.format.dms.tip"));
    }

    protected void createFormatBG() {
        $objectMap.put("formatBG", formatBG = new JAXXButtonGroup());
    }

    protected void createFormatPanel() {
        $objectMap.put("formatPanel", formatPanel = new JPanel());
        
        formatPanel.setName("formatPanel");
        formatPanel.setLayout(new GridLayout(0,1,0,0));
    }

    protected CoordinatesEditorHandler createHandler() {
        return new CoordinatesEditorHandler();
    }

    protected void createLatitudeDd() {
        $objectMap.put("latitudeDd", latitudeDd = new AbsoluteDdCoordinateEditor());
        
        latitudeDd.setName("latitudeDd");
        latitudeDd.setPropertyDecimal("ddDecimal");
        latitudeDd.setPropertyDegree("ddDegree");
    }

    protected void createLatitudeDmd() {
        $objectMap.put("latitudeDmd", latitudeDmd = new AbsoluteDmdCoordinateEditor());
        
        latitudeDmd.setName("latitudeDmd");
        latitudeDmd.setPropertyDecimal("dmdDecimal");
        latitudeDmd.setPropertyMinute("dmdMinute");
        latitudeDmd.setPropertyDegree("dmdDegree");
    }

    protected void createLatitudeDms() {
        $objectMap.put("latitudeDms", latitudeDms = new AbsoluteDmsCoordinateEditor());
        
        latitudeDms.setName("latitudeDms");
        latitudeDms.setPropertyMinute("dmsMinute");
        latitudeDms.setPropertySecond("dmsSecond");
        latitudeDms.setPropertyDegree("dmsDegree");
    }

    protected void createLatitudeEditor() {
        $objectMap.put("latitudeEditor", latitudeEditor = new JPanel());
        
        latitudeEditor.setName("latitudeEditor");
        latitudeEditor.setLayout(latitudeLayout);
    }

    protected void createLatitudeLabel() {
        $objectMap.put("latitudeLabel", latitudeLabel = new JLabel());
        
        latitudeLabel.setName("latitudeLabel");
        latitudeLabel.setText(t("jaxx.common.latitude"));
    }

    protected void createLatitudeLayout() {
        $objectMap.put("latitudeLayout", latitudeLayout = new CardLayout2Ext(this, "latitudeEditor"));
    }

    protected void createLatitudeModel() {
        $objectMap.put("latitudeModel", latitudeModel = model.getLatitudeModel());
    }

    protected void createLongitudeDd() {
        $objectMap.put("longitudeDd", longitudeDd = new AbsoluteDdCoordinateEditor());
        
        longitudeDd.setName("longitudeDd");
        longitudeDd.setPropertyDecimal("ddDecimal");
        longitudeDd.setPropertyDegree("ddDegree");
    }

    protected void createLongitudeDmd() {
        $objectMap.put("longitudeDmd", longitudeDmd = new AbsoluteDmdCoordinateEditor());
        
        longitudeDmd.setName("longitudeDmd");
        longitudeDmd.setPropertyDecimal("dmdDecimal");
        longitudeDmd.setPropertyMinute("dmdMinute");
        longitudeDmd.setPropertyDegree("dmdDegree");
    }

    protected void createLongitudeDms() {
        $objectMap.put("longitudeDms", longitudeDms = new AbsoluteDmsCoordinateEditor());
        
        longitudeDms.setName("longitudeDms");
        longitudeDms.setPropertyMinute("dmsMinute");
        longitudeDms.setPropertySecond("dmsSecond");
        longitudeDms.setPropertyDegree("dmsDegree");
    }

    protected void createLongitudeEditor() {
        $objectMap.put("longitudeEditor", longitudeEditor = new JPanel());
        
        longitudeEditor.setName("longitudeEditor");
        longitudeEditor.setLayout(longitudeLayout);
    }

    protected void createLongitudeLabel() {
        $objectMap.put("longitudeLabel", longitudeLabel = new JLabel());
        
        longitudeLabel.setName("longitudeLabel");
        longitudeLabel.setText(t("jaxx.common.longitude"));
    }

    protected void createLongitudeLayout() {
        $objectMap.put("longitudeLayout", longitudeLayout = new CardLayout2Ext(this, "longitudeEditor"));
    }

    protected void createLongitudeModel() {
        $objectMap.put("longitudeModel", longitudeModel = model.getLongitudeModel());
    }

    protected void createModel() {
        $objectMap.put("model", model = getContextValue(CoordinatesEditorModel.class));
    }

    protected void createQuadrant1() {
        $objectMap.put("quadrant1", quadrant1 = new JToggleButton());
        
        quadrant1.setName("quadrant1");
        quadrant1.setText(t("jaxx.common.quadrant1"));
    }

    protected void createQuadrant2() {
        $objectMap.put("quadrant2", quadrant2 = new JToggleButton());
        
        quadrant2.setName("quadrant2");
        quadrant2.setText(t("jaxx.common.quadrant2"));
    }

    protected void createQuadrant3() {
        $objectMap.put("quadrant3", quadrant3 = new JToggleButton());
        
        quadrant3.setName("quadrant3");
        quadrant3.setText(t("jaxx.common.quadrant3"));
    }

    protected void createQuadrant4() {
        $objectMap.put("quadrant4", quadrant4 = new JToggleButton());
        
        quadrant4.setName("quadrant4");
        quadrant4.setText(t("jaxx.common.quadrant4"));
    }

    protected void createQuadrantBG() {
        $objectMap.put("quadrantBG", quadrantBG = new JAXXButtonGroup());
    }

    protected void createQuadrantEditor() {
        $objectMap.put("quadrantEditor", quadrantEditor = new JPanel());
        
        quadrantEditor.setName("quadrantEditor");
        quadrantEditor.setLayout(new GridLayout(2,2,0,0));
    }

    protected void createValidator() {
        $objectMap.put("validator", validator = SwingValidator.newValidator(CoordinatesEditorModel.class, null));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToCoordinateEditorTopPanel();
        addChildrenToValidator();
        addChildrenToQuadrantEditor();
        addChildrenToQuadrant4();
        addChildrenToQuadrant1();
        addChildrenToQuadrant3();
        addChildrenToQuadrant2();
        addChildrenToCoordinatesPanel();
        addChildrenToLatitudeEditor();
        addChildrenToLongitudeEditor();
        addChildrenToFormatPanel();
        addChildrenToDmsFormat();
        addChildrenToDmdFormat();
        addChildrenToDdFormat();
        
        // apply 45 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 25 property setters
        { quadrant4.putClientProperty("$value", new Integer(4));  Object $buttonGroup = quadrant4.getClientProperty("$buttonGroup"); if ($buttonGroup instanceof JAXXButtonGroup) { ((JAXXButtonGroup) $buttonGroup).updateSelectedValue(); } }
        
        { quadrant1.putClientProperty("$value", new Integer(1));  Object $buttonGroup = quadrant1.getClientProperty("$buttonGroup"); if ($buttonGroup instanceof JAXXButtonGroup) { ((JAXXButtonGroup) $buttonGroup).updateSelectedValue(); } }
        
        { quadrant3.putClientProperty("$value", new Integer(3));  Object $buttonGroup = quadrant3.getClientProperty("$buttonGroup"); if ($buttonGroup instanceof JAXXButtonGroup) { ((JAXXButtonGroup) $buttonGroup).updateSelectedValue(); } }
        
        { quadrant2.putClientProperty("$value", new Integer(2));  Object $buttonGroup = quadrant2.getClientProperty("$buttonGroup"); if ($buttonGroup instanceof JAXXButtonGroup) { ((JAXXButtonGroup) $buttonGroup).updateSelectedValue(); } }
        
        latitudeLabel.setLabelFor(latitudeEditor);
        latitudeDd.setShowResetTip(t("jaxx.coordinate.action.reset.latitude.tip"));
        latitudeDd.setBean(latitudeModel);
        latitudeDms.setShowResetTip(t("jaxx.coordinate.action.reset.latitude.tip"));
        latitudeDms.setBean(latitudeModel);
        latitudeDmd.setShowResetTip(t("jaxx.coordinate.action.reset.latitude.tip"));
        latitudeDmd.setBean(latitudeModel);
        longitudeLabel.setLabelFor(longitudeEditor);
        longitudeDd.setShowResetTip(t("jaxx.coordinate.action.reset.longitude.tip"));
        longitudeDd.setBean(longitudeModel);
        longitudeDms.setShowResetTip(t("jaxx.coordinate.action.reset.longitude.tip"));
        longitudeDms.setBean(longitudeModel);
        longitudeDmd.setShowResetTip(t("jaxx.coordinate.action.reset.longitude.tip"));
        longitudeDmd.setBean(longitudeModel);
        { dmsFormat.putClientProperty("$value", CoordinateFormat.dms);  Object $buttonGroup = dmsFormat.getClientProperty("$buttonGroup"); if ($buttonGroup instanceof JAXXButtonGroup) { ((JAXXButtonGroup) $buttonGroup).updateSelectedValue(); } }
        
        { dmdFormat.putClientProperty("$value", CoordinateFormat.dmd);  Object $buttonGroup = dmdFormat.getClientProperty("$buttonGroup"); if ($buttonGroup instanceof JAXXButtonGroup) { ((JAXXButtonGroup) $buttonGroup).updateSelectedValue(); } }
        
        { ddFormat.putClientProperty("$value", CoordinateFormat.dd);  Object $buttonGroup = ddFormat.getClientProperty("$buttonGroup"); if ($buttonGroup instanceof JAXXButtonGroup) { ((JAXXButtonGroup) $buttonGroup).updateSelectedValue(); } }
        // late initializer
        // register 1 validator(s)
        validatorIds = SwingValidatorUtil.detectValidators(this);
        SwingValidatorUtil.installUI(this);
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        handler.beforeInit(this);
        $objectMap.put("coordinateEditorTopPanel", coordinateEditorTopPanel);
        createModel();
        createLatitudeModel();
        createLongitudeModel();
        createValidator();
        createLatitudeLayout();
        createLongitudeLayout();
        createQuadrantEditor();
        createQuadrant4();
        createQuadrant1();
        createQuadrant3();
        createQuadrant2();
        createCoordinatesPanel();
        createLatitudeLabel();
        createLatitudeEditor();
        createLatitudeDd();
        createLatitudeDms();
        createLatitudeDmd();
        createLongitudeLabel();
        createLongitudeEditor();
        createLongitudeDd();
        createLongitudeDms();
        createLongitudeDmd();
        createFormatPanel();
        createDmsFormat();
        createDmdFormat();
        createDdFormat();
        createQuadrantBG();
        createFormatBG();
        // inline creation of coordinateEditorTopPanel
        setName("coordinateEditorTopPanel");
        
        // registers 45 data bindings
        $registerDefaultBindings();
        $completeSetup();
        handler.afterInit(this);
    }

    private void $registerDefaultBindings() {
        // register 45 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_MODEL_QUADRANT, true) {
        
            @Override
            public void applyDataBinding() {
                if (quadrantBG != null) {
                    quadrantBG.addPropertyChangeListener("selectedValue", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (quadrantBG != null) {
                    model.setQuadrant((Integer)quadrantBG.getSelectedValue());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (quadrantBG != null) {
                    quadrantBG.removePropertyChangeListener("selectedValue", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_MODEL_FORMAT, true) {
        
            @Override
            public void applyDataBinding() {
                if (formatBG != null) {
                    formatBG.addPropertyChangeListener("selectedValue", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (formatBG != null) {
                    model.setFormat((CoordinateFormat)formatBG.getSelectedValue());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (formatBG != null) {
                    formatBG.removePropertyChangeListener("selectedValue", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_LATITUDE_LAYOUT_SELECTED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("format", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    latitudeLayout.setSelected(String.valueOf(model.getFormat()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("format", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_LONGITUDE_LAYOUT_SELECTED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("format", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    longitudeLayout.setSelected(String.valueOf(model.getFormat()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("format", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_QUADRANT4_ENABLED, true ,"enabled") {
        
            @Override
            public void processDataBinding() {
                quadrant4.setEnabled(isEnabled());
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_QUADRANT4_SELECTED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("quadrant", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    quadrant4.setSelected(handler.isQuadrantSelected(model.getQuadrant(), 4));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("quadrant", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_QUADRANT1_ENABLED, true ,"enabled") {
        
            @Override
            public void processDataBinding() {
                quadrant1.setEnabled(isEnabled());
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_QUADRANT1_SELECTED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("quadrant", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    quadrant1.setSelected(handler.isQuadrantSelected(model.getQuadrant(), 1));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("quadrant", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_QUADRANT3_ENABLED, true ,"enabled") {
        
            @Override
            public void processDataBinding() {
                quadrant3.setEnabled(isEnabled());
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_QUADRANT3_SELECTED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("quadrant", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    quadrant3.setSelected(handler.isQuadrantSelected(model.getQuadrant(), 3));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("quadrant", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_QUADRANT2_ENABLED, true ,"enabled") {
        
            @Override
            public void processDataBinding() {
                quadrant2.setEnabled(isEnabled());
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_QUADRANT2_SELECTED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("quadrant", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    quadrant2.setSelected(handler.isQuadrantSelected(model.getQuadrant(), 2));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("quadrant", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_LATITUDE_DD_FILL_WITH_ZERO, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("fillWithZero", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    latitudeDd.setFillWithZero(model.isFillWithZero());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("fillWithZero", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_LATITUDE_DD_SHOW_RESET, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("showResetButton", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    latitudeDd.setShowReset(model.isShowResetButton());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("showResetButton", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_LATITUDE_DD_DISPLAY_ZERO_WHEN_NULL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("displayZeroWhenNull", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    latitudeDd.setDisplayZeroWhenNull(model.isDisplayZeroWhenNull());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("displayZeroWhenNull", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_LATITUDE_DD_VALUE, true) {
        
            @Override
            public void applyDataBinding() {
                if (latitudeModel != null) {
                    latitudeModel.addPropertyChangeListener("dd", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (latitudeModel != null) {
                    latitudeDd.setValue(latitudeModel.getDd());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (latitudeModel != null) {
                    latitudeModel.removePropertyChangeListener("dd", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_LATITUDE_DD_ENABLED, true ,"enabled") {
        
            @Override
            public void processDataBinding() {
                latitudeDd.setEnabled(isEnabled());
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_LATITUDE_DMS_FILL_WITH_ZERO, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("fillWithZero", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    latitudeDms.setFillWithZero(model.isFillWithZero());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("fillWithZero", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_LATITUDE_DMS_SHOW_RESET, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("showResetButton", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    latitudeDms.setShowReset(model.isShowResetButton());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("showResetButton", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_LATITUDE_DMS_DISPLAY_ZERO_WHEN_NULL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("displayZeroWhenNull", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    latitudeDms.setDisplayZeroWhenNull(model.isDisplayZeroWhenNull());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("displayZeroWhenNull", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_LATITUDE_DMS_VALUE, true) {
        
            @Override
            public void applyDataBinding() {
                if (latitudeModel != null) {
                    latitudeModel.addPropertyChangeListener("dms", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (latitudeModel != null) {
                    latitudeDms.setValue(latitudeModel.getDms());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (latitudeModel != null) {
                    latitudeModel.removePropertyChangeListener("dms", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_LATITUDE_DMS_ENABLED, true ,"enabled") {
        
            @Override
            public void processDataBinding() {
                latitudeDms.setEnabled(isEnabled());
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_LATITUDE_DMD_FILL_WITH_ZERO, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("fillWithZero", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    latitudeDmd.setFillWithZero(model.isFillWithZero());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("fillWithZero", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_LATITUDE_DMD_SHOW_RESET, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("showResetButton", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    latitudeDmd.setShowReset(model.isShowResetButton());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("showResetButton", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_LATITUDE_DMD_DISPLAY_ZERO_WHEN_NULL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("displayZeroWhenNull", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    latitudeDmd.setDisplayZeroWhenNull(model.isDisplayZeroWhenNull());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("displayZeroWhenNull", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_LATITUDE_DMD_VALUE, true) {
        
            @Override
            public void applyDataBinding() {
                if (latitudeModel != null) {
                    latitudeModel.addPropertyChangeListener("dmd", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (latitudeModel != null) {
                    latitudeDmd.setValue(latitudeModel.getDmd());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (latitudeModel != null) {
                    latitudeModel.removePropertyChangeListener("dmd", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_LATITUDE_DMD_ENABLED, true ,"enabled") {
        
            @Override
            public void processDataBinding() {
                latitudeDmd.setEnabled(isEnabled());
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_LONGITUDE_DD_FILL_WITH_ZERO, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("fillWithZero", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    longitudeDd.setFillWithZero(model.isFillWithZero());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("fillWithZero", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_LONGITUDE_DD_SHOW_RESET, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("showResetButton", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    longitudeDd.setShowReset(model.isShowResetButton());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("showResetButton", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_LONGITUDE_DD_DISPLAY_ZERO_WHEN_NULL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("displayZeroWhenNull", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    longitudeDd.setDisplayZeroWhenNull(model.isDisplayZeroWhenNull());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("displayZeroWhenNull", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_LONGITUDE_DD_VALUE, true) {
        
            @Override
            public void applyDataBinding() {
                if (longitudeModel != null) {
                    longitudeModel.addPropertyChangeListener("dd", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (longitudeModel != null) {
                    longitudeDd.setValue(longitudeModel.getDd());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (longitudeModel != null) {
                    longitudeModel.removePropertyChangeListener("dd", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_LONGITUDE_DD_ENABLED, true ,"enabled") {
        
            @Override
            public void processDataBinding() {
                longitudeDd.setEnabled(isEnabled());
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_LONGITUDE_DMS_FILL_WITH_ZERO, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("fillWithZero", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    longitudeDms.setFillWithZero(model.isFillWithZero());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("fillWithZero", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_LONGITUDE_DMS_SHOW_RESET, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("showResetButton", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    longitudeDms.setShowReset(model.isShowResetButton());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("showResetButton", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_LONGITUDE_DMS_DISPLAY_ZERO_WHEN_NULL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("displayZeroWhenNull", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    longitudeDms.setDisplayZeroWhenNull(model.isDisplayZeroWhenNull());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("displayZeroWhenNull", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_LONGITUDE_DMS_VALUE, true) {
        
            @Override
            public void applyDataBinding() {
                if (longitudeModel != null) {
                    longitudeModel.addPropertyChangeListener("dms", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (longitudeModel != null) {
                    longitudeDms.setValue(longitudeModel.getDms());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (longitudeModel != null) {
                    longitudeModel.removePropertyChangeListener("dms", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_LONGITUDE_DMS_ENABLED, true ,"enabled") {
        
            @Override
            public void processDataBinding() {
                longitudeDms.setEnabled(isEnabled());
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_LONGITUDE_DMD_FILL_WITH_ZERO, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("fillWithZero", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    longitudeDmd.setFillWithZero(model.isFillWithZero());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("fillWithZero", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_LONGITUDE_DMD_SHOW_RESET, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("showResetButton", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    longitudeDmd.setShowReset(model.isShowResetButton());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("showResetButton", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_LONGITUDE_DMD_DISPLAY_ZERO_WHEN_NULL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("displayZeroWhenNull", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    longitudeDmd.setDisplayZeroWhenNull(model.isDisplayZeroWhenNull());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("displayZeroWhenNull", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_LONGITUDE_DMD_VALUE, true) {
        
            @Override
            public void applyDataBinding() {
                if (longitudeModel != null) {
                    longitudeModel.addPropertyChangeListener("dmd", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (longitudeModel != null) {
                    longitudeDmd.setValue(longitudeModel.getDmd());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (longitudeModel != null) {
                    longitudeModel.removePropertyChangeListener("dmd", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_LONGITUDE_DMD_ENABLED, true ,"enabled") {
        
            @Override
            public void processDataBinding() {
                longitudeDmd.setEnabled(isEnabled());
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_DMS_FORMAT_SELECTED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("format", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    dmsFormat.setSelected(model.getFormat() == CoordinateFormat.dms);
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("format", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_DMD_FORMAT_SELECTED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("format", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    dmdFormat.setSelected(model.getFormat() == CoordinateFormat.dmd);
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("format", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_DD_FORMAT_SELECTED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("format", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    ddFormat.setSelected(model.getFormat() == CoordinateFormat.dd);
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("format", this);
                }
            }
        });
    }

}
