/*
 * *##% 
 * JAXX Action
 * Copyright (C) 2008 - 2009 CodeLutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * ##%*
 */
/**
 * ##% Copyright (C) 2008 Code Lutin, Tony Chemit
 * This program is free software; you
 * can redistribute it and/or modify it under the terms of the GNU General
 * Public License as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version. This program is
 * distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE. See the GNU General Public License for more details. You
 * should have received a copy of the GNU General Public License along with this
 * program; if not, write to the Free Software Foundation, Inc., 59 Temple Place
 * - Suite 330, Boston, MA 02111-1307, USA. 
 * ##%
 */
package org.nuiton.jaxx.util;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.lang.reflect.Constructor;

/**
 * A abstract dialog contract to be realised by a dialogUI (WindowEvent adapter)
 * <p/>
 * TODO : make jaxx authorized implementing interface for root tag :)
 *
 * @param <H> type of handler
 * @author chemit
 */
public abstract class DialogUI<H extends DialogUIHandler<?,?>> extends JDialog implements WindowListener {

    protected static Log log = LogFactory.getLog(DialogUI.class);

    public javax.swing.AbstractAction newAction(Class<?> actionClass, Object... params) {
        Constructor<?> constructor = null;
        for (Constructor<?> cons : actionClass.getConstructors()) {
            Class<?>[] prototype = cons.getParameterTypes();
            if (prototype.length > 0 && DialogUI.class.isAssignableFrom(prototype[0])) {
                // use this constructor
                constructor = cons;
                break;
            }
        }
        if (constructor == null) {
            throw new IllegalStateException("could not find a matching constructor for " + actionClass);
        }

        // wrap params
        Object[] parameters = new Object[1 + params.length];
        parameters[0] = this;
        System.arraycopy(params, 0, parameters, 1, params.length);
        try {
            AbstractAction action = (AbstractAction) constructor.newInstance(parameters);
            if (log.isInfoEnabled()) {
                log.info(action);
            }
            return action;
        } catch (Exception e) {
            throw new IllegalStateException("could not init the action " + actionClass + " for reason : " + e.getMessage());
        }
    }

    private H handler;

    public abstract AbstractButton getHelp();
    
    public abstract Object getObjectById(java.lang.String s);

    protected DialogUI() {
        UIHelper.setQuitAction(this);
        addWindowListener(this);
        //TODO will be handled by jaxx with javax.help...
        //getHelp().setAction(newAction(HelpAction.class));
    }

    public H getHandler() {
        return handler;
    }

    public void setHandler(H handler) {
        this.handler = handler;
    }

    protected ImageIcon createActionIcon(String name) {
        return UIHelper.createActionIcon(name);
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    @Override
    public void windowClosing(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    @Override
    public synchronized void addWindowListener(WindowListener l) {
        super.addWindowListener(l);
        if (log.isDebugEnabled()) {
            log.debug("after added (" + getWindowListeners().length + ") : " + l);
        }
    }

    @Override
    public synchronized void removeWindowListener(WindowListener l) {
        super.removeWindowListener(l);
        if (log.isDebugEnabled()) {
            log.debug("after removed (" + getWindowListeners().length + ") : " + l);
        }
    }
}