/*
 * Decompiled with CFR 0.152.
 */
package jaxx.compiler.types;

import java.awt.Color;
import java.lang.reflect.Field;
import jaxx.compiler.types.TypeConverter;

public class ColorConverter
implements TypeConverter {
    @Override
    public Class<?>[] getSupportedTypes() {
        return new Class[]{Color.class};
    }

    @Override
    public String getJavaCode(Object object) {
        Color color = (Color)object;
        return "new Color(" + color.getRed() + ", " + color.getGreen() + ", " + color.getBlue() + ")";
    }

    @Override
    public Object convertFromString(String string, Class<?> type) {
        if (!Color.class.equals(type)) {
            throw new IllegalArgumentException("unsupported type: " + type);
        }
        if (string.length() == 7 && string.charAt(0) == '#') {
            return new Color(Integer.parseInt(string.substring(1), 16));
        }
        try {
            Field color = Color.class.getField(string);
            return color.get(null);
        }
        catch (NoSuchFieldException e) {
            throw new IllegalArgumentException("colors must be of the form #xxxxxx ('#' followed by six hexadecimal digits), or the name of a constant field in java.awt.Color (found: '" + string + "')");
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }
}

