/*
 * Decompiled with CFR 0.152.
 */
package jaxx.compiler.binding;

import java.io.StringReader;
import jaxx.compiler.CompiledObject;
import jaxx.compiler.CompilerException;
import jaxx.compiler.JAXXCompiler;
import jaxx.compiler.binding.DataBinding;
import jaxx.compiler.binding.DataSource;
import jaxx.compiler.java.JavaFileGenerator;
import jaxx.compiler.java.parser.JavaParser;
import jaxx.compiler.java.parser.SimpleNode;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PseudoClassDataBinding
extends DataBinding {
    protected static final Log log = LogFactory.getLog(PseudoClassDataBinding.class);
    protected final boolean invert;

    public static PseudoClassDataBinding newPseudoClassDataBinding(String pseudoClass, CompiledObject object, String propertyCode, String methodName, boolean invertTest) {
        PseudoClassDataBinding binding = null;
        if (pseudoClass.startsWith("{")) {
            pseudoClass = pseudoClass.substring(1, pseudoClass.length() - 1).trim();
            pseudoClass = PseudoClassDataBinding.replaceObjectReferences(pseudoClass, object.getJavaCode());
            String id = object.getId() + ".style." + pseudoClass + "." + methodName;
            binding = new PseudoClassDataBinding(id, pseudoClass, propertyCode, invertTest);
        }
        return binding;
    }

    protected PseudoClassDataBinding(String id, String source, String assignment, boolean invert) {
        super(id, source, assignment, false);
        this.invert = invert;
    }

    public static String replaceObjectReferences(String code, String id) throws CompilerException {
        JavaParser p = new JavaParser(new StringReader(code + ";"));
        p.Expression();
        SimpleNode node = p.popNode();
        PseudoClassDataBinding.scanNode(node, id);
        return node.getText();
    }

    public static void scanNode(SimpleNode node, String id) {
        if (node.getId() == 37) {
            String name = node.getText();
            if (name.equals("object") || name.indexOf(".") != -1 && name.substring(0, name.indexOf(".")).trim().equals("object")) {
                node.firstToken.image = id;
            }
        } else {
            int count = node.jjtGetNumChildren();
            for (int i = 0; i < count; ++i) {
                PseudoClassDataBinding.scanNode(node.getChild(i), id);
            }
        }
    }

    @Override
    protected String getInitDataBindingCode(JAXXCompiler compiler, DataSource dataSource, boolean isBinding) {
        return null;
    }

    @Override
    protected String getProcessDataBindingCode(JAXXCompiler compiler, DataSource dataSource, boolean isBinding) {
        if (!isBinding) {
            return null;
        }
        String eol = JAXXCompiler.getLineSeparator();
        StringBuilder buffer = new StringBuilder();
        String realSource = this.invert ? this.invert(this.getSource()) : this.getSource();
        buffer.append("if (").append(realSource).append(") {").append(eol);
        buffer.append(JavaFileGenerator.indent(this.getAssignment(), 4, false, eol)).append(eol);
        buffer.append("}");
        return buffer.toString();
    }

    protected String invert(String javaCode) {
        return (javaCode = javaCode.trim()).startsWith("!") ? javaCode.substring(1) : "!(" + javaCode + ")";
    }
}

