/*
 * Decompiled with CFR 0.152.
 */
package jaxx.compiler.java;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import jaxx.compiler.java.JavaArgument;
import jaxx.compiler.java.JavaElement;

public class JavaMethod
extends JavaElement
implements Comparable<JavaMethod> {
    static final JavaMethodComparator COMPARATOR = new JavaMethodComparator();
    private String returnType;
    private JavaArgument[] arguments;
    private String[] exceptions;
    private String body;
    private boolean override;

    public JavaMethod(int modifiers, String returnType, String name, JavaArgument[] arguments, String[] exceptions, String bodyCode, boolean override) {
        super(modifiers, name);
        this.returnType = returnType;
        this.override = override;
        this.arguments = arguments;
        this.exceptions = exceptions;
        this.body = bodyCode == null ? "" : bodyCode;
    }

    public String getReturnType() {
        return this.returnType;
    }

    public JavaArgument[] getArguments() {
        return this.arguments;
    }

    public String[] getExceptions() {
        return this.exceptions;
    }

    public boolean isOverride() {
        return this.override;
    }

    public void setOverride(boolean override) {
        this.override = override;
    }

    public String getBody() {
        return this.body;
    }

    @Override
    public int compareTo(JavaMethod o) {
        return COMPARATOR.compare(this, o);
    }

    public static EnumMap<MethodOrder, List<JavaMethod>> getSortedMethods(List<JavaMethod> methods) {
        int[] scopes;
        EnumMap<MethodOrder, List<JavaMethod>> result = new EnumMap<MethodOrder, List<JavaMethod>>(MethodOrder.class);
        for (MethodOrder methodOrder : MethodOrder.values()) {
            result.put(methodOrder, new ArrayList());
        }
        EnumSet<MethodOrder> allConstants = EnumSet.allOf(MethodOrder.class);
        ArrayList<JavaMethod> allMethods = new ArrayList<JavaMethod>(methods);
        for (int scope : scopes = new int[]{8, 1, 4, 2}) {
            EnumSet<MethodOrder> constants = JavaMethod.getMethodOrderScope(allConstants, scope);
            Iterator itMethods = allMethods.iterator();
            block2: while (itMethods.hasNext()) {
                JavaMethod method = (JavaMethod)itMethods.next();
                for (MethodOrder constant : constants) {
                    if (!constant.accept(method.getModifiers(), method)) continue;
                    result.get((Object)constant).add(method);
                    itMethods.remove();
                    continue block2;
                }
            }
            constants.clear();
        }
        if (!allMethods.isEmpty()) {
            throw new IllegalArgumentException("could not find a " + MethodOrder.class + " for method " + allMethods);
        }
        for (MethodOrder methodOrder : MethodOrder.values()) {
            Collections.sort(result.get((Object)methodOrder));
        }
        return result;
    }

    public static EnumSet<MethodOrder> getMethodOrderScope(EnumSet<MethodOrder> allConstants, int scope) {
        EnumSet<MethodOrder> constants = EnumSet.noneOf(MethodOrder.class);
        for (MethodOrder order : allConstants) {
            if (!order.accept(scope)) continue;
            constants.add(order);
        }
        return constants;
    }

    static class JavaMethodComparator
    implements Comparator<JavaMethod> {
        JavaMethodComparator() {
        }

        @Override
        public int compare(JavaMethod o1, JavaMethod o2) {
            return o1.getName().compareTo(o2.getName());
        }

        public int compareStatic(JavaMethod o1, JavaMethod o2) {
            if (Modifier.isStatic(o1.getModifiers()) && !Modifier.isStatic(o2.getModifiers())) {
                return -1;
            }
            if (!Modifier.isStatic(o1.getModifiers()) && Modifier.isStatic(o2.getModifiers())) {
                return 1;
            }
            return 0;
        }

        public int compareConstructor(JavaMethod o1, JavaMethod o2) {
            if (o1.getReturnType() == null && o2.getReturnType() != null) {
                return -1;
            }
            if (o1.getReturnType() != null && o2.getReturnType() == null) {
                return 1;
            }
            return 0;
        }

        public int compareVisibility(JavaMethod o1, JavaMethod o2) {
            if (Modifier.isPublic(o1.getModifiers()) && !Modifier.isPublic(o2.getModifiers())) {
                return -1;
            }
            if (!Modifier.isPublic(o1.getModifiers()) && Modifier.isPublic(o2.getModifiers())) {
                return 1;
            }
            if (Modifier.isProtected(o1.getModifiers()) && !Modifier.isProtected(o2.getModifiers())) {
                return -1;
            }
            if (!Modifier.isProtected(o1.getModifiers()) && Modifier.isProtected(o2.getModifiers())) {
                return 1;
            }
            if (Modifier.isPrivate(o1.getModifiers()) && !Modifier.isPrivate(o2.getModifiers())) {
                return -1;
            }
            if (!Modifier.isPrivate(o1.getModifiers()) && Modifier.isPrivate(o2.getModifiers())) {
                return 1;
            }
            return 0;
        }
    }

    public static enum MethodOrder {
        statics(8, "/*---------------------------------------------------------------------------------*/\n/*-- Statics methods --------------------------------------------------------------*/\n/*---------------------------------------------------------------------------------*/"){}
        ,
        constructors(1, "/*---------------------------------------------------------------------------------*/\n/*-- Constructors -----------------------------------------------------------------*/\n/*---------------------------------------------------------------------------------*/"){

            @Override
            public boolean accept(JavaMethod method) {
                return method.returnType == null;
            }
        }
        ,
        JAXXObject(1, "/*---------------------------------------------------------------------------------*/\n/*-- JAXXObject implementation ----------------------------------------------------*/\n/*---------------------------------------------------------------------------------*/"){
            private List<String> methods = Arrays.asList("applyDataBinding", "firePropertyChange", "getObjectById", "get$objectMap", "processDataBinding", "removeDataBinding");

            @Override
            public boolean accept(JavaMethod method) {
                return this.methods.contains(method.getName());
            }
        }
        ,
        JAXXContext(1, "/*---------------------------------------------------------------------------------*/\n/*-- JAXXContext implementation ---------------------------------------------------*/\n/*---------------------------------------------------------------------------------*/"){
            private List<String> methods = Arrays.asList("getContextValue", "getDelegateContext", "getParentContainer", "removeContextValue", "setContextValue");

            @Override
            public boolean accept(JavaMethod method) {
                return this.methods.contains(method.getName());
            }
        }
        ,
        JAXXValidation(1, "/*---------------------------------------------------------------------------------*/\n/*-- JAXXValidation implementation ------------------------------------------------*/\n/*---------------------------------------------------------------------------------*/"){
            private List<String> methods = Arrays.asList("getValidator", "getValidatorIds");

            @Override
            public boolean accept(JavaMethod method) {
                return this.methods.contains(method.getName());
            }
        }
        ,
        events(1, "/*---------------------------------------------------------------------------------*/\n/*-- Event methods ----------------------------------------------------------------*/\n/*---------------------------------------------------------------------------------*/"){

            @Override
            public boolean accept(JavaMethod method) {
                return method.getName().startsWith("do") && method.getName().indexOf("__") > -1;
            }
        }
        ,
        publicGetters(1, "/*---------------------------------------------------------------------------------*/\n/*-- public acessor methods -------------------------------------------------------*/\n/*---------------------------------------------------------------------------------*/"){

            @Override
            public boolean accept(JavaMethod method) {
                return method.getName().startsWith("get") || method.getName().startsWith("is");
            }
        }
        ,
        publicSetters(1, "/*---------------------------------------------------------------------------------*/\n/*-- public mutator methods -------------------------------------------------------*/\n/*---------------------------------------------------------------------------------*/"){

            @Override
            public boolean accept(JavaMethod method) {
                return method.getName().startsWith("set");
            }
        }
        ,
        otherPublic(1, "/*---------------------------------------------------------------------------------*/\n/*-- public mutator methods -------------------------------------------------------*/\n/*---------------------------------------------------------------------------------*/"){

            @Override
            public boolean accept(int mod) {
                return super.accept(mod) && !Modifier.isStatic(mod);
            }
        }
        ,
        protectedGetters(4, "/*---------------------------------------------------------------------------------*/\n/*-- protected acessors methods ---------------------------------------------------*/\n/*---------------------------------------------------------------------------------*/"){

            @Override
            public boolean accept(JavaMethod method) {
                return method.getName().startsWith("get") || method.getName().startsWith("is");
            }
        }
        ,
        createMethod(6, "/*---------------------------------------------------------------------------------*/\n/*-- ui creation methods ----------------------------------------------------------*/\n/*---------------------------------------------------------------------------------*/"){

            @Override
            public boolean accept(JavaMethod method) {
                return method.getName().startsWith("create") || method.getName().startsWith("add") || method.getName().equals("$completeSetup") || method.getName().equals("$initialize");
            }
        }
        ,
        protecteds(4, "/*---------------------------------------------------------------------------------*/\n/*-- Other protected methods ------------------------------------------------------*/\n/*---------------------------------------------------------------------------------*/"){}
        ,
        packageLocal(0, "/*---------------------------------------------------------------------------------*/\n/*-- Package methods --------------------------------------------------------------*/\n/*---------------------------------------------------------------------------------*/"){

            @Override
            public boolean accept(int mod) {
                return !Modifier.isStatic(mod) && !Modifier.isPublic(mod) && !Modifier.isProtected(mod);
            }
        }
        ,
        privates(2, "/*---------------------------------------------------------------------------------*/\n/*-- Private methods --------------------------------------------------------------*/\n/*---------------------------------------------------------------------------------*/"){};

        private final String header;
        private int modifier;

        private MethodOrder(int modifier, String header) {
            this.header = header;
            this.modifier = modifier;
        }

        public String getHeader() {
            return this.header;
        }

        public boolean accept(JavaMethod method) {
            return true;
        }

        public boolean accept(int mod) {
            return (mod & this.modifier) != 0;
        }

        public boolean accept(int mod, JavaMethod method) {
            return this.accept(mod) && this.accept(method);
        }

        public static MethodOrder valueOf(JavaMethod method, int scope) {
            for (MethodOrder o : MethodOrder.values()) {
                if (!o.accept(scope, method)) continue;
                return o;
            }
            throw new IllegalArgumentException("could not find a " + MethodOrder.class + " for method " + method);
        }
    }
}

