package org.nuiton.jaxx.application.swing.action;

/*
 * #%L
 * JAXX :: Application Swing
 * %%
 * Copyright (C) 2008 - 2014 Code Lutin, Tony Chemit
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.jaxx.application.swing.AbstractApplicationUIHandler;

import javax.swing.AbstractButton;

/**
 * To create and consume {@link AbstractApplicationAction}.
 * Created on 11/24/13.
 *
 * @author Tony Chemit - chemit@codelutin.com
 * @since 2.8
 */
public class ApplicationActionEngine {

    /** Logger. */
    private static final Log log =
            LogFactory.getLog(ApplicationActionEngine.class);

    private final ApplicationActionFactory actionFactory;

    public ApplicationActionEngine(ApplicationActionFactory actionFactory) {
        this.actionFactory = actionFactory;
    }

    public <A extends AbstractApplicationAction> void runInternalAction(A action) {
        Throwable error = null;

        try {
            action.doAction();
            action.postSuccessAction();
        } catch (Throwable e) {
            error = e;
            if (log.isErrorEnabled()) {
                log.error("Error in action:", e);
            }
            throw ApplicationActionException.propagateError(action, e);
        } finally {
            try {
                if (error != null) {
                    action.postFailedAction(error);
                }
            } finally {

                action.releaseAction();
            }
        }
    }

    public <A extends AbstractApplicationAction> void runInternalAction(AbstractApplicationUIHandler handler,
                                                                        Class<A> actionName) {
        A action = actionFactory.createLogicAction(handler, actionName);
        runInternalAction(action);
    }

    public <A extends AbstractApplicationAction> void runAction(A action) {
        ApplicationUIAction<A> uiAction = actionFactory.createUIAction(null, action);
        uiAction.actionPerformed(null);
    }

    public void runAction(AbstractButton button) {
        button.getAction().actionPerformed(null);
    }

    public <A extends AbstractApplicationAction> void runActionAndWait(A action) {
        ApplicationUIAction<A> uiAction = actionFactory.createUIAction(null, action);
        uiAction.launchActionAndWait();
    }

    public <A extends AbstractApplicationAction> void runActionAndWait(AbstractApplicationUIHandler handler,
                                                                       Class<A> actionName) {
        A logicAction = actionFactory.createLogicAction(handler, actionName);
        runActionAndWait(logicAction);
    }
}
