/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.i18n.plugin.parser.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import org.antlr.v4.runtime.ANTLRInputStream;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.misc.NotNull;
import org.antlr.v4.runtime.tree.ParseTree;
import org.apache.commons.io.IOUtils;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.nuiton.i18n.plugin.parser.AbstractFileParser;
import org.nuiton.i18n.plugin.parser.AbstractI18nParserMojo;
import org.nuiton.i18n.plugin.parser.FileParser;
import org.nuiton.i18n.plugin.parser.I18nSourceEntry;
import org.nuiton.i18n.plugin.parser.ParserException;
import org.nuiton.i18n.plugin.parser.SourceEntry;
import org.nuiton.i18n.plugin.parser.java.JavaBaseVisitor;
import org.nuiton.i18n.plugin.parser.java.JavaLexer;
import org.nuiton.i18n.plugin.parser.java.JavaParser;
import org.nuiton.io.FileUpdater;
import org.nuiton.io.FileUpdaterHelper;
import org.nuiton.io.SortedProperties;

@Mojo(name="parserJava", defaultPhase=LifecyclePhase.GENERATE_RESOURCES)
public class ParserJavaMojo
extends AbstractI18nParserMojo {
    public static final String DEFAULT_INCLUDES = "**/*.java";
    @Parameter(property="i18n.defaultBasedir", defaultValue="${basedir}/src/main/java")
    protected File defaultBasedir;
    @Parameter(property="i18n.defaultIncludes", defaultValue="**/*.java", required=true)
    protected String defaultIncludes;
    @Parameter(property="i18n.outputGetter", defaultValue="java.getter")
    protected String outputGetter;

    @Override
    public String[] getDefaultIncludes() {
        return new String[]{this.defaultIncludes};
    }

    @Override
    public String[] getDefaultExcludes() {
        return I18nSourceEntry.EMPTY_STRING_ARRAY;
    }

    @Override
    public File getDefaultBasedir() {
        return this.defaultBasedir;
    }

    @Override
    public FileUpdater newFileUpdater(SourceEntry entry) {
        return FileUpdaterHelper.newJavaFileUpdater((File)entry.getBasedir(), (File)this.cp);
    }

    @Override
    protected String getOutGetter() {
        return this.outputGetter;
    }

    @Override
    public FileParser newFileParser(Pattern acceptPattern) {
        return new JavaFileParser(this.getLog(), this.encoding, this.oldParser, acceptPattern, this.isShowTouchedFiles());
    }

    protected static class JavaFileParser
    extends AbstractFileParser {
        public JavaFileParser(Log log, String encoding, SortedProperties oldParser, Pattern acceptKeyPattern, boolean showTouchedFiles) {
            super(log, encoding, oldParser, acceptKeyPattern, showTouchedFiles);
        }

        @Override
        public void parseFile(File file) throws IOException {
            InputStreamReader inputStream = new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8");
            try {
                CommonTokenStream tokenStream = new CommonTokenStream((TokenSource)new JavaLexer((CharStream)new ANTLRInputStream((Reader)inputStream)));
                JavaParser parser = new JavaParser((TokenStream)tokenStream);
                JavaParser.CompilationUnitContext compilationUnitContext = parser.compilationUnit();
                compilationUnitContext.accept(new JavaParserVisitor(file));
                ((Reader)inputStream).close();
            }
            catch (Exception e) {
                throw new ParserException(e);
            }
            finally {
                IOUtils.closeQuietly((Reader)inputStream);
            }
        }

        @Override
        public void parseLine(File file, String line) throws IOException {
        }

        protected class JavaParserVisitor
        extends JavaBaseVisitor<Void> {
            protected final Set<String> simpleI18nMethodPrefix;
            protected final Set<String> complexI18nMethodPrefix;
            protected final File file;

            private JavaParserVisitor(File file) {
                this.file = file;
                this.simpleI18nMethodPrefix = new HashSet<String>();
                this.complexI18nMethodPrefix = new HashSet<String>();
                this.simpleI18nMethodPrefix.add("org.nuiton.i18n.I18n.n");
                this.simpleI18nMethodPrefix.add("org.nuiton.i18n.I18n.t");
                this.simpleI18nMethodPrefix.add("I18n.n");
                this.simpleI18nMethodPrefix.add("I18n.t");
                this.simpleI18nMethodPrefix.add("n");
                this.simpleI18nMethodPrefix.add("t");
                this.complexI18nMethodPrefix.add("org.nuiton.i18n.I18n.l");
                this.complexI18nMethodPrefix.add("I18n.l");
                this.complexI18nMethodPrefix.add("l");
            }

            @Override
            public Void visitStatementExpression(@NotNull JavaParser.StatementExpressionContext ctx) {
                return (Void)super.visitStatementExpression(ctx);
            }

            @Override
            public Void visitExpression(@NotNull JavaParser.ExpressionContext ctx) {
                boolean match = false;
                if (ctx.getChildCount() > 2 && ctx.getChild(2) instanceof JavaParser.ExpressionListContext) {
                    ParseTree child = ctx.getChild(0);
                    String childText = child.getText();
                    if (this.simpleI18nMethodPrefix.contains(childText)) {
                        JavaParser.ExpressionListContext arguments = (JavaParser.ExpressionListContext)ctx.getChild(2);
                        String firstArgs = arguments.getChild(0).getText();
                        if (firstArgs.matches("^\"[^\"]+\"$")) {
                            String key = firstArgs.substring(1).substring(0, firstArgs.length() - 2);
                            if (JavaFileParser.this.getLog().isDebugEnabled()) {
                                JavaFileParser.this.getLog().debug((CharSequence)(this.file.getName() + " detected key = " + key));
                            }
                            JavaFileParser.this.registerKey(key);
                        }
                        match = true;
                    } else if (this.complexI18nMethodPrefix.contains(childText)) {
                        JavaParser.ExpressionListContext arguments = (JavaParser.ExpressionListContext)ctx.getChild(2);
                        String firstArgs = arguments.getChild(2).getText();
                        if (firstArgs.matches("^\"[^\"]+\"$")) {
                            String key = firstArgs.substring(1).substring(0, firstArgs.length() - 2);
                            if (JavaFileParser.this.getLog().isDebugEnabled()) {
                                JavaFileParser.this.getLog().debug((CharSequence)(this.file.getName() + " detected key = " + key));
                            }
                            JavaFileParser.this.registerKey(key);
                        }
                        match = true;
                    }
                }
                Void aVoid = null;
                if (!match) {
                    aVoid = (Void)super.visitExpression(ctx);
                }
                return aVoid;
            }
        }
    }
}

