/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.i18n.plugin.parser.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import org.antlr.v4.runtime.ANTLRInputStream;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.misc.NotNull;
import org.antlr.v4.runtime.tree.ParseTree;
import org.apache.commons.io.IOUtils;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.nuiton.i18n.plugin.parser.AbstractFileParser;
import org.nuiton.i18n.plugin.parser.AbstractI18nParserMojo;
import org.nuiton.i18n.plugin.parser.FileParser;
import org.nuiton.i18n.plugin.parser.I18nSourceEntry;
import org.nuiton.i18n.plugin.parser.ParserException;
import org.nuiton.i18n.plugin.parser.SourceEntry;
import org.nuiton.i18n.plugin.parser.java.JavaBaseVisitor;
import org.nuiton.i18n.plugin.parser.java.JavaLexer;
import org.nuiton.i18n.plugin.parser.java.JavaParser;
import org.nuiton.io.FileUpdater;
import org.nuiton.io.MirroredFileUpdater;
import org.nuiton.io.SortedProperties;

@Mojo(name="parserGWTJava", defaultPhase=LifecyclePhase.GENERATE_RESOURCES)
public class ParserGWTJavaMojo
extends AbstractI18nParserMojo {
    public static final String DEFAULT_INCLUDES = "**/*.java";
    @Parameter(property="i18n.defaultBasedir", defaultValue="${basedir}/src/main/java")
    protected File defaultBasedir;
    @Parameter(property="i18n.defaultIncludes", defaultValue="**/*.java", required=true)
    protected String defaultIncludes;
    @Parameter(property="i18n.outputGetter", defaultValue="gwt-java.getter")
    protected String outputGetter;
    @Parameter(property="i18n.workdir", defaultValue="${basedir}/target/i18n-workdir")
    protected File workdir;
    protected MirroredFileUpdater entryUpdater;

    @Override
    public String[] getDefaultIncludes() {
        return new String[]{this.defaultIncludes};
    }

    @Override
    public String[] getDefaultExcludes() {
        return I18nSourceEntry.EMPTY_STRING_ARRAY;
    }

    @Override
    public File getDefaultBasedir() {
        return this.defaultBasedir;
    }

    @Override
    protected boolean onEnterEntry(I18nSourceEntry entry) {
        boolean b = super.onEnterEntry(entry);
        if (!b) {
            this.entryUpdater = (MirroredFileUpdater)entry.getUpdater();
        }
        return b;
    }

    @Override
    public FileUpdater newFileUpdater(SourceEntry entry) {
        return new MirroredFileUpdater("", "", entry.getBasedir(), this.workdir){

            public File getMirrorFile(File f) {
                String file = f.getAbsolutePath().substring(this.prefixSourceDirecotory);
                return new File(this.destinationDirectory + File.separator + file);
            }
        };
    }

    @Override
    protected String getOutGetter() {
        return this.outputGetter;
    }

    @Override
    public FileParser newFileParser(Pattern acceptPattern) {
        return new GWTJavaFileParser(this.getLog(), this.encoding, this.oldParser, acceptPattern, this.isShowTouchedFiles());
    }

    protected static class GWTJavaFileParser
    extends AbstractFileParser {
        public GWTJavaFileParser(Log log, String encoding, SortedProperties oldParser, Pattern acceptKeyPattern, boolean showTouchedFiles) {
            super(log, encoding, oldParser, acceptKeyPattern, showTouchedFiles);
        }

        @Override
        public void parseFile(File file) throws IOException {
            InputStreamReader inputStream = new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8");
            try {
                CommonTokenStream tokenStream = new CommonTokenStream((TokenSource)new JavaLexer((CharStream)new ANTLRInputStream((Reader)inputStream)));
                JavaParser parser = new JavaParser((TokenStream)tokenStream);
                JavaParser.CompilationUnitContext compilationUnitContext = parser.compilationUnit();
                compilationUnitContext.accept(new JavaParserVisitor(file));
                ((Reader)inputStream).close();
            }
            catch (Exception e) {
                throw new ParserException(e);
            }
            finally {
                IOUtils.closeQuietly((Reader)inputStream);
            }
        }

        @Override
        public void parseLine(File file, String line) throws IOException {
        }

        protected class JavaParserVisitor
        extends JavaBaseVisitor<Void> {
            protected final Set<String> annotationPrefix;
            protected final File file;

            private JavaParserVisitor(File file) {
                this.file = file;
                this.annotationPrefix = new HashSet<String>();
                this.annotationPrefix.add("Key");
                this.annotationPrefix.add("LocalizableResource.Key");
                this.annotationPrefix.add("com.google.gwt.i18n.client.LocalizableResource.Key");
            }

            @Override
            public Void visitAnnotation(@NotNull JavaParser.AnnotationContext ctx) {
                ParseTree child;
                String childText;
                boolean match = false;
                if (ctx.getChildCount() > 3 && this.annotationPrefix.contains(childText = (child = ctx.getChild(1)).getText())) {
                    String firstArgs = ctx.getChild(3).getText();
                    if (firstArgs.matches("^\"[^\"]+\"$")) {
                        String key = firstArgs.substring(1).substring(0, firstArgs.length() - 2);
                        if (GWTJavaFileParser.this.getLog().isDebugEnabled()) {
                            GWTJavaFileParser.this.getLog().debug((CharSequence)(this.file.getName() + " detected key = " + key));
                        }
                        GWTJavaFileParser.this.registerKey(key);
                    }
                    match = true;
                }
                Void aVoid = null;
                if (!match) {
                    aVoid = (Void)super.visitAnnotation(ctx);
                }
                return aVoid;
            }
        }
    }
}

