/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.eugene.plugin;

import java.util.Arrays;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.nuiton.eugene.ModelPropertiesUtil;
import org.nuiton.eugene.ModelReader;
import org.nuiton.eugene.Template;
import org.nuiton.eugene.models.Model;
import org.nuiton.eugene.writer.ChainedFileWriter;

public class AvailableDataMojo
extends AbstractMojo {
    protected String dataTypes;
    protected Map<String, Model> modelTypes;
    protected Map<String, ModelReader<?>> modelReaders;
    protected Map<String, Template<?>> modelTemplates;
    protected Map<String, ChainedFileWriter> writers;
    protected Map<String, ModelPropertiesUtil.ModelPropertiesProvider> modelPropertiesProviders;
    protected Map<String, ModelPropertiesUtil.ModelPropertiesProvider> loadedProviders;
    protected ModelPropertiesUtil.ModelPropertiesProvider currentPropertiesProvider;

    public void execute() throws MojoExecutionException, MojoFailureException {
        EnumSet<AvailableData> safeDataTypes;
        StringBuilder buffer = new StringBuilder();
        String string = this.dataTypes = this.dataTypes == null ? "" : this.dataTypes.trim();
        if (StringUtils.isEmpty((String)this.dataTypes)) {
            safeDataTypes = EnumSet.allOf(AvailableData.class);
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)("will use all data types : " + safeDataTypes));
            }
        } else {
            safeDataTypes = EnumSet.noneOf(AvailableData.class);
            for (String s : this.dataTypes.split(",")) {
                s = s.trim().toLowerCase();
                try {
                    AvailableData data = AvailableData.valueOf(s);
                    if (this.getLog().isDebugEnabled()) {
                        this.getLog().debug((CharSequence)("will use data type " + (Object)((Object)data)));
                    }
                    safeDataTypes.add(data);
                }
                catch (IllegalArgumentException e) {
                    this.getLog().warn((CharSequence)("does not know data type : " + s + " use one of " + Arrays.toString((Object[])AvailableData.values())));
                }
            }
        }
        if (safeDataTypes.contains((Object)AvailableData.stereotype) || safeDataTypes.contains((Object)AvailableData.tagvalue)) {
            this.loadedProviders = new LinkedHashMap<String, ModelPropertiesUtil.ModelPropertiesProvider>();
            for (Map.Entry entry : this.modelPropertiesProviders.entrySet()) {
                ModelPropertiesUtil.ModelPropertiesProvider provider = ModelPropertiesUtil.newStore(Arrays.asList((ModelPropertiesUtil.ModelPropertiesProvider)entry.getValue()), (boolean)false);
                this.loadedProviders.put((String)entry.getKey(), provider);
            }
        }
        for (AvailableData availableData : safeDataTypes) {
            buffer.append("\n");
            this.appendData(availableData, buffer);
        }
        this.getLog().info((CharSequence)("Get datas for data types : " + safeDataTypes + buffer.toString()));
    }

    protected void appendData(AvailableData data, StringBuilder buffer) {
        String dataType = data.name();
        if (data == AvailableData.tagvalue || data == AvailableData.stereotype) {
            int nbData = 0;
            Iterator<ModelPropertiesUtil.ModelPropertiesProvider> i$ = this.loadedProviders.values().iterator();
            while (i$.hasNext()) {
                ModelPropertiesUtil.ModelPropertiesProvider provider;
                this.currentPropertiesProvider = provider = i$.next();
                nbData += data.getData(this).size();
            }
            this.currentPropertiesProvider = null;
            String format = "\nFound %s %ss in %s provider(s) : %s\n";
            buffer.append(String.format(format, nbData, dataType, this.loadedProviders.size(), this.loadedProviders.keySet()));
            for (Map.Entry<String, ModelPropertiesUtil.ModelPropertiesProvider> e : this.loadedProviders.entrySet()) {
                ModelPropertiesUtil.ModelPropertiesProvider provider;
                String providerName = e.getKey();
                this.currentPropertiesProvider = provider = e.getValue();
                Map<String, ?> map = data.getData(this);
                int size = map.size();
                buffer.append("\nProvider [").append(providerName).append("] - ");
                if (size == 0) {
                    buffer.append("No available ").append(dataType).append(".");
                } else if (size == 1) {
                    buffer.append("Found one ").append(dataType).append(" : ");
                } else {
                    buffer.append("Found ");
                    buffer.append(size);
                    buffer.append(" ");
                    buffer.append(dataType);
                    buffer.append("s : ");
                }
                for (Map.Entry<String, ?> e2 : map.entrySet()) {
                    data.toString(buffer, e2);
                }
            }
        } else {
            Map<String, ?> map = data.getData(this);
            int size = map.size();
            if (size == 0) {
                buffer.append("\nNo available ").append(dataType).append(".");
            } else if (size == 1) {
                buffer.append("\nFound one ").append(dataType).append(" : ");
            } else {
                buffer.append("\nFound ");
                buffer.append(size);
                buffer.append(" ");
                buffer.append(dataType);
                buffer.append("s : ");
            }
            for (Map.Entry<String, ?> e : map.entrySet()) {
                data.toString(buffer, e);
            }
        }
    }

    protected ModelPropertiesUtil.ModelPropertiesProvider getCurrentPropertiesProvider() {
        return this.currentPropertiesProvider;
    }

    protected ModelPropertiesUtil.ModelPropertiesProvider getModelPropertiesProvider() {
        ModelPropertiesUtil.ModelPropertiesProvider provider = this.modelPropertiesProviders == null || this.modelPropertiesProviders.isEmpty() ? ModelPropertiesUtil.newStore((ClassLoader)((Object)((Object)this)).getClass().getClassLoader(), (boolean)false) : ModelPropertiesUtil.newStore(this.modelPropertiesProviders.values(), (boolean)false);
        return provider;
    }

    static enum AvailableData {
        modeltype{

            @Override
            public Map<String, ?> getData(AvailableDataMojo mojo) {
                return mojo.modelTypes;
            }
        }
        ,
        writer{

            @Override
            public Map<String, ?> getData(AvailableDataMojo mojo) {
                return mojo.writers;
            }

            @Override
            String toString(Object data) {
                ChainedFileWriter w = (ChainedFileWriter)data;
                StringBuilder b = new StringBuilder(super.toString(data));
                b.append("\n").append("  inputProtocol             : ");
                b.append(w.getInputProtocol());
                b.append("\n").append("  outputProtocol            : ");
                b.append(w.getOutputProtocol("objectmodel"));
                b.append("\n").append("  defaultIncludes           : ");
                b.append(w.getDefaultIncludes());
                b.append("\n").append("  defaultInputDirectory     : ");
                b.append(w.getDefaultInputDirectory());
                b.append("\n").append("  defaultTestInputDirectory : ");
                b.append(w.getDefaultTestInputDirectory());
                return b.toString();
            }
        }
        ,
        modelreader{

            @Override
            public Map<String, ?> getData(AvailableDataMojo mojo) {
                return mojo.modelReaders;
            }
        }
        ,
        modeltemplate{

            @Override
            public Map<String, ?> getData(AvailableDataMojo mojo) {
                return mojo.modelTemplates;
            }
        }
        ,
        tagvalue{

            @Override
            public Map<String, ?> getData(AvailableDataMojo mojo) {
                return mojo.getCurrentPropertiesProvider().getTagValueStore();
            }

            @Override
            String toString(Object data) {
                Class[] targets;
                ModelPropertiesUtil.TagValueDefinition d = (ModelPropertiesUtil.TagValueDefinition)data;
                StringBuilder sb = new StringBuilder();
                for (Class aClass : targets = d.target()) {
                    sb.append(", ").append(aClass.getSimpleName());
                }
                String result = sb.toString();
                if (targets.length > 0) {
                    result = result.substring(2);
                }
                return result;
            }

            @Override
            void toString(StringBuilder buffer, Map.Entry<String, ?> e) {
                String name = e.getKey();
                Object value = e.getValue();
                buffer.append("\n [");
                buffer.append(name);
                buffer.append("] targets : '");
                buffer.append(this.toString(value));
                buffer.append("' : ");
                buffer.append(((ModelPropertiesUtil.TagValueDefinition)value).documentation());
            }
        }
        ,
        stereotype{

            @Override
            public Map<String, ?> getData(AvailableDataMojo mojo) {
                return mojo.getCurrentPropertiesProvider().getStereotypeStore();
            }

            @Override
            String toString(Object data) {
                Class[] targets;
                ModelPropertiesUtil.StereotypeDefinition d = (ModelPropertiesUtil.StereotypeDefinition)data;
                StringBuilder sb = new StringBuilder();
                for (Class aClass : targets = d.target()) {
                    sb.append(", ").append(aClass.getSimpleName());
                }
                String result = sb.toString();
                if (targets.length > 0) {
                    result = result.substring(2);
                }
                return result;
            }

            @Override
            void toString(StringBuilder buffer, Map.Entry<String, ?> e) {
                String name = e.getKey();
                Object value = e.getValue();
                buffer.append("\n [");
                buffer.append(name);
                buffer.append("] targets : '");
                buffer.append(this.toString(value));
                buffer.append("' : ");
                buffer.append(((ModelPropertiesUtil.StereotypeDefinition)value).documentation());
            }
        };


        abstract Map<String, ?> getData(AvailableDataMojo var1);

        String toString(Object data) {
            return data.getClass().getName();
        }

        void toString(StringBuilder buffer, Map.Entry<String, ?> e) {
            String name = e.getKey();
            Object value = e.getValue();
            buffer.append("\n [");
            buffer.append(name);
            buffer.append("] with implementation '");
            buffer.append(this.toString(value));
            buffer.append('\'');
        }
    }
}

