/*
 * #%L
 * EUGene :: Maven plugin
 * 
 * $Id: ZargoChainedFileWriter.java 863 2010-04-15 14:22:49Z tchemit $
 * $HeadURL: http://svn.nuiton.org/svn/eugene/tags/eugene-2.0.1/maven-eugene-plugin/src/main/java/org/nuiton/eugene/plugin/writer/ZargoChainedFileWriter.java $
 * %%
 * Copyright (C) 2006 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

package org.nuiton.eugene.plugin.writer;

import org.nuiton.eugene.writer.ChainedFileWriterConfiguration;
import org.nuiton.plugin.PluginHelper;
import org.nuiton.plugin.PluginIOContext;

import java.io.File;
import java.io.IOException;

/**
 * To write model files from zargo files.
 *
 * @author tchemit
 * @plexus.component role="org.nuiton.eugene.writer.ChainedFileWriter" role-hint="zargo2xmi"
 * @since 2.0.0
 */
public class ZargoChainedFileWriter extends BaseChainedFileWriter {

    public static final String[] XMI_FILE_FILTER = new String[]{"*.xmi",
                                                                "**/*.xmi"};

    @Override
    public String getInputProtocol() {
        return "zargo";
    }

    @Override
    public String getOutputProtocol(String modelType) {
        // next writer to use is a xmi to model one
        return "xmi";
    }

    @Override
    public boolean acceptModel(String modelType) {
        // accept all models
        return acceptObjectModelOrStateModel(modelType);
    }

    @Override
    public boolean acceptInclude(String include) {
        return include.startsWith("zargo:") ||
               include.endsWith(".zargo") || include.endsWith(".zuml");
    }

    @Override
    public String getDefaultIncludes() {
        return "**/*.zargo";
    }

    @Override
    public String getDefaultInputDirectory() {
        return "src/main/xmi";
    }

    @Override
    public String getDefaultOutputDirectory() {
        return "xmi";
    }

    @Override
    public String getDefaultTestInputDirectory() {
        return "src/test/xmi";
    }

    @Override
    public String getDefaultTestOutputDirectory() {
        return "test-xmi";
    }

    @Override
    public void generate(ChainedFileWriterConfiguration configuration,
                         File outputDir,
                         File inputDirectory,
                         String includePattern) throws IOException {

        boolean overwrite = configuration.isOverwrite();

        PluginIOContext ioContext = new PluginIOContext();
        ioContext.setInput(inputDirectory);
        ioContext.setOutput(outputDir);

        getLog().info("Expanding xmi from " + inputDirectory + " : " +
                      includePattern);

        PluginHelper.expandFiles(ioContext,
                                 new String[]{includePattern},
                                 null,
                                 XMI_FILE_FILTER,
                                 overwrite
        );

        getLog().info("Copying resources from " + inputDirectory + " : " +
                      includePattern);

        PluginHelper.copyFiles(ioContext,
                               null,
                               new String[]{includePattern},
                               overwrite
        );
    }
}
