/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.eugene.plantuml;

import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sourceforge.plantuml.GeneratedImage;
import net.sourceforge.plantuml.SourceFileReader;
import org.nuiton.eugene.models.object.ObjectModel;
import org.nuiton.eugene.models.object.ObjectModelAttribute;
import org.nuiton.eugene.models.object.ObjectModelClass;
import org.nuiton.eugene.models.object.ObjectModelClassifier;
import org.nuiton.eugene.models.object.ObjectModelEnumeration;
import org.nuiton.eugene.models.object.ObjectModelGenerator;
import org.nuiton.eugene.models.object.ObjectModelInterface;
import org.nuiton.eugene.models.object.ObjectModelOperation;
import org.nuiton.eugene.models.object.ObjectModelParameter;
import org.nuiton.eugene.models.object.reader.yaml.KeyWords;
import org.nuiton.eugene.models.object.reader.yaml.YamlUtil;

public class PlantumlTemplatesGenerator
extends ObjectModelGenerator
implements KeyWords {
    public void generateFromModel(Writer output, ObjectModel input) throws IOException {
        output.write("@startuml\n\n");
        String nameM = "";
        String versionM = "";
        String packageM = "";
        if (input.getName() != null) {
            nameM = input.getName();
        }
        if (input.getVersion() != null) {
            versionM = input.getVersion();
        }
        packageM = input.getTagValue("package") != null ? input.getTagValue("package") + " " : this.findPackage(input) + " ";
        output.write("note \"" + nameM + " " + versionM + "\" as N1\n\n");
        output.write("package " + packageM + "{\n\n");
        String indent = "  ";
        for (ObjectModelClass objectModelClass : input.getClasses()) {
            this.generateFromClass(output, objectModelClass, indent);
        }
        for (ObjectModelInterface objectModelInterface : input.getInterfaces()) {
            this.generateFromInterface(output, objectModelInterface, indent);
        }
        for (ObjectModelEnumeration objectModelEnumeration : input.getEnumerations()) {
            this.generateFromEnumeration(output, objectModelEnumeration, indent);
        }
        this.generateFromLinks(output, input, indent);
        output.write("\n");
        output.write("}\n");
        output.write("@enduml");
    }

    public void applyTemplate(ObjectModel model, File destDir) throws IOException {
        super.applyTemplate(model, destDir);
        File plantuml = new File(destDir + File.separator + this.getFilenameForModel(model));
        SourceFileReader reader = new SourceFileReader(plantuml);
        List lst = reader.getGeneratedImages();
        new File(((GeneratedImage)lst.get(0)).getPngFile(), destDir + File.separator + model.getName() + ".png");
    }

    public String getFilenameForModel(ObjectModel model) {
        return model.getName() + ".plantuml";
    }

    public void generateFromClass(Writer output, ObjectModelClass input, String indent) throws IOException {
        String name = "";
        String stereotype = "";
        String isAbstract = "";
        if (input.getName() != null) {
            name = input.getName() + " ";
        }
        if (input.getStereotypes() != null) {
            stereotype = this.getFromStereotypes(input.getStereotypes()) + " ";
        }
        if (input.isAbstract()) {
            isAbstract = "abstract ";
        }
        output.write(indent + isAbstract + "class " + name + stereotype + "{\n");
        if (input.getAttributes() != null && !input.getAttributes().isEmpty()) {
            this.generateFromAttributes(output, input.getAttributes(), indent + "  ");
        }
        output.write(indent + "  ..\n");
        if (input.getOperations() != null) {
            this.generateFromOperations(output, input.getOperations(), indent + "  ");
        }
        output.write(indent + "}\n");
        if (input.getSuperclasses() != null) {
            this.generateFromSuperClasses(output, input.getSuperclasses(), name, indent);
        }
        if (input.getInterfaces() != null) {
            this.generateFromSuperInterfaces(output, input.getInterfaces(), name, indent);
        }
        output.write("\n");
    }

    public void generateFromInterface(Writer output, ObjectModelInterface input, String indent) throws IOException {
        String name = "";
        String stereotype = "";
        if (input.getName() != null) {
            name = input.getName() + " ";
        }
        if (input.getStereotypes() != null) {
            stereotype = this.getFromStereotypes(input.getStereotypes()) + " ";
        }
        output.write(indent + "class " + name + stereotype + "{\n");
        if (input.getAttributes() != null && !input.getAttributes().isEmpty()) {
            this.generateFromAttributes(output, input.getAttributes(), indent + "  ");
        }
        output.write(indent + "  ..\n");
        if (input.getOperations() != null) {
            this.generateFromOperations(output, input.getOperations(), indent + "  ");
        }
        output.write(indent + "}\n");
        if (input.getInterfaces() != null) {
            this.generateFromSuperInterfaces(output, input.getInterfaces(), name, indent);
        }
        output.write("\n");
    }

    public void generateFromEnumeration(Writer output, ObjectModelEnumeration input, String indent) throws IOException {
        String name = "";
        String stereotype = "";
        if (input.getName() != null) {
            name = input.getName() + " ";
        }
        if (input.getStereotypes() != null) {
            stereotype = this.getFromStereotypes(input.getStereotypes()) + " ";
        }
        output.write(indent + "enum " + name + stereotype + "{\n");
        if (input.getLiterals() != null && !input.getAttributes().isEmpty()) {
            for (String literal : input.getLiterals()) {
                output.write(indent + "  " + literal.toUpperCase() + "\n");
            }
        }
        output.write(indent + "  ..\n");
        if (input.getOperations() != null) {
            this.generateFromOperations(output, input.getOperations(), indent + "  ");
        }
        output.write(indent + "}\n");
        output.write("\n");
    }

    public String getFromStereotypes(Set<String> stereotypes) {
        StringBuilder stereotype = new StringBuilder("");
        if (stereotypes.size() > 0) {
            stereotype.append("<< ");
            boolean first = true;
            for (String str : stereotypes) {
                if (first) {
                    first = false;
                } else {
                    stereotype.append(", ");
                }
                stereotype.append(str);
            }
            stereotype.append(" >>");
        }
        return stereotype.toString();
    }

    public void generateFromAttributes(Writer output, Collection<ObjectModelAttribute> input, String indent) throws IOException {
        for (ObjectModelAttribute attribute : input) {
            if (attribute.referenceClassifier()) continue;
            String visibility = "";
            if (attribute.getVisibility() != null) {
                if (attribute.getVisibility().equals("public")) {
                    visibility = "+ ";
                } else if (attribute.getVisibility().equals("protected")) {
                    visibility = "# ";
                } else if (attribute.getVisibility().equals("private")) {
                    visibility = "- ";
                }
            }
            String type = "";
            String name = "";
            if (attribute.getType() != null) {
                type = PlantumlTemplatesGenerator.reduceType(attribute.getType()) + " ";
            }
            if (attribute.getName() != null) {
                name = attribute.getName();
            }
            output.write(indent + visibility + type + name + "\n");
        }
    }

    public void generateFromOperations(Writer output, Collection<ObjectModelOperation> input, String indent) throws IOException {
        for (ObjectModelOperation operation : input) {
            String isAbstract = "";
            String isStatic = "";
            String parameters = "";
            String name = "";
            String returnParameter = "";
            if (operation.isAbstract()) {
                isAbstract = "{abstract} ";
            }
            if (operation.isStatic()) {
                isAbstract = "{static} ";
            }
            String visibility = "";
            if (operation.getVisibility() != null) {
                if (operation.getVisibility().equals("public")) {
                    visibility = "+ ";
                } else if (operation.getVisibility().equals("protected")) {
                    visibility = "# ";
                } else if (operation.getVisibility().equals("private")) {
                    visibility = "- ";
                }
            }
            if (operation.getParameters() != null) {
                StringBuilder tmp = new StringBuilder("");
                boolean first = true;
                for (ObjectModelParameter parameter : operation.getParameters()) {
                    if (first) {
                        first = false;
                    } else {
                        tmp.append(", ");
                    }
                    if (parameter.getType() != null) {
                        tmp.append(PlantumlTemplatesGenerator.reduceType(parameter.getType())).append(" ");
                    }
                    if (parameter.getName() == null) continue;
                    tmp.append(parameter.getName());
                }
                parameters = tmp.toString();
            }
            if (operation.getReturnParameter() != null && operation.getReturnParameter().getType() != null) {
                returnParameter = PlantumlTemplatesGenerator.reduceType(operation.getReturnParameter().getType()) + " ";
            }
            if (operation.getName() != null) {
                name = operation.getName();
            }
            output.write(indent + isAbstract + isStatic + visibility + returnParameter + name + "(" + parameters + ")\n");
        }
    }

    public void generateFromSuperClasses(Writer output, Collection<ObjectModelClass> input, String name, String indent) throws IOException {
        for (ObjectModelClass superClass : input) {
            String superClassName = "";
            if (superClass.getName() != null) {
                superClassName = superClass.getName();
            }
            output.write(indent + superClassName + " <|-- " + name + "\n");
        }
    }

    public void generateFromSuperInterfaces(Writer output, Collection<ObjectModelInterface> input, String name, String indent) throws IOException {
        for (ObjectModelInterface superInterface : input) {
            String superInterfaceName = "";
            if (superInterface.getName() != null) {
                superInterfaceName = superInterface.getName();
            }
            output.write(indent + superInterfaceName + " <|.. " + name + "\n");
        }
    }

    public void generateFromLinks(Writer output, ObjectModel input, String indent) throws IOException {
        LinkedHashMap<ObjectModelAttribute, ObjectModelClassifier> attributesM = new LinkedHashMap<ObjectModelAttribute, ObjectModelClassifier>();
        LinkedList<ObjectModelAttribute> bin = new LinkedList<ObjectModelAttribute>();
        for (ObjectModelClassifier objectModelClassifier : input.getClassifiers()) {
            if (objectModelClassifier.getAttributes() == null) continue;
            for (ObjectModelAttribute attribute : objectModelClassifier.getAttributes()) {
                if (!attribute.referenceClassifier()) continue;
                attributesM.put(attribute, objectModelClassifier);
            }
        }
        for (Map.Entry entry : attributesM.entrySet()) {
            ObjectModelAttribute attribute = (ObjectModelAttribute)entry.getKey();
            ObjectModelClassifier classifier = (ObjectModelClassifier)entry.getValue();
            if (!attribute.isNavigable()) continue;
            String attributeName = "";
            if (attribute.getName() != null) {
                attributeName = attribute.getName();
            }
            String associationType = "";
            if (attribute.isComposite()) {
                associationType = "*";
            } else if (attribute.isAggregate()) {
                associationType = "o";
            }
            String minMultiplicity = attribute.getMinMultiplicity() == -1 ? "*" : String.valueOf(attribute.getMinMultiplicity());
            String maxMultiplicity = attribute.getMaxMultiplicity() == -1 ? "*" : String.valueOf(attribute.getMaxMultiplicity());
            String multiplicity = minMultiplicity.equals(maxMultiplicity) ? minMultiplicity : minMultiplicity + ".." + maxMultiplicity;
            String type = YamlUtil.afterChar((String)attribute.getType(), (Character)Character.valueOf('.'));
            if (bin.contains(attribute)) continue;
            if (attribute.getReverseAttribute() != null) {
                ObjectModelAttribute reverseAttribute = attribute.getReverseAttribute();
                String reverseAttributeName = "";
                if (reverseAttribute.getName() != null) {
                    reverseAttributeName = reverseAttribute.getName();
                }
                String reverseMinMultiplicity = reverseAttribute.getMinMultiplicity() == -1 ? "*" : String.valueOf(reverseAttribute.getMinMultiplicity());
                String reverseMaxMultiplicity = reverseAttribute.getMaxMultiplicity() == -1 ? "*" : String.valueOf(reverseAttribute.getMaxMultiplicity());
                String reverseMultiplicity = reverseMinMultiplicity.equals(reverseMaxMultiplicity) ? reverseMinMultiplicity : reverseMinMultiplicity + ".." + reverseMaxMultiplicity;
                String reverseType = YamlUtil.afterChar((String)reverseAttribute.getType(), (Character)Character.valueOf('.'));
                if (reverseAttribute.isNavigable()) {
                    output.write(indent + type + " \"" + multiplicity + " " + attributeName + "\" -- \"" + reverseMultiplicity + " " + reverseAttributeName + "\" " + reverseType + "\n");
                    if (attribute.getAssociationClass() != null && reverseAttribute.getAssociationClass() != null && attribute.getAssociationClass().equals(reverseAttribute.getAssociationClass())) {
                        String associationClassName = "";
                        if (attribute.getAssociationClass().getName() != null) {
                            associationClassName = attribute.getAssociationClass().getName();
                        }
                        output.write(indent + "(" + type + ", " + reverseType + ") . " + associationClassName + "\n");
                    }
                    bin.add(reverseAttribute);
                    continue;
                }
                output.write(indent + type + " \"" + multiplicity + " " + attributeName + "\" <--" + associationType + " \"" + reverseMultiplicity + " " + reverseAttributeName + "\" " + reverseType + "\n");
                continue;
            }
            String reverseType = "";
            if (((ObjectModelClassifier)attributesM.get(attribute)).getName() != null) {
                reverseType = ((ObjectModelClassifier)attributesM.get(attribute)).getName();
            }
            output.write(indent + type + " \"" + multiplicity + " " + attributeName + "\" <-- " + reverseType + "\n");
        }
    }

    public static String browseType(String type) {
        StringBuilder res = new StringBuilder();
        boolean first = true;
        for (String tmp : YamlUtil.charParseIgnore((String)type, (Character)Character.valueOf(','), (Character)Character.valueOf('<'), (Character)Character.valueOf('>'))) {
            if (first) {
                first = false;
            } else {
                res.append(",");
            }
            if (tmp.contains("<") && tmp.contains(">")) {
                String ninja = YamlUtil.beforeChar((String)tmp, (Character)Character.valueOf('<'));
                res.append(YamlUtil.afterChar((String)ninja, (Character)Character.valueOf('.')));
                res.append("<");
                res.append(PlantumlTemplatesGenerator.browseType(YamlUtil.extract((Character)Character.valueOf('<'), (Character)Character.valueOf('>'), (String)tmp)));
                res.append(">");
                continue;
            }
            res.append(YamlUtil.afterChar((String)tmp, (Character)Character.valueOf('.')));
        }
        return res.toString();
    }

    public static String reduceType(String type) {
        LinkedList<Character> ignore = new LinkedList<Character>();
        ignore.add(Character.valueOf(' '));
        String typePARSE = YamlUtil.removeMultiChar((String)type, ignore);
        return PlantumlTemplatesGenerator.browseType(typePARSE);
    }

    public String findPackage(ObjectModel input) {
        LinkedHashMap<String, Integer> packages = new LinkedHashMap<String, Integer>();
        for (ObjectModelClassifier classifier : input.getClassifiers()) {
            String packageTMP = classifier.getPackageName();
            if (packageTMP == null) continue;
            if (packages.containsKey(packageTMP)) {
                packages.put(packageTMP, (Integer)packages.get(packageTMP) + 1);
                continue;
            }
            packages.put(packageTMP, 1);
        }
        String packageL = "";
        int count = 0;
        for (Map.Entry entry : packages.entrySet()) {
            if ((Integer)entry.getValue() <= count) continue;
            count = (Integer)entry.getValue();
            packageL = (String)entry.getKey();
        }
        return packageL;
    }
}

