/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.jcublas.buffer;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.bytedeco.javacpp.Pointer;
import org.bytedeco.javacpp.indexer.Indexer;
import org.nd4j.common.util.ArrayUtil;
import org.nd4j.linalg.api.buffer.DataBuffer;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.memory.MemoryWorkspace;
import org.nd4j.linalg.jcublas.buffer.BaseCudaDataBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CudaFloatDataBuffer
extends BaseCudaDataBuffer {
    private static final Logger log = LoggerFactory.getLogger(CudaFloatDataBuffer.class);

    public CudaFloatDataBuffer(Pointer pointer, Indexer indexer, long length) {
        super(pointer, indexer, length);
    }

    public CudaFloatDataBuffer(Pointer pointer, Pointer specialPointer, Indexer indexer, long length) {
        super(pointer, specialPointer, indexer, length);
    }

    public CudaFloatDataBuffer(ByteBuffer buffer, DataType dataType, long length, long offset) {
        super(buffer, dataType, length, offset);
    }

    public CudaFloatDataBuffer(long length) {
        super(length, 4);
    }

    public CudaFloatDataBuffer(long length, boolean initialize) {
        super(length, 4, initialize);
    }

    public CudaFloatDataBuffer(long length, boolean initialize, MemoryWorkspace workspace) {
        super(length, 4, initialize, workspace);
    }

    public CudaFloatDataBuffer(long length, int elementSize) {
        super(length, elementSize);
    }

    public CudaFloatDataBuffer(long length, int elementSize, long offset) {
        super(length, elementSize, offset);
    }

    protected void initTypeAndSize() {
        this.elementSize = (byte)4;
        this.type = DataType.FLOAT;
    }

    public CudaFloatDataBuffer(DataBuffer underlyingBuffer, long length, long offset) {
        super(underlyingBuffer, length, offset);
    }

    public CudaFloatDataBuffer(float[] buffer) {
        super(buffer);
    }

    public CudaFloatDataBuffer(float[] data, boolean copy) {
        super(data, copy);
    }

    public CudaFloatDataBuffer(float[] data, boolean copy, MemoryWorkspace workspace) {
        super(data, copy, workspace);
    }

    public CudaFloatDataBuffer(float[] data, boolean copy, long offset) {
        super(data, copy, offset);
    }

    public CudaFloatDataBuffer(float[] data, boolean copy, long offset, MemoryWorkspace workspace) {
        super(data, copy, offset, workspace);
    }

    public CudaFloatDataBuffer(double[] data) {
        super(data);
    }

    public CudaFloatDataBuffer(double[] data, boolean copy) {
        super(data, copy);
    }

    public CudaFloatDataBuffer(double[] data, boolean copy, long offset) {
        super(data, copy, offset);
    }

    public CudaFloatDataBuffer(int[] data) {
        super(data);
    }

    public CudaFloatDataBuffer(int[] data, boolean copy) {
        super(data, copy);
    }

    public CudaFloatDataBuffer(int[] data, boolean copy, long offset) {
        super(data, copy, offset);
    }

    protected DataBuffer create(long length) {
        return new CudaFloatDataBuffer(length);
    }

    public double[] getDoublesAt(long offset, long inc, int length) {
        return ArrayUtil.toDoubles((float[])this.getFloatsAt(offset, inc, length));
    }

    @Override
    public void setData(int[] data) {
        this.setData(ArrayUtil.toFloats((int[])data));
    }

    @Override
    public void setData(double[] data) {
        this.setData(ArrayUtil.toFloats((double[])data));
    }

    @Override
    public byte[] asBytes() {
        float[] data = this.asFloat();
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(bos);
        for (int i = 0; i < data.length; ++i) {
            try {
                dos.writeFloat(data[i]);
                continue;
            }
            catch (IOException e) {
                log.error("", (Throwable)e);
            }
        }
        return bos.toByteArray();
    }

    public DataType dataType() {
        return this.type;
    }

    @Override
    public double[] asDouble() {
        return ArrayUtil.toDoubles((float[])this.asFloat());
    }

    @Override
    public int[] asInt() {
        return ArrayUtil.toInts((float[])this.asFloat());
    }

    @Override
    public double getDouble(long i) {
        return super.getFloat(i);
    }

    public DataBuffer create(double[] data) {
        return new CudaFloatDataBuffer(data);
    }

    public DataBuffer create(float[] data) {
        return new CudaFloatDataBuffer(data);
    }

    public DataBuffer create(int[] data) {
        return new CudaFloatDataBuffer(data);
    }

    @Override
    public void flush() {
    }
}

