/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.jita.allocator.time.rings;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.nd4j.jita.allocator.time.Ring;

public class LockedRing
implements Ring {
    private final float[] ring;
    private final AtomicInteger position = new AtomicInteger(0);
    private ReentrantReadWriteLock lock = new ReentrantReadWriteLock();

    public LockedRing(int ringLength) {
        this.ring = new float[ringLength];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public float getAverage() {
        try {
            this.lock.readLock().lock();
            float rates = 0.0f;
            int x = 0;
            int existing = 0;
            for (x = 0; x < this.ring.length; ++x) {
                rates += this.ring[x];
                if (!(this.ring[x] > 0.0f)) continue;
                ++existing;
            }
            if (existing > 0) {
                float f = rates / (float)existing;
                return f;
            }
            float f = 0.0f;
            return f;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public void store(double rate) {
        this.store((float)rate);
    }

    @Override
    public void store(float rate) {
        try {
            this.lock.writeLock().lock();
            int pos = this.position.getAndIncrement();
            if (pos >= this.ring.length) {
                pos = 0;
                this.position.set(0);
            }
            this.ring[pos] = rate;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }
}

