/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.jita.allocator.time.impl;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.nd4j.jita.allocator.time.RateTimer;

public class BinaryTimer
implements RateTimer {
    private AtomicLong timer = new AtomicLong(System.currentTimeMillis());
    private long timeframeMilliseconds;

    public BinaryTimer(long timeframe, TimeUnit timeUnit) {
        this.timeframeMilliseconds = TimeUnit.MILLISECONDS.convert(timeframe, timeUnit);
    }

    @Override
    public void triggerEvent() {
        this.timer.set(System.currentTimeMillis());
    }

    @Override
    public double getFrequencyOfEvents() {
        if (this.isAlive()) {
            return 1.0;
        }
        return 0.0;
    }

    @Override
    public long getNumberOfEvents() {
        if (this.isAlive()) {
            return 1L;
        }
        return 0L;
    }

    protected boolean isAlive() {
        long currentTime = System.currentTimeMillis();
        return currentTime - this.timer.get() <= this.timeframeMilliseconds;
    }
}

