/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.jita.allocator.impl;

import org.nd4j.linalg.api.buffer.DataType;

public class AllocationShape {
    private long length = 0L;
    private byte elementSize = 0;
    private DataType dataType = DataType.FLOAT;

    public AllocationShape(long length, int elementSize, DataType dataType) {
        this.length = length;
        this.elementSize = (byte)elementSize;
        this.dataType = dataType;
    }

    public int getElementSize() {
        return this.elementSize;
    }

    public void setElementSize(int elementSize) {
        this.elementSize = (byte)elementSize;
    }

    public long getNumberOfBytes() {
        return this.length * (long)this.elementSize;
    }

    public long getLength() {
        return this.length;
    }

    public DataType getDataType() {
        return this.dataType;
    }

    public void setLength(long length) {
        this.length = length;
    }

    public void setDataType(DataType dataType) {
        this.dataType = dataType;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AllocationShape)) {
            return false;
        }
        AllocationShape other = (AllocationShape)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getLength() != other.getLength()) {
            return false;
        }
        if (this.getElementSize() != other.getElementSize()) {
            return false;
        }
        DataType this$dataType = this.getDataType();
        DataType other$dataType = other.getDataType();
        return !(this$dataType == null ? other$dataType != null : !this$dataType.equals(other$dataType));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AllocationShape;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $length = this.getLength();
        result = result * 59 + (int)($length >>> 32 ^ $length);
        result = result * 59 + this.getElementSize();
        DataType $dataType = this.getDataType();
        result = result * 59 + ($dataType == null ? 43 : $dataType.hashCode());
        return result;
    }

    public String toString() {
        return "AllocationShape(length=" + this.getLength() + ", elementSize=" + this.getElementSize() + ", dataType=" + this.getDataType() + ")";
    }

    public AllocationShape() {
    }
}

