/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util.log;

import java.io.PrintStream;
import java.security.AccessControlException;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.eclipse.jetty.util.DateCache;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class StdErrLog
implements Logger {
    private static DateCache _dateCache;
    private static final boolean __source;
    private static final boolean __long;
    private static final ConcurrentMap<String, StdErrLog> __loggers;
    public static final int LEVEL_ALL = 0;
    public static final int LEVEL_DEBUG = 1;
    public static final int LEVEL_INFO = 2;
    public static final int LEVEL_WARN = 3;
    private int _level = 2;
    private PrintStream _stderr = System.err;
    private boolean _source = __source;
    private boolean _printLongNames = __long;
    private final String _name;
    private final String _abbrevname;
    private boolean _hideStacks = false;

    public StdErrLog() {
        this(null);
    }

    public StdErrLog(String name) {
        this._name = name == null ? "" : name;
        this._abbrevname = StdErrLog.condensePackageString(this._name);
        this._level = StdErrLog.getLoggingLevel(System.getProperties(), this._name);
        try {
            this._source = Boolean.parseBoolean(System.getProperty(this._name + ".SOURCE", Boolean.toString(this._source)));
        }
        catch (AccessControlException ace) {
            this._source = __source;
        }
    }

    public static int getLoggingLevel(Properties props, String name) {
        String nameSegment = name;
        while (nameSegment != null && nameSegment.length() > 0) {
            String levelStr = props.getProperty(nameSegment + ".LEVEL");
            if (levelStr == null) {
                int idx = nameSegment.lastIndexOf(46);
                if (idx >= 0) {
                    nameSegment = nameSegment.substring(0, idx);
                    continue;
                }
                nameSegment = null;
                continue;
            }
            if ("ALL".equalsIgnoreCase(levelStr.trim())) {
                return 0;
            }
            if ("DEBUG".equalsIgnoreCase(levelStr.trim())) {
                return 1;
            }
            if ("INFO".equalsIgnoreCase(levelStr.trim())) {
                return 2;
            }
            if (!"WARN".equalsIgnoreCase(levelStr.trim())) continue;
            return 3;
        }
        return 2;
    }

    protected static String condensePackageString(String classname) {
        String[] parts = classname.split("\\.");
        StringBuilder dense = new StringBuilder();
        for (int i = 0; i < parts.length - 1; ++i) {
            dense.append(parts[i].charAt(0));
        }
        if (dense.length() > 0) {
            dense.append('.');
        }
        dense.append(parts[parts.length - 1]);
        return dense.toString();
    }

    @Override
    public String getName() {
        return this._name;
    }

    public void setPrintLongNames(boolean printLongNames) {
        this._printLongNames = printLongNames;
    }

    public boolean isPrintLongNames() {
        return this._printLongNames;
    }

    public boolean isHideStacks() {
        return this._hideStacks;
    }

    public void setHideStacks(boolean hideStacks) {
        this._hideStacks = hideStacks;
    }

    public boolean isSource() {
        return this._source;
    }

    public void setSource(boolean source) {
        this._source = source;
    }

    @Override
    public void warn(String msg, Object ... args) {
        if (this._level <= 3) {
            StringBuilder buffer = new StringBuilder(64);
            this.format(buffer, ":WARN:", msg, args);
            this._stderr.println(buffer);
        }
    }

    @Override
    public void warn(Throwable thrown) {
        this.warn("", thrown);
    }

    @Override
    public void warn(String msg, Throwable thrown) {
        if (this._level <= 3) {
            StringBuilder buffer = new StringBuilder(64);
            this.format(buffer, ":WARN:", msg, thrown);
            this._stderr.println(buffer);
        }
    }

    @Override
    public void info(String msg, Object ... args) {
        if (this._level <= 2) {
            StringBuilder buffer = new StringBuilder(64);
            this.format(buffer, ":INFO:", msg, args);
            this._stderr.println(buffer);
        }
    }

    @Override
    public void info(Throwable thrown) {
        this.info("", thrown);
    }

    @Override
    public void info(String msg, Throwable thrown) {
        if (this._level <= 2) {
            StringBuilder buffer = new StringBuilder(64);
            this.format(buffer, ":INFO:", msg, thrown);
            this._stderr.println(buffer);
        }
    }

    @Override
    public boolean isDebugEnabled() {
        return this._level >= 1;
    }

    @Override
    @Deprecated
    public void setDebugEnabled(boolean enabled) {
        this._level = enabled ? 1 : 2;
    }

    public int getLevel() {
        return this._level;
    }

    public void setLevel(int level) {
        this._level = level;
    }

    public void setStdErrStream(PrintStream stream) {
        this._stderr = stream;
    }

    @Override
    public void debug(String msg, Object ... args) {
        if (this._level <= 1) {
            StringBuilder buffer = new StringBuilder(64);
            this.format(buffer, ":DBUG:", msg, args);
            this._stderr.println(buffer);
        }
    }

    @Override
    public void debug(Throwable thrown) {
        this.debug("", thrown);
    }

    @Override
    public void debug(String msg, Throwable thrown) {
        if (this._level <= 1) {
            StringBuilder buffer = new StringBuilder(64);
            this.format(buffer, ":DBUG:", msg, thrown);
            this._stderr.println(buffer);
        }
    }

    private void format(StringBuilder buffer, String level, String msg, Object ... args) {
        String d = _dateCache.now();
        int ms = _dateCache.lastMs();
        this.tag(buffer, d, ms, level);
        this.format(buffer, msg, args);
    }

    private void format(StringBuilder buffer, String level, String msg, Throwable thrown) {
        this.format(buffer, level, msg, new Object[0]);
        if (this.isHideStacks()) {
            this.format(buffer, String.valueOf(thrown), new Object[0]);
        } else {
            this.format(buffer, thrown);
        }
    }

    private void tag(StringBuilder buffer, String d, int ms, String tag) {
        buffer.setLength(0);
        buffer.append(d);
        if (ms > 99) {
            buffer.append('.');
        } else if (ms > 9) {
            buffer.append(".0");
        } else {
            buffer.append(".00");
        }
        buffer.append(ms).append(tag);
        if (this._printLongNames) {
            buffer.append(this._name);
        } else {
            buffer.append(this._abbrevname);
        }
        buffer.append(':');
        if (this._source) {
            Throwable source = new Throwable();
            StackTraceElement[] frames = source.getStackTrace();
            for (int i = 0; i < frames.length; ++i) {
                StackTraceElement frame = frames[i];
                String clazz = frame.getClassName();
                if (clazz.equals(StdErrLog.class.getName()) || clazz.equals(Log.class.getName())) continue;
                if (!this._printLongNames && clazz.startsWith("org.eclipse.jetty.")) {
                    buffer.append(StdErrLog.condensePackageString(clazz));
                } else {
                    buffer.append(clazz);
                }
                buffer.append('#').append(frame.getMethodName());
                if (frame.getFileName() != null) {
                    buffer.append('(').append(frame.getFileName()).append(':').append(frame.getLineNumber()).append(')');
                }
                buffer.append(':');
                break;
            }
        }
    }

    private void format(StringBuilder builder, String msg, Object ... args) {
        if (msg == null) {
            msg = "";
            for (int i = 0; i < args.length; ++i) {
                msg = msg + "{} ";
            }
        }
        String braces = "{}";
        int start = 0;
        for (Object arg : args) {
            int bracesIndex = msg.indexOf(braces, start);
            if (bracesIndex < 0) {
                this.escape(builder, msg.substring(start));
                builder.append(" ");
                builder.append(arg);
                start = msg.length();
                continue;
            }
            this.escape(builder, msg.substring(start, bracesIndex));
            builder.append(String.valueOf(arg));
            start = bracesIndex + braces.length();
        }
        this.escape(builder, msg.substring(start));
    }

    private void escape(StringBuilder builder, String string) {
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (Character.isISOControl(c)) {
                if (c == '\n') {
                    builder.append('|');
                    continue;
                }
                if (c == '\r') {
                    builder.append('<');
                    continue;
                }
                builder.append('?');
                continue;
            }
            builder.append(c);
        }
    }

    private void format(StringBuilder buffer, Throwable thrown) {
        if (thrown == null) {
            buffer.append("null");
        } else {
            buffer.append('\n');
            this.format(buffer, thrown.toString(), new Object[0]);
            StackTraceElement[] elements = thrown.getStackTrace();
            for (int i = 0; elements != null && i < elements.length; ++i) {
                buffer.append("\n\tat ");
                this.format(buffer, elements[i].toString(), new Object[0]);
            }
            Throwable cause = thrown.getCause();
            if (cause != null && cause != thrown) {
                buffer.append("\nCaused by: ");
                this.format(buffer, cause);
            }
        }
    }

    @Override
    public Logger getLogger(String name) {
        String fullname;
        String string = fullname = this._name == null || this._name.length() == 0 ? name : this._name + "." + name;
        if (name == null && this._name == null || fullname.equals(this._name)) {
            return this;
        }
        StdErrLog logger = (StdErrLog)__loggers.get(name);
        if (logger == null) {
            StdErrLog sel = new StdErrLog(fullname);
            sel.setPrintLongNames(this._printLongNames);
            sel.setLevel(this._level);
            sel.setSource(this._source);
            logger = __loggers.putIfAbsent(fullname, sel);
            if (logger == null) {
                logger = sel;
            }
        }
        return logger;
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append("StdErrLog:");
        s.append(this._name);
        s.append(":LEVEL=");
        switch (this._level) {
            case 0: {
                s.append("ALL");
                break;
            }
            case 1: {
                s.append("DEBUG");
                break;
            }
            case 2: {
                s.append("INFO");
                break;
            }
            case 3: {
                s.append("WARN");
                break;
            }
            default: {
                s.append("?");
            }
        }
        return s.toString();
    }

    @Override
    public void ignore(Throwable ignored) {
        if (this._level <= 0) {
            StringBuilder buffer = new StringBuilder(64);
            this.format(buffer, ":IGNORED:", "", ignored);
            this._stderr.println(buffer);
        }
    }

    static {
        String[] deprecatedProperites;
        __source = Boolean.parseBoolean(System.getProperty("org.eclipse.jetty.util.log.SOURCE", System.getProperty("org.eclipse.jetty.util.log.stderr.SOURCE", "false")));
        __long = Boolean.parseBoolean(System.getProperty("org.eclipse.jetty.util.log.stderr.LONG", "false"));
        __loggers = new ConcurrentHashMap<String, StdErrLog>();
        for (String deprecatedProp : deprecatedProperites = new String[]{"DEBUG", "org.eclipse.jetty.util.log.DEBUG", "org.eclipse.jetty.util.log.stderr.DEBUG"}) {
            if (System.getProperty(deprecatedProp) == null) continue;
            System.err.printf("System Property [%s] has been deprecated! (Use org.eclipse.jetty.LEVEL=DEBUG instead)%n", deprecatedProp);
        }
        try {
            _dateCache = new DateCache("yyyy-MM-dd HH:mm:ss");
        }
        catch (Exception x) {
            x.printStackTrace(System.err);
        }
    }
}

