/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.scribe.reflection;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Map;
import org.milyn.assertion.AssertArgument;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LookupWithNamedQueryMethod {
    final Method method;
    final int queryIndex;
    final int parameterIndex;

    public LookupWithNamedQueryMethod(Method method, int queryIndex, int parameterIndex) {
        AssertArgument.isNotNull(method, "method");
        if (queryIndex < 0) {
            throw new IllegalArgumentException("queryIndex can't be smaller then zero");
        }
        if (queryIndex > 1) {
            throw new IllegalArgumentException("queryIndex can't be bigger then one");
        }
        if (parameterIndex < 0) {
            throw new IllegalArgumentException("queryIndex can't be smaller then zero");
        }
        if (parameterIndex > 1) {
            throw new IllegalArgumentException("queryIndex can't be bigger then one");
        }
        if (queryIndex == parameterIndex) {
            throw new IllegalArgumentException("queryIndex and parameterIndex can't be the same");
        }
        this.method = method;
        this.queryIndex = queryIndex;
        this.parameterIndex = parameterIndex;
    }

    public Collection<?> invoke(Object obj, String query, Map<String, ?> parameters) {
        Object[] args = new Object[2];
        args[this.queryIndex] = query;
        args[this.parameterIndex] = parameters;
        try {
            return (Collection)this.method.invoke(obj, args);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException("The method [" + this.method + "] of the class [" + this.method.getDeclaringClass().getName() + "] threw an exception, while invoking it with the object [" + obj + "].", e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("The method [" + this.method + "] of the class [" + this.method.getDeclaringClass().getName() + "] threw an exception, while invoking it with the object [" + obj + "].", e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException("The method [" + this.method + "] of the class [" + this.method.getDeclaringClass().getName() + "] threw an exception, while invoking it with the object [" + obj + "].", e);
        }
    }
}

