/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.javabean.decoders;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Locale;
import java.util.Properties;
import org.milyn.cdr.SmooksConfigurationException;
import org.milyn.javabean.DataDecodeException;
import org.milyn.javabean.DataEncoder;
import org.milyn.javabean.decoders.LocaleAwareDecoder;

public abstract class NumberDecoder
extends LocaleAwareDecoder
implements DataEncoder {
    public static final String FORMAT = "format";
    public static final String TYPE = "type";
    private NumberType type;
    private NumberFormat numberFormat;

    public void setConfiguration(Properties config) throws SmooksConfigurationException {
        super.setConfiguration(config);
        String pattern = config.getProperty(FORMAT);
        String typeConfig = config.getProperty(TYPE);
        Locale locale = this.getLocale();
        if (locale == null && pattern == null) {
            return;
        }
        if (locale == null) {
            locale = Locale.getDefault();
        }
        if (typeConfig == null) {
            this.type = NumberType.RAW;
        } else {
            try {
                this.type = NumberType.valueOf(typeConfig);
            }
            catch (Exception e) {
                throw new SmooksConfigurationException("Unsupported Number type specification '" + typeConfig + "'.  Must be one of '" + NumberType.values() + "'.");
            }
        }
        if (this.type == NumberType.PERCENTAGE || pattern != null && pattern.indexOf(37) != -1) {
            this.type = NumberType.PERCENTAGE;
            this.numberFormat = NumberFormat.getPercentInstance(locale);
        } else if (this.type == NumberType.CURRENCY) {
            this.numberFormat = NumberFormat.getCurrencyInstance(locale);
        } else {
            this.numberFormat = NumberFormat.getInstance(locale);
            this.numberFormat.setGroupingUsed(false);
            if (pattern != null && this.numberFormat instanceof DecimalFormat) {
                ((DecimalFormat)this.numberFormat).applyPattern(pattern);
            }
        }
    }

    public NumberFormat getNumberFormat() {
        if (this.numberFormat != null) {
            return (NumberFormat)this.numberFormat.clone();
        }
        return null;
    }

    public NumberType getType() {
        return this.type;
    }

    public boolean isPercentage() {
        return this.type == NumberType.PERCENTAGE;
    }

    public String encode(Object object) throws DataDecodeException {
        if (this.numberFormat != null) {
            return this.getNumberFormat().format(object);
        }
        return object.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum NumberType {
        RAW,
        PERCENTAGE,
        CURRENCY;

    }
}

