/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.internal.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.mapstruct.ap.internal.model.LifecycleCallbackMethodReference;
import org.mapstruct.ap.internal.model.MapperReference;
import org.mapstruct.ap.internal.model.MappingBuilderContext;
import org.mapstruct.ap.internal.model.common.Parameter;
import org.mapstruct.ap.internal.model.common.Type;
import org.mapstruct.ap.internal.model.source.Method;
import org.mapstruct.ap.internal.model.source.ParameterProvidedMethods;
import org.mapstruct.ap.internal.model.source.SelectionParameters;
import org.mapstruct.ap.internal.model.source.SourceMethod;
import org.mapstruct.ap.internal.model.source.selector.MethodSelectors;
import org.mapstruct.ap.internal.model.source.selector.SelectedMethod;
import org.mapstruct.ap.internal.model.source.selector.SelectionCriteria;

public final class LifecycleCallbackFactory {
    private LifecycleCallbackFactory() {
    }

    public static List<LifecycleCallbackMethodReference> beforeMappingMethods(Method method, SelectionParameters selectionParameters, MappingBuilderContext ctx, Set<String> existingVariableNames) {
        return LifecycleCallbackFactory.collectLifecycleCallbackMethods(method, selectionParameters, LifecycleCallbackFactory.filterBeforeMappingMethods(LifecycleCallbackFactory.getAllAvailableMethods(method, ctx.getSourceModel())), ctx, existingVariableNames);
    }

    public static List<LifecycleCallbackMethodReference> afterMappingMethods(Method method, SelectionParameters selectionParameters, MappingBuilderContext ctx, Set<String> existingVariableNames) {
        return LifecycleCallbackFactory.collectLifecycleCallbackMethods(method, selectionParameters, LifecycleCallbackFactory.filterAfterMappingMethods(LifecycleCallbackFactory.getAllAvailableMethods(method, ctx.getSourceModel())), ctx, existingVariableNames);
    }

    private static List<SourceMethod> getAllAvailableMethods(Method method, List<SourceMethod> sourceModelMethods) {
        ParameterProvidedMethods contextProvidedMethods = method.getContextProvidedMethods();
        if (contextProvidedMethods.isEmpty()) {
            return sourceModelMethods;
        }
        List<SourceMethod> methodsProvidedByParams = contextProvidedMethods.getAllProvidedMethodsInParameterOrder(method.getContextParameters());
        ArrayList<SourceMethod> availableMethods = new ArrayList<SourceMethod>(methodsProvidedByParams.size() + sourceModelMethods.size());
        availableMethods.addAll(methodsProvidedByParams);
        availableMethods.addAll(sourceModelMethods);
        return availableMethods;
    }

    private static List<LifecycleCallbackMethodReference> collectLifecycleCallbackMethods(Method method, SelectionParameters selectionParameters, List<SourceMethod> callbackMethods, MappingBuilderContext ctx, Set<String> existingVariableNames) {
        MethodSelectors selectors = new MethodSelectors(ctx.getTypeUtils(), ctx.getElementUtils(), ctx.getTypeFactory());
        List<SelectedMethod<SourceMethod>> matchingMethods = selectors.getMatchingMethods(method, callbackMethods, Collections.<Type>emptyList(), method.getResultType(), SelectionCriteria.forLifecycleMethods(selectionParameters));
        return LifecycleCallbackFactory.toLifecycleCallbackMethodRefs(method, matchingMethods, ctx, existingVariableNames);
    }

    private static List<LifecycleCallbackMethodReference> toLifecycleCallbackMethodRefs(Method method, List<SelectedMethod<SourceMethod>> candidates, MappingBuilderContext ctx, Set<String> existingVariableNames) {
        ArrayList<LifecycleCallbackMethodReference> result = new ArrayList<LifecycleCallbackMethodReference>();
        for (SelectedMethod<SourceMethod> candidate : candidates) {
            Parameter providingParameter = method.getContextProvidedMethods().getParameterForProvidedMethod(candidate.getMethod());
            if (providingParameter != null) {
                result.add(LifecycleCallbackMethodReference.forParameterProvidedMethod(candidate, providingParameter, method, existingVariableNames));
                continue;
            }
            MapperReference mapperReference = LifecycleCallbackFactory.findMapperReference(ctx.getMapperReferences(), candidate.getMethod());
            result.add(LifecycleCallbackMethodReference.forMethodReference(candidate, mapperReference, method, existingVariableNames));
        }
        return result;
    }

    private static MapperReference findMapperReference(List<MapperReference> mapperReferences, SourceMethod method) {
        for (MapperReference ref : mapperReferences) {
            if (!ref.getType().equals(method.getDeclaringMapper())) continue;
            ref.setUsed(ref.isUsed() || !method.isStatic());
            ref.setTypeRequiresImport(true);
            return ref;
        }
        return null;
    }

    private static List<SourceMethod> filterBeforeMappingMethods(List<SourceMethod> methods) {
        ArrayList<SourceMethod> result = new ArrayList<SourceMethod>();
        for (SourceMethod method : methods) {
            if (!method.isBeforeMappingMethod()) continue;
            result.add(method);
        }
        return result;
    }

    private static List<SourceMethod> filterAfterMappingMethods(List<SourceMethod> methods) {
        ArrayList<SourceMethod> result = new ArrayList<SourceMethod>();
        for (SourceMethod method : methods) {
            if (!method.isAfterMappingMethod()) continue;
            result.add(method);
        }
        return result;
    }
}

