/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.types;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.descriptors.IrBuiltIns;
import org.jetbrains.kotlin.ir.symbols.FqNameEqualityChecker;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrClassifierSymbol;
import org.jetbrains.kotlin.ir.symbols.IrTypeParameterSymbol;
import org.jetbrains.kotlin.ir.types.IrDynamicType;
import org.jetbrains.kotlin.ir.types.IrSimpleType;
import org.jetbrains.kotlin.ir.types.IrStarProjection;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypeArgument;
import org.jetbrains.kotlin.ir.types.IrTypeCheckerContext;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.types.IrTypeProjection;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.types.AbstractTypeChecker;
import org.jetbrains.kotlin.types.model.KotlinTypeMarker;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000*\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\u001a\u0012\u0010\u0004\u001a\u00020\u0002*\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006\u001a\n\u0010\u0007\u001a\u00020\u0001*\u00020\u0002\u001a\u001a\u0010\b\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\t\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006\u001a\u0012\u0010\n\u001a\u00020\u0001*\u00020\u000b2\u0006\u0010\f\u001a\u00020\r\u001a\u0012\u0010\n\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\f\u001a\u00020\r\u001a\u0010\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00020\u000f*\u00020\u000b\u001a\u0012\u0010\u0010\u001a\u00020\u0002*\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006\"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0000\u0010\u0003\u00a8\u0006\u0011"}, d2={"isBoxedArray", "", "Lorg/jetbrains/kotlin/ir/types/IrType;", "(Lorg/jetbrains/kotlin/ir/types/IrType;)Z", "getArrayElementType", "irBuiltIns", "Lorg/jetbrains/kotlin/ir/descriptors/IrBuiltIns;", "isNullable", "isSubtypeOf", "superType", "isSubtypeOfClass", "Lorg/jetbrains/kotlin/ir/symbols/IrClassifierSymbol;", "superClass", "Lorg/jetbrains/kotlin/ir/symbols/IrClassSymbol;", "superTypes", "", "toArrayOrPrimitiveArrayType", "ir.tree"})
public final class IrTypeUtilsKt {
    @NotNull
    public static final List<IrType> superTypes(@NotNull IrClassifierSymbol $this$superTypes) {
        Intrinsics.checkNotNullParameter((Object)$this$superTypes, (String)"<this>");
        IrClassifierSymbol irClassifierSymbol = $this$superTypes;
        return irClassifierSymbol instanceof IrClassSymbol ? ((IrClass)((IrClassSymbol)$this$superTypes).getOwner()).getSuperTypes() : (irClassifierSymbol instanceof IrTypeParameterSymbol ? ((IrTypeParameter)((IrTypeParameterSymbol)$this$superTypes).getOwner()).getSuperTypes() : CollectionsKt.emptyList());
    }

    public static final boolean isSubtypeOfClass(@NotNull IrClassifierSymbol $this$isSubtypeOfClass, @NotNull IrClassSymbol superClass2) {
        boolean bl;
        block4: {
            Intrinsics.checkNotNullParameter((Object)$this$isSubtypeOfClass, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)superClass2, (String)"superClass");
            if (FqNameEqualityChecker.INSTANCE.areEqual($this$isSubtypeOfClass, superClass2)) {
                return true;
            }
            Iterable $this$any$iv = IrTypeUtilsKt.superTypes($this$isSubtypeOfClass);
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    IrType it = (IrType)element$iv;
                    boolean bl2 = false;
                    if (!IrTypeUtilsKt.isSubtypeOfClass(it, superClass2)) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        return bl;
    }

    public static final boolean isSubtypeOfClass(@NotNull IrType $this$isSubtypeOfClass, @NotNull IrClassSymbol superClass2) {
        Intrinsics.checkNotNullParameter((Object)$this$isSubtypeOfClass, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)superClass2, (String)"superClass");
        if (!($this$isSubtypeOfClass instanceof IrSimpleType)) {
            return false;
        }
        return IrTypeUtilsKt.isSubtypeOfClass(((IrSimpleType)$this$isSubtypeOfClass).getClassifier(), superClass2);
    }

    public static final boolean isSubtypeOf(@NotNull IrType $this$isSubtypeOf, @NotNull IrType superType, @NotNull IrBuiltIns irBuiltIns) {
        Intrinsics.checkNotNullParameter((Object)$this$isSubtypeOf, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)superType, (String)"superType");
        Intrinsics.checkNotNullParameter((Object)irBuiltIns, (String)"irBuiltIns");
        return AbstractTypeChecker.isSubtypeOf$default(AbstractTypeChecker.INSTANCE, new IrTypeCheckerContext(irBuiltIns), (KotlinTypeMarker)$this$isSubtypeOf, (KotlinTypeMarker)superType, false, 8, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isNullable(@NotNull IrType $this$isNullable) {
        Intrinsics.checkNotNullParameter((Object)$this$isNullable, (String)"<this>");
        IrType irType = $this$isNullable;
        if (irType instanceof IrSimpleType) {
            IrClassifierSymbol classifier2 = ((IrSimpleType)$this$isNullable).getClassifier();
            if (!(classifier2 instanceof IrClassSymbol)) {
                if (classifier2 instanceof IrTypeParameterSymbol) {
                    IrType p0;
                    if (((IrSimpleType)$this$isNullable).getHasQuestionMark()) return true;
                    Iterable $this$any$iv = ((IrTypeParameter)((IrTypeParameterSymbol)classifier2).getOwner()).getSuperTypes();
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        return false;
                    }
                    Iterator iterator2 = $this$any$iv.iterator();
                    do {
                        if (!iterator2.hasNext()) return false;
                        Object element$iv = iterator2.next();
                        p0 = (IrType)element$iv;
                        boolean bl = false;
                    } while (!IrTypeUtilsKt.isNullable(p0));
                    return true;
                }
                String string2 = Intrinsics.stringPlus((String)"Unsupported classifier: ", (Object)classifier2);
                boolean bl = false;
                throw (Throwable)new IllegalStateException(string2.toString());
            }
        } else {
            if (!(irType instanceof IrDynamicType)) return false;
            return true;
        }
        boolean bl = ((IrSimpleType)$this$isNullable).getHasQuestionMark();
        return bl;
    }

    public static final boolean isBoxedArray(@NotNull IrType $this$isBoxedArray) {
        IrClass irClass2;
        Intrinsics.checkNotNullParameter((Object)$this$isBoxedArray, (String)"<this>");
        IrClassSymbol irClassSymbol = IrTypesKt.getClassOrNull($this$isBoxedArray);
        return Intrinsics.areEqual(irClassSymbol == null ? null : ((irClass2 = (IrClass)irClassSymbol.getOwner()) == null ? null : IrUtilsKt.getFqNameWhenAvailable(irClass2)), (Object)StandardNames.FqNames.array.toSafe());
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static final IrType getArrayElementType(@NotNull IrType $this$getArrayElementType, @NotNull IrBuiltIns irBuiltIns) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)$this$getArrayElementType, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)irBuiltIns, (String)"irBuiltIns");
        if (IrTypeUtilsKt.isBoxedArray($this$getArrayElementType)) {
            IrTypeArgument argument2 = (IrTypeArgument)CollectionsKt.singleOrNull(((IrSimpleType)$this$getArrayElementType).getArguments());
            if (argument2 instanceof IrTypeProjection) {
                object = ((IrTypeProjection)argument2).getType();
                return object;
            }
            if (argument2 instanceof IrStarProjection) {
                object = irBuiltIns.getAnyNType();
                return object;
            }
            String string2 = Intrinsics.stringPlus((String)"Unexpected array argument type: ", (Object)argument2);
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string2.toString());
        }
        Object object2 = IrTypesKt.getClassOrNull($this$getArrayElementType);
        Intrinsics.checkNotNull((Object)object2);
        IrClassSymbol classifier2 = object2;
        object2 = irBuiltIns.getPrimitiveArrayElementTypes().get(classifier2);
        if (object2 == null) {
            throw new AssertionError((Object)Intrinsics.stringPlus((String)"Primitive array expected: ", (Object)classifier2));
        }
        object = object2;
        return object;
    }

    @NotNull
    public static final IrType toArrayOrPrimitiveArrayType(@NotNull IrType $this$toArrayOrPrimitiveArrayType, @NotNull IrBuiltIns irBuiltIns) {
        IrType irType;
        Intrinsics.checkNotNullParameter((Object)$this$toArrayOrPrimitiveArrayType, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)irBuiltIns, (String)"irBuiltIns");
        if (IrTypePredicatesKt.isPrimitiveType$default($this$toArrayOrPrimitiveArrayType, false, 1, null)) {
            IrType irType2;
            IrClassSymbol irClassSymbol = irBuiltIns.getPrimitiveArrayForType().get($this$toArrayOrPrimitiveArrayType);
            IrType irType3 = irType2 = irClassSymbol == null ? null : IrTypesKt.getDefaultType(irClassSymbol);
            if (irType2 == null) {
                throw new AssertionError((Object)($this$toArrayOrPrimitiveArrayType + " not in primitiveArrayForType"));
            }
            irType = irType2;
        } else {
            IrType[] irTypeArray = new IrType[]{$this$toArrayOrPrimitiveArrayType};
            irType = IrTypesKt.typeWith((IrClassifierSymbol)irBuiltIns.getArrayClass(), irTypeArray);
        }
        return irType;
    }
}

