/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil;

public final class SafeMath {
    public static byte safeIntToByte(int value2) {
        if (value2 < -128 || 127 < value2) {
            throw new IllegalArgumentException(value2 + " can't be represented as byte (out of range)");
        }
        return (byte)value2;
    }

    public static short safeIntToShort(int value2) {
        if (value2 < Short.MIN_VALUE || Short.MAX_VALUE < value2) {
            throw new IllegalArgumentException(value2 + " can't be represented as short (out of range)");
        }
        return (short)value2;
    }

    public static float safeDoubleToFloat(double value2) {
        if (Double.isNaN(value2)) {
            return Float.NaN;
        }
        if (Double.isInfinite(value2)) {
            return value2 < 0.0 ? Float.NEGATIVE_INFINITY : Float.POSITIVE_INFINITY;
        }
        if (value2 < (double)1.4E-45f || 3.4028234663852886E38 < value2) {
            throw new IllegalArgumentException(value2 + " can't be represented as float (out of range)");
        }
        float floatValue = (float)value2;
        if ((double)floatValue != value2) {
            throw new IllegalArgumentException(value2 + " can't be represented as float (imprecise)");
        }
        return floatValue;
    }
}

