/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.resolver.impl.maven;

import java.io.File;
import org.jboss.shrinkwrap.resolver.api.InvalidConfigurationFileException;
import org.jboss.shrinkwrap.resolver.api.maven.MavenFormatStage;
import org.jboss.shrinkwrap.resolver.api.maven.MavenStrategyStageBase;
import org.jboss.shrinkwrap.resolver.api.maven.PomEquippedResolveStageBase;
import org.jboss.shrinkwrap.resolver.api.maven.PomlessResolveStageBase;
import org.jboss.shrinkwrap.resolver.impl.maven.MavenWorkingSession;
import org.jboss.shrinkwrap.resolver.impl.maven.ResolveStageBaseImpl;
import org.jboss.shrinkwrap.resolver.impl.maven.SecurityActions;
import org.jboss.shrinkwrap.resolver.impl.maven.task.LoadPomMetadataTask;
import org.jboss.shrinkwrap.resolver.impl.maven.util.FileUtil;
import org.jboss.shrinkwrap.resolver.impl.maven.util.Validate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PomlessResolveStageBaseImpl<EQUIPPEDRESOLVESTAGETYPE extends PomEquippedResolveStageBase<EQUIPPEDRESOLVESTAGETYPE, STRATEGYSTAGETYPE, FORMATSTAGETYPE>, UNEQUIPPEDRESOLVESTAGETYPE extends PomlessResolveStageBase<EQUIPPEDRESOLVESTAGETYPE, UNEQUIPPEDRESOLVESTAGETYPE, STRATEGYSTAGETYPE, FORMATSTAGETYPE>, STRATEGYSTAGETYPE extends MavenStrategyStageBase<STRATEGYSTAGETYPE, FORMATSTAGETYPE>, FORMATSTAGETYPE extends MavenFormatStage>
extends ResolveStageBaseImpl<UNEQUIPPEDRESOLVESTAGETYPE, STRATEGYSTAGETYPE, FORMATSTAGETYPE>
implements PomlessResolveStageBase<EQUIPPEDRESOLVESTAGETYPE, UNEQUIPPEDRESOLVESTAGETYPE, STRATEGYSTAGETYPE, FORMATSTAGETYPE> {
    private static final String[] EMPTY_ARRAY = new String[0];

    public PomlessResolveStageBaseImpl(MavenWorkingSession session) {
        super(session);
    }

    public final EQUIPPEDRESOLVESTAGETYPE loadPomFromFile(File pomFile, String ... profiles) throws IllegalArgumentException {
        Validate.notNull(pomFile, "Path to pom.xml file must not be null");
        Validate.isReadable(pomFile, "Path to the POM ('" + pomFile + "') file must be defined and accessible");
        MavenWorkingSession session = this.getMavenWorkingSession();
        new LoadPomMetadataTask(pomFile, profiles).execute(session);
        return this.createNewPomEquippedResolveStage();
    }

    public final EQUIPPEDRESOLVESTAGETYPE loadPomFromFile(String pathToPomFile, String ... profiles) throws IllegalArgumentException {
        if (pathToPomFile == null || pathToPomFile.length() == 0) {
            throw new IllegalArgumentException("path to POM file must be specified");
        }
        MavenWorkingSession session = this.getMavenWorkingSession();
        new LoadPomMetadataTask(pathToPomFile, profiles).execute(session);
        return this.createNewPomEquippedResolveStage();
    }

    public final EQUIPPEDRESOLVESTAGETYPE loadPomFromFile(File pomFile) throws IllegalArgumentException, InvalidConfigurationFileException {
        return this.loadPomFromFile(pomFile, EMPTY_ARRAY);
    }

    public final EQUIPPEDRESOLVESTAGETYPE loadPomFromFile(String pathToPomFile) throws IllegalArgumentException, InvalidConfigurationFileException {
        return this.loadPomFromFile(pathToPomFile, EMPTY_ARRAY);
    }

    public final EQUIPPEDRESOLVESTAGETYPE loadPomFromClassLoaderResource(String pathToPomResource) throws IllegalArgumentException, InvalidConfigurationFileException {
        return this.loadPomFromClassLoaderResource(pathToPomResource, SecurityActions.getThreadContextClassLoader());
    }

    public final EQUIPPEDRESOLVESTAGETYPE loadPomFromClassLoaderResource(String pathToPomResource, ClassLoader cl) throws IllegalArgumentException, InvalidConfigurationFileException {
        return this.loadPomFromClassLoaderResource(pathToPomResource, SecurityActions.getThreadContextClassLoader(), EMPTY_ARRAY);
    }

    public final EQUIPPEDRESOLVESTAGETYPE loadPomFromClassLoaderResource(String pathToPomResource, ClassLoader cl, String ... profiles) throws IllegalArgumentException, InvalidConfigurationFileException {
        Validate.notNullOrEmpty(pathToPomResource, "path to CL resource must be specified");
        Validate.notNull(cl, "ClassLoader must be specified");
        File file = FileUtil.INSTANCE.fileFromClassLoaderResource(pathToPomResource, cl);
        return this.loadPomFromFile(file);
    }

    protected abstract EQUIPPEDRESOLVESTAGETYPE createNewPomEquippedResolveStage();
}

