/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.narayana.jta.jms;

import com.arjuna.ats.jta.logging.jtaLogger;
import java.io.Serializable;
import javax.jms.BytesMessage;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.QueueBrowser;
import javax.jms.Session;
import javax.jms.StreamMessage;
import javax.jms.TemporaryQueue;
import javax.jms.TemporaryTopic;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.jms.TopicSubscriber;
import javax.jms.XASession;
import org.jboss.narayana.jta.jms.SessionClosingSynchronization;
import org.jboss.narayana.jta.jms.TransactionHelper;

public class SessionProxy
implements Session {
    private final XASession xaSession;
    private final TransactionHelper transactionHelper;
    private boolean sessionCloseScheduled;

    public SessionProxy(XASession xaSession, TransactionHelper transactionHelper) {
        this.xaSession = xaSession;
        this.transactionHelper = transactionHelper;
    }

    public void close() throws JMSException {
        if (this.sessionCloseScheduled) {
            throw new JMSException("Session is already scheduled to be closed");
        }
        if (this.transactionHelper.isTransactionAvailable()) {
            this.sessionCloseScheduled = true;
            this.transactionHelper.deregisterXAResource(this.xaSession.getXAResource());
            if (jtaLogger.logger.isTraceEnabled()) {
                jtaLogger.logger.trace((Object)("Delisted " + this.xaSession + " XA resource from the transaction"));
            }
            SessionClosingSynchronization synchronization = new SessionClosingSynchronization((AutoCloseable)this.xaSession);
            this.transactionHelper.registerSynchronization(synchronization);
            if (jtaLogger.logger.isTraceEnabled()) {
                jtaLogger.logger.trace((Object)("Registered synchronization to close the session: " + synchronization));
            }
        } else {
            this.xaSession.close();
        }
    }

    public BytesMessage createBytesMessage() throws JMSException {
        if (this.sessionCloseScheduled) {
            throw new JMSException("Session is already scheduled to be closed");
        }
        return this.xaSession.createBytesMessage();
    }

    public MapMessage createMapMessage() throws JMSException {
        if (this.sessionCloseScheduled) {
            throw new JMSException("Session is already scheduled to be closed");
        }
        return this.xaSession.createMapMessage();
    }

    public Message createMessage() throws JMSException {
        if (this.sessionCloseScheduled) {
            throw new JMSException("Session is already scheduled to be closed");
        }
        return this.xaSession.createMessage();
    }

    public ObjectMessage createObjectMessage() throws JMSException {
        if (this.sessionCloseScheduled) {
            throw new JMSException("Session is already scheduled to be closed");
        }
        return this.xaSession.createObjectMessage();
    }

    public ObjectMessage createObjectMessage(Serializable serializable) throws JMSException {
        if (this.sessionCloseScheduled) {
            throw new JMSException("Session is already scheduled to be closed");
        }
        return this.xaSession.createObjectMessage(serializable);
    }

    public StreamMessage createStreamMessage() throws JMSException {
        if (this.sessionCloseScheduled) {
            throw new JMSException("Session is already scheduled to be closed");
        }
        return this.xaSession.createStreamMessage();
    }

    public TextMessage createTextMessage() throws JMSException {
        if (this.sessionCloseScheduled) {
            throw new JMSException("Session is already scheduled to be closed");
        }
        return this.xaSession.createTextMessage();
    }

    public TextMessage createTextMessage(String s) throws JMSException {
        if (this.sessionCloseScheduled) {
            throw new JMSException("Session is already scheduled to be closed");
        }
        return this.xaSession.createTextMessage(s);
    }

    public boolean getTransacted() throws JMSException {
        if (this.sessionCloseScheduled) {
            throw new JMSException("Session is already scheduled to be closed");
        }
        return this.xaSession.getTransacted();
    }

    public int getAcknowledgeMode() throws JMSException {
        if (this.sessionCloseScheduled) {
            throw new JMSException("Session is already scheduled to be closed");
        }
        return this.xaSession.getAcknowledgeMode();
    }

    public void commit() throws JMSException {
        if (this.sessionCloseScheduled) {
            throw new JMSException("Session is already scheduled to be closed");
        }
        this.xaSession.commit();
    }

    public void rollback() throws JMSException {
        if (this.sessionCloseScheduled) {
            throw new JMSException("Session is already scheduled to be closed");
        }
        this.xaSession.rollback();
    }

    public void recover() throws JMSException {
        if (this.sessionCloseScheduled) {
            throw new JMSException("Session is already scheduled to be closed");
        }
        this.xaSession.recover();
    }

    public MessageListener getMessageListener() throws JMSException {
        if (this.sessionCloseScheduled) {
            throw new JMSException("Session is already scheduled to be closed");
        }
        return this.xaSession.getMessageListener();
    }

    public void setMessageListener(MessageListener messageListener) throws JMSException {
        if (this.sessionCloseScheduled) {
            throw new JMSException("Session is already scheduled to be closed");
        }
        this.xaSession.setMessageListener(messageListener);
    }

    public void run() {
        if (this.sessionCloseScheduled) {
            throw new RuntimeException("Session is already scheduled to be closed");
        }
        this.xaSession.run();
    }

    public MessageProducer createProducer(Destination destination) throws JMSException {
        if (this.sessionCloseScheduled) {
            throw new JMSException("Session is already scheduled to be closed");
        }
        return this.xaSession.createProducer(destination);
    }

    public MessageConsumer createConsumer(Destination destination) throws JMSException {
        if (this.sessionCloseScheduled) {
            throw new JMSException("Session is already scheduled to be closed");
        }
        return this.xaSession.createConsumer(destination);
    }

    public MessageConsumer createConsumer(Destination destination, String s) throws JMSException {
        if (this.sessionCloseScheduled) {
            throw new JMSException("Session is already scheduled to be closed");
        }
        return this.xaSession.createConsumer(destination, s);
    }

    public MessageConsumer createConsumer(Destination destination, String s, boolean b) throws JMSException {
        if (this.sessionCloseScheduled) {
            throw new JMSException("Session is already scheduled to be closed");
        }
        return this.xaSession.createConsumer(destination, s, b);
    }

    public MessageConsumer createSharedConsumer(Topic topic, String sharedSubscriptionName) throws JMSException {
        if (this.sessionCloseScheduled) {
            throw new JMSException("Session is already scheduled to be closed");
        }
        return this.xaSession.createSharedConsumer(topic, sharedSubscriptionName);
    }

    public MessageConsumer createSharedConsumer(Topic topic, String sharedSubscriptionName, String messageSelector) throws JMSException {
        if (this.sessionCloseScheduled) {
            throw new JMSException("Session is already scheduled to be closed");
        }
        return this.xaSession.createSharedConsumer(topic, sharedSubscriptionName, messageSelector);
    }

    public Queue createQueue(String s) throws JMSException {
        if (this.sessionCloseScheduled) {
            throw new JMSException("Session is already scheduled to be closed");
        }
        return this.xaSession.createQueue(s);
    }

    public Topic createTopic(String s) throws JMSException {
        if (this.sessionCloseScheduled) {
            throw new JMSException("Session is already scheduled to be closed");
        }
        return this.xaSession.createTopic(s);
    }

    public TopicSubscriber createDurableSubscriber(Topic topic, String s) throws JMSException {
        if (this.sessionCloseScheduled) {
            throw new JMSException("Session is already scheduled to be closed");
        }
        return this.xaSession.createDurableSubscriber(topic, s);
    }

    public TopicSubscriber createDurableSubscriber(Topic topic, String s, String s1, boolean b) throws JMSException {
        if (this.sessionCloseScheduled) {
            throw new JMSException("Session is already scheduled to be closed");
        }
        return this.xaSession.createDurableSubscriber(topic, s, s1, b);
    }

    public MessageConsumer createDurableConsumer(Topic topic, String name) throws JMSException {
        if (this.sessionCloseScheduled) {
            throw new JMSException("Session is already scheduled to be closed");
        }
        return this.xaSession.createDurableConsumer(topic, name);
    }

    public MessageConsumer createDurableConsumer(Topic topic, String name, String messageSelector, boolean noLocal) throws JMSException {
        if (this.sessionCloseScheduled) {
            throw new JMSException("Session is already scheduled to be closed");
        }
        return this.xaSession.createDurableConsumer(topic, name, messageSelector, noLocal);
    }

    public MessageConsumer createSharedDurableConsumer(Topic topic, String name) throws JMSException {
        if (this.sessionCloseScheduled) {
            throw new JMSException("Session is already scheduled to be closed");
        }
        return this.createSharedDurableConsumer(topic, name);
    }

    public MessageConsumer createSharedDurableConsumer(Topic topic, String name, String messageSelector) throws JMSException {
        if (this.sessionCloseScheduled) {
            throw new JMSException("Session is already scheduled to be closed");
        }
        return this.createSharedDurableConsumer(topic, name, messageSelector);
    }

    public QueueBrowser createBrowser(Queue queue) throws JMSException {
        if (this.sessionCloseScheduled) {
            throw new JMSException("Session is already scheduled to be closed");
        }
        return this.xaSession.createBrowser(queue);
    }

    public QueueBrowser createBrowser(Queue queue, String s) throws JMSException {
        if (this.sessionCloseScheduled) {
            throw new JMSException("Session is already scheduled to be closed");
        }
        return this.xaSession.createBrowser(queue, s);
    }

    public TemporaryQueue createTemporaryQueue() throws JMSException {
        if (this.sessionCloseScheduled) {
            throw new JMSException("Session is already scheduled to be closed");
        }
        return this.xaSession.createTemporaryQueue();
    }

    public TemporaryTopic createTemporaryTopic() throws JMSException {
        if (this.sessionCloseScheduled) {
            throw new JMSException("Session is already scheduled to be closed");
        }
        return this.xaSession.createTemporaryTopic();
    }

    public void unsubscribe(String s) throws JMSException {
        if (this.sessionCloseScheduled) {
            throw new JMSException("Session is already scheduled to be closed");
        }
        this.xaSession.unsubscribe(s);
    }
}

