/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.kernel.plugins.dependency;

import java.util.Collection;
import java.util.Set;
import org.jboss.dependency.plugins.OwnerCallbackItem;
import org.jboss.dependency.spi.Cardinality;
import org.jboss.dependency.spi.Controller;
import org.jboss.dependency.spi.ControllerContext;
import org.jboss.dependency.spi.ControllerState;
import org.jboss.dependency.spi.DependencyItem;
import org.jboss.dependency.spi.dispatch.InvokeDispatchContext;
import org.jboss.kernel.plugins.dependency.AttributeInfo;
import org.jboss.kernel.plugins.dependency.CallbackDependencyItem;
import org.jboss.kernel.spi.dependency.KernelController;
import org.jboss.kernel.spi.dependency.KernelControllerContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CollectionCallbackItem<T extends Collection<Object>>
extends OwnerCallbackItem<Class<?>, InvokeDispatchContext> {
    protected Cardinality cardinality;
    protected AttributeInfo attribute;

    public CollectionCallbackItem(Class<?> name, InvokeDispatchContext owner, AttributeInfo attribute) {
        this(name, null, null, null, owner, attribute);
    }

    public CollectionCallbackItem(Class<?> name, ControllerState whenRequired, ControllerState dependentState, Cardinality cardinality, InvokeDispatchContext context, AttributeInfo attribute) {
        super(name, whenRequired, dependentState, attribute != null ? attribute.getName() : null, (Object)context);
        this.attribute = attribute;
        this.cardinality = cardinality;
    }

    protected abstract T getCollectionParameterHolder();

    protected T fillHolder(Controller controller) throws Throwable {
        if (controller instanceof KernelController) {
            T holder = this.getCollectionParameterHolder();
            if (holder == null) {
                throw new IllegalArgumentException("Illegal collection holder, equals null!");
            }
            KernelController kernelController = (KernelController)controller;
            Set<KernelControllerContext> contexts = kernelController.getContexts((Class)this.getIDependOn(), this.dependentState);
            if (contexts != null && !contexts.isEmpty()) {
                for (KernelControllerContext context : contexts) {
                    holder.add((Object)context.getTarget());
                }
            }
            return holder;
        }
        throw new IllegalArgumentException("Cannot execute Collection call back - controller not KernelController instance.");
    }

    protected void execute(T holder) throws Throwable {
        if (this.attribute.isProperty()) {
            ((InvokeDispatchContext)this.owner).set(this.getAttributeName(), holder);
        } else {
            ((InvokeDispatchContext)this.owner).invoke(this.getAttributeName(), new Object[]{holder}, new String[]{this.attribute.getType().getName()});
        }
    }

    protected DependencyItem createDependencyItem(ControllerContext owner) {
        if (this.cardinality != null) {
            return new CallbackDependencyItem(owner.getName(), (Class)this.getIDependOn(), this.whenRequired, this.dependentState, this.cardinality);
        }
        return null;
    }

    public void ownerCallback(Controller controller, boolean isInstallPhase) throws Throwable {
        T holder = isInstallPhase ? this.fillHolder(controller) : this.getCollectionParameterHolder();
        this.execute(holder);
    }

    public void changeCallback(Controller controller, ControllerContext context, boolean isInstallPhase) throws Throwable {
        T holder = this.fillHolder(controller);
        if (!isInstallPhase) {
            this.removeUninstallingContext(holder, context);
        }
        this.execute(holder);
        this.addDependency(controller, context, isInstallPhase);
    }

    protected void removeUninstallingContext(T holder, ControllerContext context) {
        holder.remove(context.getTarget());
    }
}

