/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.metadata.parser.util;

import java.io.ByteArrayInputStream;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NavigableMap;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLResolver;
import javax.xml.stream.XMLStreamConstants;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.metadata.property.PropertyReplacer;

public class MetaDataElementParser
implements XMLStreamConstants {
    private static final Comparator<Object> NATURAL = new Comparator<Object>(){

        @Override
        public int compare(Object o1, Object o2) {
            return ((Comparable)o1).compareTo(o2);
        }
    };

    protected static XMLStreamException unexpectedValue(XMLStreamReader reader, Throwable t) {
        return new XMLStreamException("Unexpected value '" + reader.getName() + "' encountered", reader.getLocation(), t);
    }

    protected static XMLStreamException unexpectedElement(XMLStreamReader reader) {
        return new XMLStreamException("Unexpected element '" + reader.getName() + "' encountered", reader.getLocation());
    }

    public static XMLStreamException unexpectedAttribute(XMLStreamReader reader, int index) {
        return new XMLStreamException("Unexpected attribute '" + reader.getAttributeName(index) + "' encountered", reader.getLocation());
    }

    protected static XMLStreamException missingRequiredAttributes(XMLStreamReader reader, Set<?> required) {
        StringBuilder b = new StringBuilder();
        Iterator<?> iterator = required.iterator();
        while (iterator.hasNext()) {
            Object o = iterator.next();
            b.append(o.toString());
            if (!iterator.hasNext()) continue;
            b.append(", ");
        }
        return new XMLStreamException("Missing required attribute(s): " + b, reader.getLocation());
    }

    protected static XMLStreamException missingRequiredElement(XMLStreamReader reader, Set<?> required) {
        StringBuilder b = new StringBuilder();
        Iterator<?> iterator = required.iterator();
        while (iterator.hasNext()) {
            Object o = iterator.next();
            b.append(o.toString());
            if (!iterator.hasNext()) continue;
            b.append(", ");
        }
        return new XMLStreamException("Missing required element(s): " + b, reader.getLocation());
    }

    protected static void requireNoAttributes(XMLStreamReader reader) throws XMLStreamException {
        if (reader.getAttributeCount() > 0) {
            throw MetaDataElementParser.unexpectedAttribute(reader, 0);
        }
    }

    protected static String getElementText(XMLStreamReader reader) throws XMLStreamException {
        return MetaDataElementParser.getElementText(reader, true);
    }

    protected static String getElementText(XMLStreamReader reader, PropertyReplacer propertyReplacer) throws XMLStreamException {
        return propertyReplacer.replaceProperties(MetaDataElementParser.getElementText(reader));
    }

    protected static String getElementText(XMLStreamReader reader, boolean trim, PropertyReplacer propertyReplacer) throws XMLStreamException {
        return propertyReplacer.replaceProperties(MetaDataElementParser.getElementText(reader, trim));
    }

    protected static String getElementText(XMLStreamReader reader, boolean trim) throws XMLStreamException {
        if (trim) {
            return reader.getElementText().trim();
        }
        return reader.getElementText();
    }

    protected static void requireNoContent(XMLStreamReader reader) throws XMLStreamException {
        if (reader.hasNext() && reader.nextTag() != 2) {
            throw MetaDataElementParser.unexpectedElement(reader);
        }
    }

    protected static XMLStreamException duplicateNamedElement(XMLStreamReader reader, String name) {
        return new XMLStreamException("An element of this type named '" + name + "' has already been declared", reader.getLocation());
    }

    protected static boolean readBooleanAttributeElement(XMLStreamReader reader, String attributeName) throws XMLStreamException {
        MetaDataElementParser.requireSingleAttribute(reader, attributeName);
        boolean value = Boolean.parseBoolean(reader.getAttributeValue(0));
        MetaDataElementParser.requireNoContent(reader);
        return value;
    }

    protected static String readStringAttributeElement(XMLStreamReader reader, String attributeName) throws XMLStreamException {
        MetaDataElementParser.requireSingleAttribute(reader, attributeName);
        String value = reader.getAttributeValue(0);
        MetaDataElementParser.requireNoContent(reader);
        return value;
    }

    private static void requireSingleAttribute(XMLStreamReader reader, String attributeName) throws XMLStreamException {
        int count = reader.getAttributeCount();
        if (count == 0) {
            throw MetaDataElementParser.missingRequiredAttributes(reader, Collections.singleton(attributeName));
        }
        if (MetaDataElementParser.attributeHasNamespace(reader, 0) || !attributeName.equals(reader.getAttributeLocalName(0))) {
            throw MetaDataElementParser.unexpectedAttribute(reader, 0);
        }
        if (count > 1) {
            throw MetaDataElementParser.unexpectedAttribute(reader, 1);
        }
    }

    protected static String readSchemaLocation(XMLStreamReader reader) throws XMLStreamException {
        int pos;
        int count = reader.getAttributeCount();
        if (count == 0) {
            return null;
        }
        String loc = null;
        for (int i = 0; i < count; ++i) {
            if (!"http://www.w3.org/2001/XMLSchema-instance".equals(reader.getAttributeNamespace(i)) || !"schemaLocation".equals(reader.getAttributeLocalName(i))) continue;
            loc = reader.getAttributeValue(i);
            break;
        }
        if (loc != null && (pos = loc.indexOf(32)) > 0) {
            loc = loc.substring(pos + 1);
        }
        return loc != null ? loc.trim() : null;
    }

    protected static String readDTDLocation(XMLStreamReader reader) throws XMLStreamException {
        int begin;
        if (reader.getEventType() != 11) {
            return null;
        }
        String loc = reader.getText();
        if (loc == null || loc.isEmpty()) {
            return null;
        }
        int end = loc.lastIndexOf(34);
        if (end > 0 && (begin = loc.lastIndexOf(34, end - 1)) > 0) {
            loc = loc.substring(begin + 1, end).trim();
        }
        return loc;
    }

    protected static QName parseQName(XMLStreamReader reader, String qname) {
        boolean canonicalForm;
        boolean bl = canonicalForm = qname.charAt(0) == '{';
        if (canonicalForm) {
            return QName.valueOf(qname);
        }
        int end = qname.indexOf(58);
        if (end > 0 && end < qname.length()) {
            String ns = qname.substring(0, end);
            String local = qname.substring(end + 1);
            return new QName(reader.getNamespaceURI(ns), local);
        }
        return QName.valueOf(qname);
    }

    protected static boolean attributeHasNamespace(XMLStreamReader reader, int i) {
        String namespace = reader.getAttributeNamespace(i);
        return namespace != null && !"".equals(namespace);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static <K, V> NavigableMap<K, V> safeCopyMap(NavigableMap<K, V> toCopy) {
        NavigableMap<K, V> navigableMap = toCopy;
        synchronized (navigableMap) {
            return new TreeMap<K, V>(toCopy);
        }
    }

    protected static void consumeElementContent(XMLStreamReader reader) throws XMLStreamException {
        block4: while (reader.hasNext()) {
            switch (reader.next()) {
                case 2: {
                    return;
                }
                case 1: {
                    MetaDataElementParser.consumeElementContent(reader);
                    continue block4;
                }
            }
        }
    }

    private static <T> Comparator<? super T> comparatorOf(SortedMap<T, ?> map) {
        Comparator<T> comparator = map.comparator();
        if (comparator != null) {
            return comparator;
        }
        return NATURAL;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj);
    }

    public final int hashCode() {
        return super.hashCode();
    }

    public static class DTDInfo
    implements XMLResolver {
        private String publicID;
        private String systemID;
        private String baseURI;
        private String namespace;

        @Override
        public Object resolveEntity(String publicID, String systemID, String baseURI, String namespace) throws XMLStreamException {
            this.publicID = publicID;
            this.systemID = systemID;
            this.baseURI = baseURI;
            this.namespace = namespace;
            return new ByteArrayInputStream(new byte[0]);
        }

        public String getPublicID() {
            return this.publicID;
        }

        public String getSystemID() {
            return this.systemID;
        }

        public String getBaseURI() {
            return this.baseURI;
        }

        public String getNamespace() {
            return this.namespace;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder(this.getClass().getSimpleName());
            builder.append("{");
            builder.append("publicID=").append(this.publicID).append(", ");
            builder.append("systemID=").append(this.systemID).append(", ");
            builder.append("baseURI=").append(this.baseURI).append(", ");
            builder.append("namespace=").append(this.namespace);
            builder.append("}");
            return builder.toString();
        }
    }
}

