/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logmanager;

import java.io.IOException;
import java.io.Writer;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class LoggingWriter
extends Writer {
    private final Logger log;
    private final Level level;
    private final StringBuilder buffer = new StringBuilder();

    public LoggingWriter(String category, Level level) {
        this.level = level;
        this.log = Logger.getLogger(category);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(int c) throws IOException {
        StringBuilder stringBuilder = this.buffer;
        synchronized (stringBuilder) {
            if (c == 10) {
                this.log.log(this.level, this.buffer.toString());
                this.buffer.setLength(0);
            } else {
                this.buffer.append((char)c);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(char[] cbuf, int off, int len) throws IOException {
        StringBuilder stringBuilder = this.buffer;
        synchronized (stringBuilder) {
            int i;
            int mark = 0;
            for (i = 0; i < len; ++i) {
                char c = cbuf[off + i];
                if (c != '\n') continue;
                this.buffer.append(cbuf, mark + off, i - mark);
                this.log.log(this.level, this.buffer.toString());
                this.buffer.setLength(0);
                mark = i + 1;
            }
            this.buffer.append(cbuf, mark + off, i - mark);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() throws IOException {
        StringBuilder stringBuilder = this.buffer;
        synchronized (stringBuilder) {
            if (this.buffer.length() > 0) {
                this.buffer.append(" >>> FLUSH");
                this.log.log(this.level, this.buffer.toString());
                this.buffer.setLength(0);
            }
        }
    }

    public void close() throws IOException {
    }
}

