/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logging.validation.validator;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import org.jboss.logging.Message;
import org.jboss.logging.validation.ElementValidator;
import org.jboss.logging.validation.ValidationErrorMessage;

public class MessageAnnotationValidator
implements ElementValidator {
    private static final Class<? extends Annotation> annotationClass = Message.class;
    private static final String ERROR_MESSAGE = "Only one method with the same name is allowed to be annotated the %s annotation.";

    @Override
    public Collection<ValidationErrorMessage> validate(TypeElement element, Collection<ExecutableElement> elementMethods) {
        ArrayList<ValidationErrorMessage> errorMessages = new ArrayList<ValidationErrorMessage>();
        HashSet<Name> methodNames = new HashSet<Name>();
        for (ExecutableElement method : elementMethods) {
            if (!methodNames.add(method.getSimpleName())) continue;
            Collection<ExecutableElement> likeMethods = this.findByName(elementMethods, method.getSimpleName());
            boolean foundFirst = false;
            for (ExecutableElement m : likeMethods) {
                boolean found;
                boolean bl = found = m.getAnnotation(annotationClass) != null;
                if (foundFirst && found) {
                    errorMessages.add(new ValidationErrorMessage(m, String.format(ERROR_MESSAGE, annotationClass.getName())));
                }
                foundFirst = found;
            }
        }
        return errorMessages;
    }

    private Collection<ExecutableElement> findByName(Collection<ExecutableElement> methods, Name methodName) {
        ArrayList<ExecutableElement> result = new ArrayList<ExecutableElement>();
        for (ExecutableElement method : methods) {
            if (!((Object)methodName).equals(method.getSimpleName())) continue;
            result.add(method);
        }
        return result;
    }
}

