/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.system.server.profileservice.repository.clustered;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.jboss.logging.Logger;
import org.jboss.profileservice.spi.ModificationInfo;
import org.jboss.profileservice.spi.ProfileDeployment;
import org.jboss.profileservice.spi.ProfileKey;
import org.jboss.system.server.profileservice.repository.HotDeploymentRepository;
import org.jboss.system.server.profileservice.repository.clustered.RepositoryClusteringHandler;
import org.jboss.system.server.profileservice.repository.clustered.local.LocalContentManager;
import org.jboss.system.server.profileservice.repository.clustered.local.LocalContentManagerFactory;
import org.jboss.system.server.profileservice.repository.clustered.metadata.RepositoryContentMetadata;
import org.jboss.system.server.profileservice.repository.clustered.metadata.RepositoryItemMetadata;
import org.jboss.system.server.profileservice.repository.clustered.metadata.RepositoryRootMetadata;
import org.jboss.virtual.VFS;
import org.jboss.virtual.VirtualFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClusteredDeploymentRepository
extends HotDeploymentRepository {
    private RepositoryClusteringHandler clusteringHandler;
    private final Map<String, URI> namedURIMap;
    private final Map<ProfileKey, RepositoryClusteringHandler> clusteringHandlers;
    private final Set<LocalContentManagerFactory<?>> localContentManagerFactories;
    private LocalContentManager<?> localContentManager;
    private volatile LoadStatus loadStatus = LoadStatus.UNLOADED;
    private boolean created;

    public ClusteredDeploymentRepository(ProfileKey key, URI[] uris, Map<ProfileKey, RepositoryClusteringHandler> clusteringHandlers, Set<LocalContentManagerFactory<?>> persisterFactories) throws IOException {
        super(key, ClusteredDeploymentRepository.validateURIs(uris, key));
        if (clusteringHandlers == null) {
            throw new IllegalArgumentException("Null clusteringHandlers");
        }
        if (persisterFactories == null) {
            throw new IllegalArgumentException("Null persisterFactories");
        }
        this.namedURIMap = this.getNamedURIMap(this.getRepositoryURIs());
        this.clusteringHandlers = clusteringHandlers;
        this.localContentManagerFactories = persisterFactories;
    }

    public String getPartitionName() {
        return this.clusteringHandler == null ? null : this.clusteringHandler.getPartitionName();
    }

    public RepositoryClusteringHandler getClusteringHandler() {
        return this.clusteringHandler;
    }

    public synchronized boolean registerClusteringHandler(RepositoryClusteringHandler handler) {
        if (handler == null) {
            throw new IllegalArgumentException("handler is null");
        }
        boolean update = this.getProfileKey().equals((Object)handler.getProfileKey());
        if (update) {
            this.clusteringHandler = handler;
        }
        return update;
    }

    public synchronized boolean unregisterClusteringHandler(RepositoryClusteringHandler handler) {
        if (handler == null) {
            throw new IllegalArgumentException("handler is null");
        }
        boolean update = this.getProfileKey().equals((Object)handler.getProfileKey());
        if (update) {
            this.clusteringHandler = null;
        }
        return update;
    }

    @Override
    public void create() throws Exception {
        super.create();
        boolean needToFunction = false;
        for (URI uri : this.getRepositoryURIs()) {
            if (!this.getCachedVirtualFile(uri).exists()) continue;
            needToFunction = true;
            break;
        }
        if (needToFunction) {
            this.clusteringHandler = this.clusteringHandlers.get(this.getProfileKey());
            if (this.clusteringHandler == null) {
                throw new IllegalStateException("Must register RepositoryClusteringHandler before calling create()");
            }
            for (LocalContentManagerFactory<?> factory : this.localContentManagerFactories) {
                if (!factory.accepts(this.namedURIMap.values())) continue;
                this.localContentManager = factory.getLocalContentManager(this.namedURIMap, this.getProfileKey(), this.clusteringHandler.getLocalNodeName());
                break;
            }
            if (this.localContentManager == null) {
                throw new IllegalStateException("No registered RepositoryContentPersisterFactory is capable of handling URIs " + this.namedURIMap.values() + " -- registeredFactories are " + this.localContentManagerFactories);
            }
        }
        this.created = true;
    }

    @Override
    public void load() throws Exception {
        if (!this.created) {
            this.create();
        }
        if (this.clusteringHandler == null) {
            return;
        }
        this.clusteringHandler.initialize(this.localContentManager);
        if (!this.clusteringHandler.lockGlobally()) {
            throw new RuntimeException("Cannot acquire global lock");
        }
        try {
            if (this.loadStatus != LoadStatus.UNLOADED) {
                this.log.warn((Object)("load() called when repository status is " + (Object)((Object)this.loadStatus)));
                return;
            }
            this.loadStatus = LoadStatus.LOADING;
            this.clusteringHandler.synchronizeContent(true);
            for (URI uri : this.getRepositoryURIs()) {
                VirtualFile root = this.getCachedVirtualFile(uri);
                this.loadApplications(root);
            }
            this.updateLastModfied();
            this.loadStatus = LoadStatus.LOADED;
        }
        catch (Throwable t) {
            this.loadStatus = LoadStatus.UNLOADED;
            if (t instanceof Exception) {
                throw (Exception)t;
            }
            if (t instanceof Error) {
                throw (Error)t;
            }
            UnknownError unk = new UnknownError("Caught unknown Throwable");
            unk.initCause(t);
            throw unk;
        }
        finally {
            this.clusteringHandler.unlockGlobally();
            if (this.loadStatus != LoadStatus.LOADED) {
                this.clusteringHandler.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String addDeploymentContent(String vfsPath, InputStream contentIS) throws IOException {
        if (this.clusteringHandler == null) {
            throw new IllegalStateException("Must register RepositoryClusteringHandler before invoking addDeploymentContent()");
        }
        String repositoryName = null;
        if (!this.clusteringHandler.lockGlobally()) {
            throw new RuntimeException("Cannot acquire global lock");
        }
        try {
            RepositoryContentMetadata existingRCMD = new RepositoryContentMetadata(this.localContentManager.getOfficialContentMetadata());
            RepositoryItemMetadata newRIMD = this.clusteringHandler.addDeploymentContent(vfsPath, contentIS);
            RepositoryRootMetadata existingRRMD = existingRCMD.getRepositoryRootMetadata(newRIMD.getRootName());
            boolean exists = existingRRMD != null && existingRRMD.getItemMetadata(newRIMD.getRelativePathElements()) != null;
            VirtualFile root = this.getCachedVirtualFile(this.namedURIMap.get(newRIMD.getRootName()));
            VirtualFile contentVF = root.getChild(newRIMD.getRelativePath());
            try {
                repositoryName = this.addVirtualFileCache(contentVF);
                if (exists) {
                    this.cleanUpRoot(contentVF);
                }
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
            this.setDeploymentContentFlags(repositoryName, 4);
        }
        finally {
            this.clusteringHandler.unlockGlobally();
        }
        return repositoryName;
    }

    @Override
    public ProfileDeployment removeDeployment(String vfsPath) throws Exception {
        ProfileDeployment deployment = this.getDeployment(vfsPath);
        VirtualFile root = deployment.getRoot();
        this.clusteringHandler.removeDeploymentContent(root);
        return super.removeDeployment(deployment.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<ModificationInfo> getModifiedDeployments() throws Exception {
        if (this.clusteringHandler == null) {
            return Collections.emptyList();
        }
        if (this.loadStatus != LoadStatus.LOADED) {
            this.log.debug((Object)("Ignoring getModifiedDeployments() call as status is " + (Object)((Object)this.loadStatus)));
        }
        RepositoryContentMetadata baseContent = null;
        RepositoryContentMetadata latestContent = null;
        if (!this.clusteringHandler.lockLocally()) {
            this.log.error((Object)"getModifiedDeployments(): Cannot acquire local lock");
            return Collections.emptySet();
        }
        try {
            baseContent = this.localContentManager.getOfficialContentMetadata();
            latestContent = this.localContentManager.getCurrentContentMetadata();
            boolean unmodified = latestContent.equals(baseContent);
            if (unmodified) {
                Collection<ModificationInfo> collection = super.getModifiedDeployments();
                return collection;
            }
        }
        finally {
            this.clusteringHandler.unlockLocally();
        }
        if (!this.clusteringHandler.lockGlobally()) {
            this.log.error((Object)"getModifiedDeployments(): Cannot acquire global lock");
            return Collections.emptySet();
        }
        try {
            latestContent = this.clusteringHandler.synchronizeContent(false);
            Collection<ModificationInfo> collection = super.getModifiedDeployments();
            return collection;
        }
        finally {
            this.clusteringHandler.unlockGlobally();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unload() {
        if (this.clusteringHandler == null) {
            super.unload();
            return;
        }
        if (this.loadStatus != LoadStatus.UNLOADED) {
            boolean locked = this.clusteringHandler.lockLocally();
            try {
                if (!locked) {
                    this.log.warn((Object)"remove(): failed to acquire local lock");
                }
                this.loadStatus = LoadStatus.UNLOADED;
                super.unload();
            }
            finally {
                if (locked) {
                    this.clusteringHandler.unlockLocally();
                }
                try {
                    this.clusteringHandler.shutdown();
                }
                catch (Exception e) {
                    this.log.error((Object)"Caught exception shutting down RepositoryClusteringHandler", (Throwable)e);
                }
            }
        }
    }

    @Override
    public void remove() throws Exception {
        this.clusteringHandler = null;
        this.localContentManager = null;
        this.created = false;
    }

    private static URI[] validateURIs(URI[] uris, ProfileKey profileKey) {
        ArrayList<URI> list = new ArrayList<URI>();
        for (URI uri : uris) {
            try {
                VFS.getRoot((URI)uri);
                list.add(uri);
            }
            catch (Exception e) {
                Logger slog = Logger.getLogger(ClusteredDeploymentRepository.class);
                slog.error((Object)("Problem accessing URI " + uri + " -- it will not be " + "used for profile " + profileKey + ". Problem was: " + e.getLocalizedMessage()));
            }
        }
        return list.toArray(new URI[list.size()]);
    }

    private Map<String, URI> getNamedURIMap(URI[] uris) throws IOException {
        HashMap<String, URI> map = new HashMap<String, URI>();
        if (uris != null) {
            for (URI uri : uris) {
                VirtualFile vf = this.getCachedVirtualFile(uri);
                map.put(vf.getName(), uri);
            }
        }
        return map;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum LoadStatus {
        UNLOADED,
        LOADING,
        LOADED;

    }
}

