/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployers.vfs.spi.deployer;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.validation.Schema;
import org.jboss.deployers.vfs.spi.deployer.SchemaHelper;
import org.jboss.deployers.vfs.spi.deployer.UnmarshallerFactory;
import org.jboss.deployers.vfs.spi.deployer.UnmarshallerFactoryDeployer;
import org.jboss.deployers.vfs.spi.structure.VFSDeploymentUnit;
import org.jboss.util.xml.JBossEntityResolver;
import org.jboss.vfs.VFSInputSource;
import org.jboss.vfs.VirtualFile;
import org.w3c.dom.Document;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JAXPDeployer<T>
extends UnmarshallerFactoryDeployer<T, Boolean> {
    private boolean useNamespaceAwareParser = true;
    private boolean validateDTDs;
    private DocumentBuilderFactory documentBuilderFactory;
    private String schemaLocation;

    public JAXPDeployer(Class<T> output) {
        super(output);
    }

    public boolean isUseNamespaceAwareParser() {
        return this.useNamespaceAwareParser;
    }

    public void setUseNamespaceAwareParser(boolean useNamespaceAwareParser) {
        this.useNamespaceAwareParser = useNamespaceAwareParser;
    }

    public boolean isValidateDTDs() {
        return this.validateDTDs;
    }

    public void setValidateDTDs(boolean validateDTDs) {
        this.validateDTDs = validateDTDs;
    }

    public void setSchemaLocation(String schemaLocation) {
        this.schemaLocation = schemaLocation;
    }

    protected DocumentBuilderFactory getDocumentBuilderFactory() {
        if (this.documentBuilderFactory == null) {
            throw new IllegalStateException("Document builder factory has not been constructed");
        }
        return this.documentBuilderFactory;
    }

    public void create() throws Exception {
        this.documentBuilderFactory = DocumentBuilderFactory.newInstance();
        this.documentBuilderFactory.setNamespaceAware(this.useNamespaceAwareParser);
        this.documentBuilderFactory.setValidating(this.validateDTDs);
        Schema schema = SchemaHelper.getSchema(this.schemaLocation);
        if (schema != null) {
            this.documentBuilderFactory.setSchema(schema);
        }
    }

    public void destroy() {
        this.documentBuilderFactory = null;
    }

    @Override
    protected UnmarshallerFactory<Boolean> createUnmarshallerFactory() {
        return new UnmarshallerFactory<Boolean>(){

            @Override
            public void setFeature(String featureName, Boolean flag) throws Exception {
                JAXPDeployer.this.getDocumentBuilderFactory().setFeature(featureName, flag);
            }
        };
    }

    @Override
    protected Boolean fromString(String value) {
        return Boolean.valueOf(value);
    }

    @Override
    protected T parse(VFSDeploymentUnit unit, VirtualFile file, T root) throws Exception {
        Document document = (Document)unit.getAttachment(Document.class);
        if (document == null) {
            document = this.doParse(unit, file);
        }
        return this.parse(unit, file, document);
    }

    protected Document doParse(VFSDeploymentUnit unit, VirtualFile file) throws Exception {
        if (file == null) {
            throw new IllegalArgumentException("Null file");
        }
        this.log.debugf("Parsing: %1s", new Object[]{file.getName()});
        VFSInputSource source = new VFSInputSource(file);
        DocumentBuilderFactory factory = this.getDocumentBuilderFactory();
        DocumentBuilder parser = factory.newDocumentBuilder();
        parser.setEntityResolver((EntityResolver)new JBossEntityResolver());
        return parser.parse((InputSource)source);
    }

    @Override
    protected abstract T parse(VFSDeploymentUnit var1, VirtualFile var2, Document var3) throws Exception;
}

