/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployers.vfs.spi.deployer;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.deployer.helpers.AbstractParsingDeployerWithOutput;
import org.jboss.deployers.spi.deployer.matchers.LazyPath;
import org.jboss.deployers.spi.deployer.matchers.NameIgnoreMechanism;
import org.jboss.deployers.spi.structure.MetaDataTypeFilter;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.deployers.vfs.spi.deployer.FileMatcher;
import org.jboss.deployers.vfs.spi.deployer.SecurityActions;
import org.jboss.deployers.vfs.spi.structure.VFSDeploymentUnit;
import org.jboss.vfs.VirtualFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractVFSParsingDeployer<T>
extends AbstractParsingDeployerWithOutput<T>
implements FileMatcher {
    private static final String ALT_MAPPINGS_MAP_KEY = "AltMappingsMap";
    private boolean allowMultipleFiles;
    private MetaDataTypeFilter filter = MetaDataTypeFilter.DEFAULT;

    public AbstractVFSParsingDeployer(Class<T> output) {
        super(output);
    }

    @Override
    public boolean isDeployable(VirtualFile file) {
        String fileName = file.getName();
        return this.matchFileName(fileName);
    }

    protected boolean matchFileName(String fileName) {
        String suffix = this.getSuffix();
        if (suffix == null) {
            return this.getNames() != null && this.getNames().contains(fileName);
        }
        return fileName.endsWith(suffix);
    }

    protected boolean accepts(VFSDeploymentUnit unit) throws DeploymentException {
        return true;
    }

    protected boolean accepts(DeploymentUnit unit) throws DeploymentException {
        if (!(unit instanceof VFSDeploymentUnit)) {
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("Not a vfs deployment: " + unit.getName()));
            }
            return false;
        }
        return this.accepts((VFSDeploymentUnit)unit);
    }

    protected MetaDataTypeFilter getMetaDataTypeFilter(DeploymentUnit unit) {
        if (this.filter != null) {
            return this.filter;
        }
        MetaDataTypeFilter mdtf = (MetaDataTypeFilter)unit.getAttachment(MetaDataTypeFilter.class);
        return mdtf != null ? mdtf : MetaDataTypeFilter.DEFAULT;
    }

    protected InputStream openStreamAndValidate(VirtualFile file) throws Exception {
        if (file == null) {
            throw new IllegalArgumentException("Null file");
        }
        InputStream inputStream = SecurityActions.openStream(file);
        if (inputStream == null) {
            throw new IOException("Null file stream: " + file);
        }
        return inputStream;
    }

    protected static Map<String, Class<?>> getAltMappings(DeploymentUnit unit) {
        if (unit == null) {
            throw new IllegalArgumentException("Null deployment unit");
        }
        return (Map)unit.getAttachment(ALT_MAPPINGS_MAP_KEY, Map.class);
    }

    protected VirtualFile getMetadataFile(VFSDeploymentUnit unit, Class<?> altExpectedClass, String originalName, boolean checkMetaDataFile) {
        String altPrefix = altExpectedClass != null ? altExpectedClass.getName() : originalName;
        VirtualFile file = (VirtualFile)unit.getAttachment(altPrefix + ".altDD", VirtualFile.class);
        if (file != null && altExpectedClass != null) {
            Map<String, Class<?>> altMappingsMap = AbstractVFSParsingDeployer.getAltMappings(unit);
            if (altMappingsMap == null) {
                altMappingsMap = new HashMap();
                unit.addAttachment(ALT_MAPPINGS_MAP_KEY, altMappingsMap, Map.class);
            }
            altMappingsMap.put(file.getName(), altExpectedClass);
        }
        if (checkMetaDataFile && file == null) {
            file = unit.getMetaDataFile(originalName, this.getMetaDataTypeFilter(unit));
        }
        return file;
    }

    protected Class<?> matchFileToClass(DeploymentUnit unit, String fileName) {
        Map<String, Class<?>> altMappingsMap = AbstractVFSParsingDeployer.getAltMappings(unit);
        return altMappingsMap != null ? altMappingsMap.get(fileName) : null;
    }

    protected boolean ignoreFile(final VFSDeploymentUnit unit, final VirtualFile file) {
        NameIgnoreMechanism mechanism = this.getNameIgnoreMechanism();
        if (mechanism != null) {
            LazyPath path = new LazyPath(){

                public String buildPath() {
                    try {
                        VirtualFile root = unit.getRoot();
                        return file.getPathNameRelativeTo(root);
                    }
                    catch (IllegalArgumentException e) {
                        return file.getPathName();
                    }
                }
            };
            return mechanism.ignorePath((DeploymentUnit)unit, path);
        }
        return false;
    }

    protected T parse(DeploymentUnit unit, String name, T root) throws Exception {
        if (this.ignoreName(unit, name)) {
            return null;
        }
        VFSDeploymentUnit vfsDeploymentUnit = (VFSDeploymentUnit)unit;
        VirtualFile file = this.getMetadataFile(vfsDeploymentUnit, this.getOutput(), name, true);
        return file != null && !this.ignoreFile(vfsDeploymentUnit, file) ? (T)this.parseAndInit(vfsDeploymentUnit, file, root) : null;
    }

    protected T parse(DeploymentUnit unit, Set<String> names, T root) throws Exception {
        if (names == null || names.isEmpty()) {
            throw new IllegalArgumentException("Null or empty names.");
        }
        VFSDeploymentUnit vfsDeploymentUnit = (VFSDeploymentUnit)unit;
        ArrayList<VirtualFile> files = new ArrayList<VirtualFile>();
        HashSet<String> missingFiles = new HashSet<String>();
        HashSet<String> ignoredFiles = new HashSet<String>();
        for (String name : names) {
            if (this.ignoreName(unit, name)) {
                ignoredFiles.add(name);
                continue;
            }
            VirtualFile file = this.getMetadataFile(vfsDeploymentUnit, this.matchFileToClass(unit, name), name, true);
            if (file != null) {
                if (this.ignoreFile(vfsDeploymentUnit, file)) {
                    ignoredFiles.add(file.getName());
                    continue;
                }
                files.add(file);
                continue;
            }
            missingFiles.add(name);
        }
        if (missingFiles.size() + ignoredFiles.size() == names.size()) {
            return null;
        }
        return this.mergeFiles(vfsDeploymentUnit, root, files, missingFiles);
    }

    protected T parse(DeploymentUnit unit, String name, String suffix, T root) throws Exception {
        VFSDeploymentUnit vfsDeploymentUnit;
        VirtualFile file;
        if (name == null && this.isIncludeDeploymentFile()) {
            name = unit.getName();
        }
        if ((file = this.getMetadataFile(vfsDeploymentUnit = (VFSDeploymentUnit)unit, this.getOutput(), name, false)) != null) {
            return this.parseAndInit(vfsDeploymentUnit, file, root, true);
        }
        List<VirtualFile> files = vfsDeploymentUnit.getMetaDataFiles(name, suffix, this.getMetaDataTypeFilter(unit));
        switch (files.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return this.parseAndInit(vfsDeploymentUnit, files.get(0), root, true);
            }
        }
        return this.handleMultipleFiles(vfsDeploymentUnit, root, files);
    }

    protected T parseAndInit(VFSDeploymentUnit unit, VirtualFile file, T root) throws Exception {
        return this.parseAndInit(unit, file, root, false);
    }

    protected T parseAndInit(VFSDeploymentUnit unit, VirtualFile file, T root, boolean checkIgnore) throws Exception {
        if (checkIgnore && this.ignoreFile(unit, file)) {
            return null;
        }
        T result = this.parse(unit, file, root);
        if (result != null) {
            this.init(unit, result, file);
        }
        return result;
    }

    protected T parse(DeploymentUnit unit, Set<String> names, String suffix, T root) throws Exception {
        if (names == null || names.isEmpty()) {
            throw new IllegalArgumentException("Null or empty names.");
        }
        VFSDeploymentUnit vfsDeploymentUnit = (VFSDeploymentUnit)unit;
        ArrayList<VirtualFile> files = new ArrayList<VirtualFile>();
        HashSet<String> missingFiles = new HashSet<String>();
        HashSet<String> ignoredFiles = new HashSet<String>();
        for (String name : names) {
            if (this.ignoreName(unit, name)) {
                ignoredFiles.add(name);
                continue;
            }
            VirtualFile file = this.getMetadataFile(vfsDeploymentUnit, this.matchFileToClass(unit, name), name, false);
            if (file == null) {
                List<VirtualFile> matched = vfsDeploymentUnit.getMetaDataFiles(name, suffix, this.getMetaDataTypeFilter(unit));
                if (matched != null && !matched.isEmpty()) {
                    for (VirtualFile m : matched) {
                        if (this.ignoreFile(vfsDeploymentUnit, m)) {
                            ignoredFiles.add(m.getName());
                            continue;
                        }
                        files.add(m);
                    }
                    continue;
                }
                missingFiles.add(name);
                continue;
            }
            if (this.ignoreFile(vfsDeploymentUnit, file)) {
                ignoredFiles.add(file.getName());
                continue;
            }
            files.add(file);
        }
        if (missingFiles.size() + ignoredFiles.size() == names.size()) {
            return null;
        }
        return this.mergeFiles(vfsDeploymentUnit, root, files, missingFiles);
    }

    protected T mergeFiles(VFSDeploymentUnit unit, T root, List<VirtualFile> files, Set<String> missingFiles) throws Exception {
        return null;
    }

    protected T handleMultipleFiles(VFSDeploymentUnit unit, T root, List<VirtualFile> files) throws Exception {
        if (!this.allowsMultipleFiles(files)) {
            throw new IllegalArgumentException("Multiple matching files not allowed: " + files);
        }
        for (VirtualFile file : files) {
            T result;
            if (this.ignoreFile(unit, file) || (result = this.parse(unit, file, root)) == null) continue;
            this.init(unit, result, file);
            unit.addAttachment(file.toURL().toString(), result, this.getOutput());
        }
        return null;
    }

    protected boolean allowsMultipleFiles(List<VirtualFile> files) {
        return this.allowMultipleFiles;
    }

    protected abstract T parse(VFSDeploymentUnit var1, VirtualFile var2, T var3) throws Exception;

    protected void init(VFSDeploymentUnit unit, T metaData, VirtualFile file) throws Exception {
    }

    public void setAllowMultipleFiles(boolean allowMultipleFiles) {
        this.allowMultipleFiles = allowMultipleFiles;
    }

    public void setFilter(MetaDataTypeFilter filter) {
        this.filter = filter;
    }
}

