/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.protocol.mgmt;

import java.io.DataInput;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.jboss.as.protocol.ProtocolMessages;

public final class ProtocolUtils {
    public static void expectHeader(InputStream input, int expected) throws IOException {
        ProtocolUtils.expectHeader(ProtocolUtils.readByte(input), expected);
    }

    public static void expectHeader(DataInput input, int expected) throws IOException {
        ProtocolUtils.expectHeader(input.readByte(), expected);
    }

    public static void expectHeader(byte actual, int expected) throws IOException {
        if (actual != (byte)expected) {
            throw ProtocolMessages.MESSAGES.invalidByteToken(expected, actual);
        }
    }

    public static int readInt(InputStream in) throws IOException {
        int ch4;
        int ch3;
        int ch2;
        int ch1 = in.read();
        if ((ch1 | (ch2 = in.read()) | (ch3 = in.read()) | (ch4 = in.read())) < 0) {
            throw new EOFException();
        }
        return (ch1 << 24) + (ch2 << 16) + (ch3 << 8) + (ch4 << 0);
    }

    public static void writeInt(OutputStream out, int v) throws IOException {
        out.write(v >>> 24 & 0xFF);
        out.write(v >>> 16 & 0xFF);
        out.write(v >>> 8 & 0xFF);
        out.write(v >>> 0 & 0xFF);
    }

    public static byte readByte(InputStream stream) throws IOException {
        int b = stream.read();
        if (b == -1) {
            throw new EOFException();
        }
        return (byte)b;
    }
}

