/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.naming.subsystem;

import java.util.List;
import java.util.concurrent.Executors;
import javax.naming.CompositeName;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.jboss.as.controller.AbstractBoottimeAddStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.naming.InitialContextFactoryBuilder;
import org.jboss.as.naming.NamingContext;
import org.jboss.as.naming.NamingLogger;
import org.jboss.as.naming.NamingStore;
import org.jboss.as.naming.ServiceBasedNamingStore;
import org.jboss.as.naming.WritableServiceBasedNamingStore;
import org.jboss.as.naming.context.NamespaceContextSelector;
import org.jboss.as.naming.deployment.ContextNames;
import org.jboss.as.naming.deployment.JndiNamingDependencyProcessor;
import org.jboss.as.naming.deployment.JndiNamingDependencySetupProcessor;
import org.jboss.as.naming.management.JndiViewExtensionRegistry;
import org.jboss.as.naming.remote.RemoteNamingServerService;
import org.jboss.as.naming.service.NamingService;
import org.jboss.as.naming.service.NamingStoreService;
import org.jboss.as.naming.subsystem.NamingSubsystemOSGiService;
import org.jboss.as.remoting.RemotingServices;
import org.jboss.as.server.AbstractDeploymentChainStep;
import org.jboss.as.server.DeploymentProcessorTarget;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.Phase;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.remoting3.Endpoint;

public class NamingSubsystemAdd
extends AbstractBoottimeAddStepHandler {
    private static final CompositeName EMPTY_NAME = new CompositeName();
    static final NamingSubsystemAdd INSTANCE = new NamingSubsystemAdd();

    protected void populateModel(ModelNode operation, ModelNode model) {
        model.setEmptyObject();
    }

    protected void performBoottime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) {
        NamingLogger.ROOT_LOGGER.activatingSubsystem();
        NamingContext.initializeNamingManager();
        WritableServiceBasedNamingStore namingStore = new WritableServiceBasedNamingStore(context.getServiceRegistry(false), ContextNames.JAVA_CONTEXT_SERVICE_NAME);
        ServiceTarget target = context.getServiceTarget();
        newControllers.add(target.addService(NamingService.SERVICE_NAME, (Service)new NamingService(namingStore)).addAliases(new ServiceName[]{ContextNames.JAVA_CONTEXT_SERVICE_NAME}).setInitialMode(ServiceController.Mode.ACTIVE).addListener((ServiceListener)verificationHandler).install());
        final WritableServiceBasedNamingStore globalNamingStore = new WritableServiceBasedNamingStore(context.getServiceRegistry(false), ContextNames.GLOBAL_CONTEXT_SERVICE_NAME);
        newControllers.add(target.addService(ContextNames.GLOBAL_CONTEXT_SERVICE_NAME, (Service)new NamingStoreService(globalNamingStore)).setInitialMode(ServiceController.Mode.ACTIVE).addListener((ServiceListener)verificationHandler).install());
        final WritableServiceBasedNamingStore jbossNamingStore = new WritableServiceBasedNamingStore(context.getServiceRegistry(false), ContextNames.JBOSS_CONTEXT_SERVICE_NAME);
        newControllers.add(target.addService(ContextNames.JBOSS_CONTEXT_SERVICE_NAME, (Service)new NamingStoreService(jbossNamingStore)).setInitialMode(ServiceController.Mode.ACTIVE).addListener((ServiceListener)verificationHandler).install());
        NamespaceContextSelector.setDefault(new NamespaceContextSelector(){

            @Override
            public Context getContext(String identifier) {
                ServiceBasedNamingStore namingStore = identifier.equals("global") ? globalNamingStore : (identifier.equals("jboss") ? jbossNamingStore : null);
                if (namingStore != null) {
                    try {
                        return (Context)namingStore.lookup(EMPTY_NAME);
                    }
                    catch (NamingException e) {
                        throw new IllegalStateException(e);
                    }
                }
                return null;
            }
        });
        newControllers.add(NamingSubsystemOSGiService.addService(target, InitialContext.class, InitialContext.class, verificationHandler));
        newControllers.add(NamingSubsystemOSGiService.addService(target, javax.naming.spi.InitialContextFactoryBuilder.class, InitialContextFactoryBuilder.class, verificationHandler));
        newControllers.add(target.addService(JndiViewExtensionRegistry.SERVICE_NAME, (Service)new JndiViewExtensionRegistry()).install());
        WritableServiceBasedNamingStore remoteExposedNamingStore = new WritableServiceBasedNamingStore(context.getServiceRegistry(false), ContextNames.EXPORTED_CONTEXT_SERVICE_NAME);
        newControllers.add(target.addService(ContextNames.EXPORTED_CONTEXT_SERVICE_NAME, (Service)new NamingStoreService(remoteExposedNamingStore)).setInitialMode(ServiceController.Mode.ACTIVE).addListener((ServiceListener)verificationHandler).install());
        RemoteNamingServerService remoteNamingServerService = new RemoteNamingServerService();
        newControllers.add(target.addService(RemoteNamingServerService.SERVICE_NAME, (Service)remoteNamingServerService).addDependency(RemotingServices.SUBSYSTEM_ENDPOINT, Endpoint.class, remoteNamingServerService.getEndpointInjector()).addDependency(ContextNames.EXPORTED_CONTEXT_SERVICE_NAME, NamingStore.class, remoteNamingServerService.getNamingStoreInjector()).addInjection(remoteNamingServerService.getExecutorServiceInjector(), (Object)Executors.newFixedThreadPool(10)).addListener((ServiceListener)verificationHandler).setInitialMode(ServiceController.Mode.ACTIVE).install());
        context.addStep((OperationStepHandler)new AbstractDeploymentChainStep(){

            protected void execute(DeploymentProcessorTarget processorTarget) {
                processorTarget.addDeploymentProcessor(Phase.INSTALL, 256, (DeploymentUnitProcessor)new JndiNamingDependencySetupProcessor());
                processorTarget.addDeploymentProcessor(Phase.INSTALL, 7169, (DeploymentUnitProcessor)new JndiNamingDependencyProcessor());
            }
        }, OperationContext.Stage.RUNTIME);
    }
}

