/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.component.interceptors;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.jboss.as.ee.EeMessages;

public class OrderedItemContainer<T> {
    private final Map<Integer, T> items = new HashMap<Integer, T>();
    private volatile List<T> sortedItems;

    public void add(T item, int priority) {
        if (this.sortedItems != null) {
            throw EeMessages.MESSAGES.cannotAddMoreItems();
        }
        if (item == null) {
            throw EeMessages.MESSAGES.nullVar("item");
        }
        T current = this.items.get(priority);
        if (current != null) {
            throw EeMessages.MESSAGES.priorityAlreadyExists(item, Integer.toHexString(priority), current);
        }
        this.items.put(priority, item);
    }

    public List<T> getSortedItems() {
        if (this.sortedItems == null) {
            TreeMap<Integer, T> sortedMap = new TreeMap<Integer, T>(this.items);
            this.sortedItems = new ArrayList(sortedMap.values());
        }
        return this.sortedItems;
    }
}

