/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.managedbean.component;

import org.jboss.as.ee.EeLogger;
import org.jboss.as.ee.EeMessages;
import org.jboss.as.ee.component.ComponentTypeInjectionSource;
import org.jboss.as.ee.component.InjectionSource;
import org.jboss.as.ee.component.deployers.EEResourceReferenceProcessor;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;

public class ManagedBeanResourceReferenceProcessor
implements EEResourceReferenceProcessor {
    private final String managedBeanClassName;

    public ManagedBeanResourceReferenceProcessor(String managedBeanClassName) {
        if (managedBeanClassName == null || managedBeanClassName.trim().isEmpty()) {
            throw EeMessages.MESSAGES.nullOrEmptyManagedBeanClassName();
        }
        this.managedBeanClassName = managedBeanClassName;
    }

    @Override
    public String getResourceReferenceType() {
        return this.managedBeanClassName;
    }

    @Override
    public InjectionSource getResourceReferenceBindingSource() throws DeploymentUnitProcessingException {
        EeLogger.ROOT_LOGGER.debugf("Processing @Resource of type: %s", this.managedBeanClassName);
        ComponentTypeInjectionSource bindingSource = new ComponentTypeInjectionSource(this.managedBeanClassName);
        return bindingSource;
    }
}

