/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.component;

import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.jboss.as.ee.EeMessages;
import org.jboss.as.ee.component.InjectionSource;
import org.jboss.as.naming.ManagedReference;
import org.jboss.as.naming.ManagedReferenceFactory;
import org.jboss.as.naming.ValueManagedReference;
import org.jboss.as.naming.deployment.ContextNames;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.value.ImmediateValue;
import org.jboss.msc.value.Value;

public final class OptionalLookupInjectionSource
extends InjectionSource {
    private final String lookupName;

    public OptionalLookupInjectionSource(String lookupName) {
        if (lookupName == null) {
            throw EeMessages.MESSAGES.nullVar("lookupName");
        }
        this.lookupName = lookupName;
    }

    @Override
    public void getResourceValue(InjectionSource.ResolutionContext resolutionContext, ServiceBuilder<?> serviceBuilder, DeploymentPhaseContext phaseContext, Injector<ManagedReferenceFactory> injector) {
        String applicationName = resolutionContext.getApplicationName();
        String moduleName = resolutionContext.getModuleName();
        String componentName = resolutionContext.getComponentName();
        boolean compUsesModule = resolutionContext.isCompUsesModule();
        String lookupName = !this.lookupName.contains("java:") ? (componentName != null && !compUsesModule ? "java:comp/env/" + this.lookupName : (compUsesModule ? "java:module/env/" + this.lookupName : "java:jboss/env" + this.lookupName)) : (this.lookupName.startsWith("java:comp/") && compUsesModule ? "java:module/" + this.lookupName.substring(10) : this.lookupName);
        ContextNames.BindInfo bindInfo = ContextNames.bindInfoFor((String)applicationName, (String)moduleName, (String)componentName, (String)lookupName);
        serviceBuilder.addDependency(ServiceBuilder.DependencyType.OPTIONAL, bindInfo.getBinderServiceName());
        injector.inject((Object)new OptionalLookupManagedReferenceFactory(lookupName));
    }

    public boolean equals(Object configuration) {
        if (configuration instanceof OptionalLookupInjectionSource) {
            OptionalLookupInjectionSource lookup = (OptionalLookupInjectionSource)configuration;
            return this.lookupName.equals(lookup.lookupName);
        }
        return false;
    }

    public int hashCode() {
        return this.lookupName.hashCode();
    }

    private static class OptionalLookupManagedReferenceFactory
    implements ManagedReferenceFactory {
        private final String lookupName;

        public OptionalLookupManagedReferenceFactory(String lookupName) {
            this.lookupName = lookupName;
        }

        public ManagedReference getReference() {
            try {
                Object value = new InitialContext().lookup(this.lookupName);
                return new ValueManagedReference((Value)new ImmediateValue(value));
            }
            catch (NamingException e) {
                return null;
            }
        }
    }
}

