/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.management.security;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.as.domain.management.security.PlugInLoaderService;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;

abstract class AbstractPlugInService {
    private final InjectedValue<PlugInLoaderService> plugInLoader = new InjectedValue();
    private final ModelNode model;
    private String name;
    private Map<String, String> configurationProperties;

    AbstractPlugInService(ModelNode model) {
        this.model = model;
    }

    public InjectedValue<PlugInLoaderService> getPlugInLoaderServiceValue() {
        return this.plugInLoader;
    }

    public void start(StartContext context) throws StartException {
        this.name = this.model.require("name").asString();
        if (this.model.hasDefined("property")) {
            List propertyList = this.model.require("property").asPropertyList();
            HashMap<String, String> configurationProperties = new HashMap<String, String>(propertyList.size());
            for (Property current : propertyList) {
                String propertyName = current.getName();
                String value = null;
                if (current.getValue().hasDefined("value")) {
                    value = current.getValue().require("value").asString();
                }
                configurationProperties.put(propertyName, value);
            }
            this.configurationProperties = Collections.unmodifiableMap(configurationProperties);
        } else {
            this.configurationProperties = Collections.emptyMap();
        }
    }

    public void stop(StopContext context) {
        this.name = null;
        this.configurationProperties = null;
    }

    protected String getPlugInName() {
        return this.name;
    }

    protected Map<String, String> getConfiguration() {
        return this.configurationProperties;
    }

    protected PlugInLoaderService getPlugInLoader() {
        return (PlugInLoaderService)this.plugInLoader.getValue();
    }
}

