/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.testenricher.msc;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import javax.inject.Inject;
import org.jboss.arquillian.test.spi.TestEnricher;
import org.jboss.arquillian.testenricher.msc.ServiceTargetAssociation;
import org.jboss.as.server.CurrentServiceContainer;
import org.jboss.msc.service.ServiceContainer;
import org.jboss.msc.service.ServiceTarget;

public class MSCTestEnricher
implements TestEnricher {
    public void enrich(Object testCase) {
        Class<?> testClass = testCase.getClass();
        for (Field field : testClass.getDeclaredFields()) {
            if (!field.isAnnotationPresent(Inject.class)) continue;
            if (field.getType().isAssignableFrom(ServiceContainer.class)) {
                this.injectServiceContainer(testCase, field);
                continue;
            }
            if (!field.getType().isAssignableFrom(ServiceTarget.class)) continue;
            this.injectServiceTarget(testCase, field);
        }
    }

    public Object[] resolve(Method method) {
        return null;
    }

    private void injectServiceContainer(Object testCase, Field field) {
        try {
            ServiceContainer serviceContainer = CurrentServiceContainer.getServiceContainer();
            field.set(testCase, serviceContainer);
        }
        catch (IllegalAccessException ex) {
            throw new IllegalStateException("Cannot inject ServiceContainer", ex);
        }
    }

    private void injectServiceTarget(Object testCase, Field field) {
        try {
            ServiceTarget serviceTarget = ServiceTargetAssociation.getServiceTarget(testCase.getClass().getName());
            field.set(testCase, serviceTarget);
        }
        catch (IllegalAccessException ex) {
            throw new IllegalStateException("Cannot inject ServiceTarget", ex);
        }
    }
}

